#include "fhostd.h"

/*************************************************************
 *                                                           *
 *   Turn the calling process into a daemon process.         *
 *                                                           *
 *************************************************************/

#define OPEN_MAX_GUESS	1024

int daemon_init(void)
{
#ifdef OPEN_MAX
	int openmax = OPEN_MAX;
#else
	int openmax = 0;
#endif
        FILE *file;
	int i;

        switch (fork()) { /* Create a child and orphan it. */
        case -1:
          log_err (use_syslog, P_ERROR, "daemon_init: fork");
          /* NOTREACHED */
        default:
          exit(0);    /* The parent goes bye-bye. */
        case 0:;
          /* DROPTHROUGH */
        } /* End Switch */

	/* The child continues */
 
	setsid();	/* Become a session leader */
	chdir("/");	/* Change the working directory. */
	umask(0);	/* Clear our file mode creation mask */

	/* Close a bunch of descriptors. */

	if (openmax == 0)
	  if ((openmax = getdtablesize()) < 0)
	    openmax = OPEN_MAX_GUESS;

	for (i=0; i<openmax; i++)
	  close(i);

	if (geteuid() > 0) return (0); /* return if not r00t */

	/* If we are running as r00t then store the pid in PID_PATH. */

	if ((file = fopen(PIDPATH, "w")) == NULL)
	  log_err (use_syslog, P_ERROR, "daemon_init: fopen");

	fprintf(file,"%d",getpid());
	fclose(file);

	return(0);
}
