/*

COPYRIGHT POLICY
----------------
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
You should have received a copy of the GNU General Public License along
with this program; if not, write to Free Software Foundation, Inc.
675 Mass Ave, Cambridge, MA 02139, USA.

Copyright (C) 1998 Luc Deschenaux <lcd@gkb.com>

DISCLAIMER
----------
Use it at your own risk. You're sole responsible for anything that could
happend before, while, after or without using this program.

*/

//#define fork() 0
#define _LINUX
//#define _WIN32
//#define _MACOS

#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#include <tcl.h>
#include <string.h>

#ifdef _MACOS

   #include <Types.h>
   #include <Memory.h>
   #include <Quickdraw.h>
   #include <Fonts.h>
   #include <Events.h>
   #include <Menus.h>
   #include <Windows.h>
   #include <TextEdit.h>
   #include <Dialogs.h>
   #include <OSUtils.h>
   #include <ToolUtils.h>
   #include <SegLoad.h>
   #include <Sound.h>
   #include <string.h>
   #include <GUSI.h>
   #include <syserrno.h>
   #include <unistd.h>

   #ifndef ulong
      #define ulong unsigned long
   #endif
   #ifndef u_long
      #define u_long unsigned long
   #endif

   #define pid_t ulong
   #define syslog fprintf
   #define LOG_ERR logfile
   #define LOG_WARNING logfile
   #define LOG_INFO logfile
   #define LOG_CRIT logfile
   #define LOG_NOTICE logfile
   #define LOG_DEBUG logfile
   #define kConnectTimeOut 30
   #define INVALID_SOCKET -1
   #define WSAGetLastError() errno 

FILE *logfile=0;

#endif

#ifdef _WIN32

   #ifndef ulong
      #define ulong unsigned long
   #endif

   #define pid_t ulong
   #define syslog fprintf
   #ifdef LOG_ERR
      #undef LOG_ERR
      #undef LOG_WARNING
      #undef LOG_INFO
      #undef LOG_CRIT
      #undef LOG_NOTICE
      #undef LOG_DEBUG
   #endif

   #define LOG_ERR logfile
   #define LOG_WARNING logfile
   #define LOG_INFO logfile
   #define LOG_CRIT logfile
   #define LOG_NOTICE logfile
   #define LOG_DEBUG logfile

   #define alarm(d) d
//#define signal(a,b) 0

   #include <winsock.h>
   #include <winbase.h>
 // #include "telnet.h"

   #define close(a) closesocket((unsigned int)a)
   #define EWOULDBLOCK WSAEWOULDBLOCK
   #define EINPROGRESS WSAEINPROGRESS
   #define ENETDOWN WSAENETDOWN 
   #define EINTR WSAEINTR
   #define ENOTSOCK WSAENOTSOCK
   #define ECONNRESET WSAECONNRESET
   #define EADDRINUSE WSAEADDRINUSE
   #define ECONNREFUSED WSAECONNREFUSED
   #define EMFILE WSAEMFILE
   #define ENETUNREACH WSAENETUNREACH
   #define ENOBUFS WSAENOBUFS
   #define ETIMEDOUT WSAETIMEDOUT
   #define ENETRESET WSAENETRESET
   #define ENOTCONN WSAENOTCONN
   #define EOPNOTSUPP WSAEOPNOTSUPP
   #define ESHUTDOWN WSAESHUTDOWN
   #define ECONNABORTED WSAECONNABORTED
   #define EADDRNOTAVAIL WSAEADDRNOTAVAIL
   #define EINVAL WSAEINVAL


   #define getpid GetCurrentProcessId
   #define chdir SetCurrentDirectory  
   #define write(a,b,c) send(a,b,c,0)
   #define read(a,b,c) recv(a,b,c,0)
   #define sleep(x) Sleep(1000*x)
   #define getdtablesize() 0
   #define noErr 0
   #define SIGALRM 14
   #define kConnectTimeOut 0
   #define errno WSAGetLastError()

FILE *logfile=0;
SOCKET gSocket=0;
HANDLE gCurProcess=0;

#endif

#ifdef _LINUX

   #include <sys/errno.h>
   #include <sys/types.h>
   #include <sys/socket.h>
   #include <netinet/in.h>
   #include <arpa/inet.h>
   #include <arpa/telnet.h>
   #include <sys/time.h>
   #include <sys/timeb.h>
   #include <netdb.h>
   #include <pwd.h>
   #include <sys/syslog.h>
   #include <signal.h>
   #include <setjmp.h>

   #define INVALID_SOCKET -1
   #define WSAGetLastError() errno 
   #define kConnectTimeOut 30

#endif

#define kDenyFile "conf/vftpd.deny"
#define kAllowFile "conf/vftpd.allow"
#define kInitFile "tcl/vftpd_init.tcl"
#define kHamFile "run/vftpd.ham"
#define kPidFile "run/vftpd.pids"

#define lowercase(c) ((c>'Z' || c<'A')?c:c+32)
#define uppercase(c) ((c>'z' || c<'a')?c:c-32)
#define forwardCommand() sendCommand(gUser->s[1],gUser->in_buf)

#define	log_emerg	0	/* system is unusable */
#define	log_alert	1	/* action must be taken immediately */
#define	log_crit	   2	/* critical conditions */
#define	log_err		3	/* error conditions */
#define	log_warning	4	/* warning conditions */
#define	log_notice	5	/* normal but significant condition */
#define	log_info  	6	/* informational */
#define	log_debug	7	/* debug-level messages */

#define true 1
#define false 0
#define kDefaultDataPort 20

char *eNETDOWN="Network is down.";
char *eINTR="Blocking call canceled.";
char *eINVAL="Invalid parameter.";
char *eINPROGRESS="Blocking call in progress";
char *eNOTCONN="Not connected.";
char *eNOTSOCK="Socket error.";
char *eOPNOTSUPP="The socket is not of type SOCK_STREAM.";
char *eSHUTDOWN="Socket is closed.";
char *eCONNABORTED="Connection aborted.";
char *eCONNRESET="Connection reset by peer.";
char *eADDRINUSE="The specified address is already in use.";
char *eTIMEDOUT="Operation timed out.";
char *eOOM="Out of memory.";
char *eADDRNOTAVAIL="Address not available.";
char *eCONNREFUSED="Connection refused.";
char *eMFILE="Out of file descriptors.";
char *eNETUNREACH="Network unreachable.";
char *eNOBUFS="Out of buffer space.";
char *eWOULDBLOCK="Operation would block.";
char *eNETRESET="Connection dropped.";
char *ePIPE="Broken pipe.";
char *eNotEnoughP="Not enough parameters.";
char *defNewline="\r\n";
char *otherNewline="\r";

char *eAlready="530 Already logged in.\r\n";
char *eUSERfirst="503 Login with USER first.\r\n";
char *ePleaseLogin="530 Please login with USER and PASS.\r\n"; 
char *eBadLogin="530 Login incorrect.\r\n";
char *iPassRequired="331 Password required for %s.\r\n"; 
char *gGoodbyeMsg="221 Goodbye.\r\n";
char *iDlCredit="226- Your download credit is now %d Kb.\r\n";
char *iTransferComp="226 Transfer complete.\r\n";
char *iLoggedIn="230 User %s logged in.\r\n";
char *eTooLong="500 Command buffer overflow.\r\n";
char *eSyntaxError="500 '%s': command not understood.\r\n";
char *iPWD="257 \"%s\" is current directory.\r\n";
char *eMaxCon="421 Maximum number of connections reached. Try again later.\r\n";
char *eClosed="421 Control connection closed.\r\n";
char *eNotImplemented="502 Command not implemented.\r\n";
char *eIllegalPORT="500 Illegal PORT Command.\r\n"; 
char *ePORTfailed="400 PORT command failed.\r\n";
char *ePASVinvalid="500 Can't parse PASV reply.\r\n";
char *ePASVfailed="400 PASV command failed.\r\n";
char *eDataCon="425 Can't build data connection.\r\n";
char *eControlCon="425 Can't build control connection.\r\n";
char *iCWD="250 CWD command successful.\r\n";
char *eNoSuchFile="550 %s: No such file or directory.\r\n";
char *eRatio="553- Your download credit is now %d Kb.\r\n"; 
char *ePermDenied="553 %s: Permission denied. %s\r\n";
char *iDataCon="150 Opening BINARY mode data connection for %s (%lu bytes).\r\n"; // may be ASCII.. 
char *eTransfer="426 Transfer aborted. Data connection closed.\r\n";
char *gWelcomeMsg="220 vftpd gateway (Version 0.5a Thu Feb 4 17:41:26 GMT+1 1999) ready.\r\n";

#define kInBufSize 32767
#define kUmask 022

enum
{
   down_perm=1,
   up_perm=2,
   chg_perm=4
};

typedef struct User User;

struct User
{
   char *login;
   char *pass;
   short port;
   short maxCon;
   short maxIdle;
   char *address;
   short server_port;
   char *server_login;
   char *server_pass;
   char *path;
   char chroot;
   char perms;
   short ratio;
   ulong ul;
   ulong dl;
   char cache_enable;
   char *cache_dir;
   char *newline;
   char strictIP;

   char pasv;
   int s[4];
   struct sockaddr_in addr[4];
   char *in_buf;
   size_t len;
   char *d_buf;
   size_t d_len;
};

#ifndef pid_t
   #define pid_t ulong
#endif
typedef struct
{
   pid_t pid;
   char *user;

} pidfilerec;

typedef struct
{
   long ip;
   time_t t;

} hamrec;

int status=0;
char *gConfigFile=0;
User *gUsers=0;
char **gStrings=0;
int nUsers=0;
int nStrings=0;
char *gHostName=0;
int gErr=0;
char *where=0;
char *gLineIP=0;
short gPort=0;
long gHamTime=0;
short gHamCount=0;
#ifdef _WIN32
time_t gTimeOut=0;
#else
time_t gTimeOut=180;
#endif
char *gWD=0;
User *gUser=0;
char *gPath=0;
ulong gRest=0;
ulong cmd;
char gDaemon=0;
ulong isThere=0;
char isThereFlag=0;
char gCacheFile=0;
size_t gConfigFileSize;
char gBanClass=0;
char gHostsDeny=0;
char gPortInCmdLine=0;
char *gString=0;
char *gMode="BINARY";
char gLog=log_warning;
char gUserAtHost=1;
char *gAppWD=0;
char *gInitFile=0;
char *gDenyFile=0;
char *gAllowFile=0;
char *gHamFile=0;
char *gPidFile=0;
char gStrictIP=0;

void oom(void);
void exit_program(int status);
int ReadConfigFile(char *name);
int listenPort(int *s,struct sockaddr_in *addr,char n,short port);
int newSocket(void);
int resolve(char *host);
void errorMsg(int err);
void WaitConnections(void);
int CanRead(int sock,int blocking);
int CanWrite(int sock,int blocking);
void blocking_call_timedout(int value);
void out(int sock,char *out_buf,size_t *length,char useCopy);
int cmd_in(int s,char *in_buf,size_t len,char isReply);
void WaitConnections(void);
void login(int s,struct sockaddr_in *addr);
void LoggedIn(User *user);
int PWD(char forward);
char *ftpGet(char *filename,char pipe,char put,char cache);
void AutoBan(long ip);
int rejectIP(long ip);

void sfree(void **p)
{  
   if (*p)
   {  free(*p);
      *p=0;
   }

} // sfree

void *mymalloc(size_t size)
{  
   void *p=0;
   
   if (size)
   {  p=(void*)malloc(size);
      if (!p) 
         oom();
   }
   return p;

} // mymalloc

char *mystrdup(char *s)
{
   char *s2;
   
   if (!s)
      return 0;

   if (!s[0])
   {  s2=mymalloc(1);
      *s2=0;
   } 
   else
   {  s2=(char*)strdup(s);
      if (!s2)
        oom();
   }

   return s2;

} // mystrdup

char *addWD(char *filename)
{  
   char *name;
   
   name=mymalloc(strlen(gAppWD)+strlen(filename)+2);
   strcpy(name,gAppWD);
   if (name[strlen(name)-1]!='/')
      strcat(name,"/");
   strcat(name,filename);
   return name;

} // addWD

char *stripcr(char *c)
{
   char *k=(char*)strpbrk(c,"\r\n");
   sfree((void**)&gString);

#ifdef _LINUX
   if (!k) return c;
   gString=mystrdup(c);
   gString[k-c]=0;
#else
   if (k) return c;
   gString=mymalloc(strlen(c)+2);
   strcpy(gString,c);
   strcat(gString,"\n");
#endif

   return gString;   

} // stripcr

void parsecmdline(int *argc,char **argv,char *cmdline,short maxargs)
{
   char *c=mystrdup(cmdline);

   *argc=0;

   while (true)
   {
      if (*argc==maxargs)
         break;
      c=(char*)strtok(*argc>1?0:c," \n\t");
      if (c)
      {  argv[*argc]=mystrdup(c);
         ++*argc;
      }
      else
      {  argv[*argc]=0;
         break;
      }
   }  

} // parsecmdline

void broken_pipe(int value)
{
   if (gLog>=log_err) syslog(LOG_ERR,stripcr(ePIPE));
   exit_program(1);

} // broken_pipe

void blocking_call_timedout(int value)
{
   if (gLog>=log_err) syslog(LOG_ERR,stripcr(eTIMEDOUT));
   exit_program(1);

} // blocking_call_timedout

void errorMsg(int err)
{
   if (!err)
      return;

   switch (err)
   {
   case ENETDOWN:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eNETDOWN));
      break;
   case EADDRINUSE:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eADDRINUSE));
      break;
   case EINTR:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eINTR));
      break;
   case EINPROGRESS:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eINPROGRESS));
      break;
   case ECONNREFUSED:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eCONNREFUSED));
      break;
   case EMFILE:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eMFILE));
      break;
   case ENETUNREACH:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eNETUNREACH));
      break;
   case ENOBUFS:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eNOBUFS));
      break;
   case ETIMEDOUT:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eTIMEDOUT));
      break;
   case EWOULDBLOCK:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eWOULDBLOCK));
      break;
   case ENETRESET:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eNETRESET));
      break;
   case ENOTCONN:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eNOTCONN));
      break;
   case EOPNOTSUPP:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eOPNOTSUPP));
      break;
   case ESHUTDOWN:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eSHUTDOWN));
      break;
   case ECONNABORTED:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eCONNABORTED));
      break;
   case EADDRNOTAVAIL:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eADDRNOTAVAIL));
      break;
   case ECONNRESET:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eCONNRESET));
      break;
   case ENOTSOCK:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr(eNOTSOCK));
      break;
   case EPIPE:
     if (gLog>=log_err) syslog(LOG_ERR,stripcr(ePIPE));
     break;
   default:
      if (gLog>=log_err) syslog(LOG_ERR,stripcr("An unexpected error occured. %s (%d).\n"),where,err);
      break;

   }

} // errorMsg

void freeUser(int i)
{
   sfree((void**)&gUsers[i].login);
   sfree((void**)&gUsers[i].pass);
   sfree((void**)&gUsers[i].address);
   sfree((void**)&gUsers[i].server_login);
   sfree((void**)&gUsers[i].server_pass);
   sfree((void**)&gUsers[i].path);
   sfree((void**)&gUsers[i].cache_dir);

} // freeUser

void exit_program(int status)
{
   sfree((void**)&gPath);
   sfree((void**)&gString);

   if (nUsers)
   {
      ulong i;

      if (gConfigFile)
         sfree((void**)&gConfigFile);

      if (gUser)
         for (i=0;i<4;++i)
            if (gUser->s[i])
            {  close(gUser->s[i]);
               gUser->s[i]=0;
            }

      for (i=0;i<nUsers;++i)
         freeUser(i);
      sfree((void**)&gUsers);
   }

   if (gLog>=log_notice) syslog(LOG_NOTICE,"exit with status %d",status);

#ifdef _WIN32
   WSACleanup();
#endif
#ifndef _LINUX
   if (logfile)
      fclose(logfile);
#endif 
   exit(status);

} // exit_program

void oom(void)
{  if (gLog>=log_crit) syslog(LOG_CRIT,stripcr(eOOM));
   exit_program(1);
} // oom


int ReadConfigFile(char *name)
{

   FILE *file=0;
   fpos_t toread;
   size_t count;
   char *eCantRead="can't read file %s.\n";
   char *buf;

#define cantread() {if (gLog>=log_err) syslog(LOG_ERR,stripcr(eCantRead),name); fclose(file); return 0;}

   file=fopen(name,"r");
   if (!file)
      return 0;

   if (fseek(file,0,SEEK_END))
      cantread();

   if (fgetpos(file,&toread))
      cantread();


   if (!toread)
   {  //if (gLog>=log_info) syslog(LOG_INFO,"config file is empty.");
      fclose(file);
      return 0;      
   }

   gConfigFile=malloc((size_t)toread+2);
   gConfigFileSize=toread;

   if (!gConfigFile)
   {  fclose(file);
      oom();
   }

   if (fseek(file,0,SEEK_SET))
      cantread();

   buf=gConfigFile;
   count=0;

   while (true)
   {  count=fread(buf,1,(size_t)toread,file);
      if (count==0)
      {  if (feof(file))
            break;
         else
            cantread();
      }
      buf+=count;
   }

   fclose(file);

   return 1;

} // ReadConfigFile

int vftpd_RegisterUser(ClientData data,Tcl_Interp *interp,int argc,char **argv)
{
   if (argc!=21)
   {
#ifndef _WIN32
      if (gLog>=log_err) syslog(LOG_ERR,stripcr("Wrong # of parameters."));
#else
      fprintf(stderr,stripcr("Wrong # of parameters."));
#endif
      return TCL_ERROR;
   }
   if (nUsers==0)
      gUsers=mymalloc(2*sizeof(User));
   else
   {  gUsers=realloc(gUsers,(nUsers+2)*sizeof(User));
      if (!gUsers) oom();
   }

   gUsers[nUsers].login=mystrdup(argv[1]);
   gUsers[nUsers].pass=mystrdup(argv[2]);
   gUsers[nUsers].port=atoi(argv[3]);
   gUsers[nUsers].maxCon=atoi(argv[4]);
   gUsers[nUsers].maxIdle=atoi(argv[5]);
   gUsers[nUsers].address=mystrdup(argv[6]);
   gUsers[nUsers].server_port=atoi(argv[7]);
   gUsers[nUsers].server_login=mystrdup(argv[8]);
   gUsers[nUsers].server_pass=mystrdup(argv[9]);
   gUsers[nUsers].path=mystrdup(argv[10]);
   gUsers[nUsers].chroot=atoi(argv[11]);
   gUsers[nUsers].perms=atoi(argv[12]);
   gUsers[nUsers].perms|=atoi(argv[13])<<1;
   gUsers[nUsers].perms|=atoi(argv[14])<<2;
   if (atoi(argv[15]))
      gUsers[nUsers].ratio=atoi(argv[16]);
   else
      gUsers[nUsers].ratio=0;
   gUsers[nUsers].ul=atoi(argv[17]);
   gUsers[nUsers].dl=atoi(argv[18]);
   gUsers[nUsers].cache_enable=atoi(argv[19]);
   gUsers[nUsers].cache_dir=mystrdup(argv[20]);

   ++nUsers;

   return TCL_OK;

}  // vftpd_RegisterUser

int vftpd_DieAutoBan(ClientData data,Tcl_Interp *interp,int argc,char **argv)
{
   if (argc!=5)
   {  if (gLog>=log_err) syslog(LOG_ERR,stripcr("Wrong # of parameters."));
      return TCL_ERROR;
   }

   gBanClass=strcmp(argv[1],"host");
   gHamCount=atoi(argv[2]);
   gHamTime=atoi(argv[3]);
   gHostsDeny=atoi(argv[4]);

   return TCL_OK;

} // vftpd_DieAutoBan

int vftpd_appWD(ClientData data,Tcl_Interp *interp,int argc,char **argv)
{
   Tcl_SetResult(interp,gAppWD,TCL_VOLATILE);
   return TCL_OK;
   
} // vftpd_appWD

void ParseConfig(void)
{
   unsigned long i,j;
   int code;
   Tcl_Interp *interp;

   interp=Tcl_CreateInterp();

   if (!interp)
   {
#ifndef _WIN32
      if (gLog>=log_err) syslog(LOG_ERR,stripcr("Can't initialize Tcl."));
#else
      fprintf(stderr,stripcr("Can't initialize Tcl."));
#endif
      exit_program(1);
   }

   Tcl_CreateCommand(interp,"vftpd_RegisterUser",vftpd_RegisterUser,(ClientData)0,0);
   Tcl_CreateCommand(interp,"vftpd_DieAutoBan",vftpd_DieAutoBan,(ClientData)0,0);
   Tcl_CreateCommand(interp,"vftpd_appWD",vftpd_appWD,(ClientData)0,0);
   
   code=Tcl_EvalFile(interp,gInitFile);
   if (code==TCL_ERROR)
   {
#ifndef _WIN32
      if (gLog>=log_err) syslog(LOG_ERR,stripcr("Can't read Tcl script."));
#else
      fprintf(stderr,stripcr(interp->result));
#endif
      exit_program(1);
   }
   code=Tcl_Eval(interp,"vftpd_ReadConfigFiles");
   if (code==TCL_ERROR)
   {
#ifndef _WIN32
      if (gLog>=log_err) syslog(LOG_ERR,stripcr("Can't read configuration files."));
#else
      fprintf(stderr,stripcr("Can't read configuration files."));
#endif
      exit_program(1);
   }

   for (i=0;i<nUsers;++i)
   {  gUsers[i].strictIP=gStrictIP;
      gUsers[i].newline=defNewline;
      gUsers[i].pasv=0;
      gUsers[i].s[0]=0;
      gUsers[i].s[1]=0;
      gUsers[i].s[2]=0;
      gUsers[i].s[3]=0;
      gUsers[i].in_buf=0;
      gUsers[i].len=0;
      gUsers[i].d_buf=0;
      gUsers[i].d_len=0;
   }

} // ParseConfig

int openConnection(int *s,struct sockaddr_in *addr,ulong n)
{
   gErr=0;

   if (s[n])
      close(s[n]);
   s[n]=newSocket();

   addr[n].sin_family=AF_INET;

   if (kConnectTimeOut)
   {  alarm(0);
      signal(SIGALRM,(void (*)(int))blocking_call_timedout);
      alarm(kConnectTimeOut);
   }

   if (connect(s[n],(struct sockaddr*)&addr[n],sizeof(struct sockaddr_in)))
   {
      if (kConnectTimeOut)
         alarm(0);

      switch (gErr=errno)
      {
      case 0:
         break;

      default:
         if (gLog>=log_debug) syslog(LOG_DEBUG,"OpenConnection: ");
         errorMsg(gErr);
         break;

      } // switch errno

   } // if connect
   else
      if (kConnectTimeOut)
         alarm(0);

   return gErr;

} // openConnection

int listenPort(int *s,struct sockaddr_in *addr,char n,short port)
{
   int len=(int)sizeof(struct sockaddr_in);

   if (s[n])
      close(s[n]);

   s[n]=newSocket();

   if (!s[n])
   {  if (gLog>=log_err) syslog(LOG_ERR,stripcr(eNOTSOCK));
      return 1;
   }

   addr[n].sin_family=AF_INET;

   if ((addr[n].sin_addr.s_addr=resolve(gHostName))==0)
   {
      if (gLog>=log_err) syslog(LOG_ERR,stripcr("Unable to resolve %s"),gHostName);
      return 1;
   }

   while (true)
   {
      addr[n].sin_port=htons(port);

      if (bind(s[n],(struct sockaddr*)(addr+n), sizeof(struct sockaddr_in)))
      {
         gErr=WSAGetLastError();
//         if (gErr==EADDRINUSE) {
//           ++port;
//          continue;
//        }
         if (gLog>=log_debug) syslog(LOG_DEBUG,"bind (listenPort) : ");
         if (gErr)
            errorMsg(gErr);
         else
            if (gLog>=log_err) syslog(LOG_ERR,stripcr("Can't bind data socket."));
         return 1;
      }

      if (getsockname(s[n],(struct sockaddr*)(addr+n),&len))
      {
         gErr=WSAGetLastError();

         if (gLog>=log_debug) syslog(LOG_DEBUG,"getsockname: ");
         if (gErr)
            errorMsg(gErr);
         else
            if (gLog>=log_err) syslog(LOG_ERR,stripcr("Can't read socket name."));

         return 1;
      }

      if ((port) || addr[n].sin_port>htons(1024))
         break;
   }

   if (listen(s[n],1))
   {
      gErr=WSAGetLastError();

      if (gLog>=log_debug) syslog(LOG_DEBUG,"listen: ");

      if (gErr)
         errorMsg(gErr);
      else
         if (gLog>=log_err) syslog(LOG_ERR,stripcr("Listen failed."));

      return 1;
   }

   if (gLog>=log_notice) syslog(LOG_NOTICE,stripcr("Listening to port %d."),ntohs(addr[n].sin_port));

   return 0;

} // listenPort

int newSocket(void)
{
   int s=socket(AF_INET,SOCK_STREAM,0);
   if ((!s) || s==INVALID_SOCKET)
   {  if (gLog>=log_err) syslog(LOG_ERR,stripcr(eNOTSOCK));
      return 0;
   }

   setsockopt(s,SOL_SOCKET,SO_LINGER,0,0);
   setsockopt(s,SOL_SOCKET,SO_REUSEADDR,0,0);
   setsockopt(s,SOL_SOCKET,SO_KEEPALIVE,0,0);

   return s;

} // newSocket

int resolve(char *host)
{
   int ip=0;

   if (host && *host && (ip=(int)inet_addr(host))==-1)
   {
      struct hostent *he;
      int x=0;

      while (!(he=(struct hostent*)gethostbyname((char *)host)))
      {  if (x==3)
            break;
         ++x;
         sleep(1);
      }
      if (x<3)
         ip=he->h_addr_list?*(int*)he->h_addr_list[0]:0;
   }

   return ip;

} // resolve


int main(int argc,char **argv)
{
   unsigned long i,j;
   char *proto="%s [-i ip] [-p port] [-d] [-s] [-@] [-r path]\n";
   unsigned long pid=1;
   
   gAppWD=(char*)get_current_dir_name();

#ifdef _MACOS
   InitGraf(&qd.thePort);
   InitFonts();
   InitWindows();
   InitMenus();
   TEInit();
   InitDialogs(nil);
   InitCursor();

   GUSISetup(GUSIwithInternetSockets);

#endif

#ifdef _WIN32
   gCurProcess=GetCurrentProcess();
   {
      WORD wVersionRequested;  
      WSADATA wsaData; 
      int err; 
      wVersionRequested = MAKEWORD(1, 1); 

      err=WSAStartup(wVersionRequested,&wsaData); 

      if (err)
      {  fprintf(stderr,"couldn't find a useable winsock dll\n"); 
         exit(1); 
      }

      if (LOBYTE( wsaData.wVersion ) != 1 || 
          HIBYTE( wsaData.wVersion ) != 1)
      {
         fprintf(stderr,"couldn't find a useable winsock dll\n");
         WSACleanup(); 
         exit(1); 
      }
   }
   #define checknextarg() {if (i==argc-1) {fprintf(stderr,stripcr(eNotEnoughP)); fprintf(stderr,stripcr(proto),argv[0]); exit_program(1);}}
#endif
#ifdef _LINUX
   openlog(argv[0],LOG_PID,LOG_DAEMON);
   signal(SIGPIPE,(void (*)(int))broken_pipe);
#endif
#ifndef _WIN32
   #define checknextarg() {if (i==argc-1) {syslog(LOG_ERR,stripcr(eNotEnoughP)); syslog(LOG_ERR,stripcr(proto),argv[0]); exit_program(1);}}
#endif
   for (i=1;i<argc;++i)
   {
      char *c;

      c=argv[i];
      if (c[0]=='-')
      {
         switch (c[1])
         {
         case 'r':
            checknextarg();
            sfree((void**)&gAppWD);
            gAppWD=mystrdup(argv[++i]);
            break;

         case 's':
            gStrictIP=1;
            break;

         case '@':
            gUserAtHost=0;
            break;

         case 'p':
            checknextarg();
            gPort=atoi(argv[++i]);
            gPortInCmdLine=1;
            break;

         case 'l':
            checknextarg();
            gLog=atoi(argv[++i]);
            break;

         case 'i':
            checknextarg();
            gLineIP=argv[++i];
            break;
#ifdef _WIN32
         case 's':
            checknextarg();
            gSocket=atoi(argv[++i]);
            break;
#endif
#ifdef _LINUX
         case 'd':
            gDaemon=1;
            break;
#endif            
         default:
            break;
         }
      }
   }
   
   gDenyFile=addWD(kDenyFile);
   gAllowFile=addWD(kAllowFile);
   gInitFile=addWD(kInitFile);
   gHamFile=addWD(kHamFile);
   gPidFile=addWD(kPidFile);

#ifdef _LINUX
//   if (!gDaemon)
//   {  syslog(LOG_ERR,"Sorry, can't run without inetd actually...");
//      exit_program(1);
//   }
#endif

   ParseConfig();

   if (gLineIP)
      gHostName=gLineIP;
   else
   {
      gHostName=mymalloc(256);
      if (gethostname(gHostName,255))
      {
#ifdef _WIN32
         fprintf(stderr,stripcr("Can't get hostname."));
#else
         if (gLog>=log_err) syslog(LOG_ERR,stripcr("Can't get hostname."));
#endif
         return 1;
      }
   }

   pid=0;

   if (gPortInCmdLine)
   {

#ifndef _LINUX
      if (gLog)
      {  char *fname;
         char name[256];
         sprintf(name,"log/vftpd.%x.log",GetCurrentProcessId());
         fname=addWD(name);
         logfile=fopen(fname,"w");
         free(fname);
         if (!logfile)
         {  fprintf(stderr,"Can't create log file '%s'.\n",fname);
            exit_program(1);
         }
      }
#endif
#ifdef _LINUX
      pid=fork();
#endif
   }
   else
      for (i=0;i<nUsers;++i)
      {
         if (gUsers[i].port)
         {
            gPort=gUsers[i].port;
#ifdef _WIN32
            {
               STARTUPINFO startupInfo;
               PROCESS_INFORMATION procInfo;
               char done;

               char *cmd=mymalloc(6+3+strlen(gHostName)+3+10+3+10);

               sprintf(cmd,"vftpd -i %s -p %d -l %d%s%s",gHostName,gPort,gLog,gUserAtHost?"":" -@",gStrictIP?" -s":"");

               GetStartupInfo(&startupInfo);
               done=CreateProcess(0,cmd,0,0,false,
                                  DETACHED_PROCESS | CREATE_NEW_PROCESS_GROUP,
                                  0,0,&startupInfo,&procInfo);

               free(cmd);

               if (!done)
                  fprintf(stderr,stripcr("Couldn't create process: %d"),GetLastError());

               pid=procInfo.dwProcessId;
            }

#endif

#ifdef _LINUX
            if (!(pid=fork()))
               break;
#endif

#ifdef _WIN32
            fprintf(stderr,stripcr("Process %x bound to port %i."),pid,gPort);
#else
            if (gLog>=log_notice) syslog(LOG_NOTICE,stripcr("Process %lu bound to port %i."),pid,gPort);
#endif   
            for (j=0;j<nUsers;++j)
               if (gUsers[j].port==gPort)
               {  gUsers[j].port=0;
                  freeUser(j);
               }
         }
      }

   if (!pid)
      WaitConnections();

   exit_program(0);
   return 0;

} // main


int CanRead(int sock,int blocking)
{  
   struct timeval timeout;
   fd_set rd;
   int n;
   int r;

   if (!sock) 
      return 0;

   gErr=0;
   
   if (gTimeOut!=0 && blocking!=0)
   {  alarm(0);
      alarm(gTimeOut);
   }
   
   do
   {
//      Tcl_Eval(interp,"update");
      timeout.tv_usec=100;
      timeout.tv_sec=0;
      
      FD_ZERO(&rd);

      FD_SET(sock,&rd);

      n=getdtablesize();
      if (n==-1)
      {  printf("-1\n");
         gErr=0;
         break;
      }
 
      gErr=0;
      if ((r=select(n,&rd,(fd_set*)0,(fd_set*)0,(blocking)?0:&timeout))<0)
      {
         if (!gErr)
            gErr=errno;

         switch(gErr)
         {
            case 0:
//            case EINVAL:  // select called after listen and before accept)
               break;

            default:
               if (gLog>=log_debug) syslog(LOG_DEBUG,"select (canread): ");
               errorMsg(gErr);
               break;
             
         } // switch

      } // if !select
      else
         if (gErr) 
           errorMsg(gErr);

   } while((!gErr) && (blocking) && (!r));

   if (gTimeOut && blocking)
      alarm(0);
   
   return (gErr)?0:FD_ISSET(sock,&rd);
   
} // CanRead


int CanWrite(int sock,int blocking)
{  
   struct timeval timeout;
   fd_set wr;
   int n;
   int w;


   if (!sock)
      return 0;

   gErr=0;
   
   if (gTimeOut!=0 && blocking!=0)
   {  alarm(0);
      alarm(gTimeOut);
   }
   
   do
   {
//      Tcl_Eval(interp,"update");
      timeout.tv_usec=100;
      timeout.tv_sec=0;

      FD_ZERO(&wr);

      FD_SET(sock,&wr);
   
      n=getdtablesize();
      if (n==-1)
      {  printf("-1\n");
         gErr=0;
         break;
      }

      gErr=0;
      if ((w=select(n,(fd_set*)0,&wr,(fd_set*)0,(blocking)?0:&timeout))<0)
      {
         if (!gErr)
            gErr=errno;

         if (gLog>=log_debug) syslog(LOG_DEBUG,"select (canwrite) : ");
         errorMsg(gErr);
      } 
      else
         if (gErr) 
            errorMsg(gErr);

   } while((!gErr) && (blocking) && (!w));

   if (gTimeOut && blocking)
      alarm(0);

   return (gErr)?0:FD_ISSET(sock,&wr);
   
} // CanWrite

int acceptControlConnection(int *s,struct sockaddr_in *addr)
{
   int sock=0;
   int a;

   a=sizeof(struct sockaddr_in);

   if ((sock=accept(*s,(struct sockaddr*)addr,&a))==INVALID_SOCKET)
   {  if (gLog>=log_err) syslog(LOG_ERR,stripcr("Accept failed."));
      return -1;
   }

   if (gLog>=log_notice) syslog(LOG_NOTICE,stripcr("Connection from %s on port %d -> %d"),inet_ntoa(addr->sin_addr),gPort,ntohs(addr->sin_port));

   if (rejectIP(addr->sin_addr.s_addr))
   {  close(*s);
      close(sock);
      return -1;
   }
   return sock;

} // acceptControlConnection

void out(int sock,char *out_buf,size_t *length,char useCopy)
{
   ulong d;
   ulong w;
   char *temp;

   if (!length)
      return;
   if (!*length)
      return;
   if (!out_buf)
      return;

   if (useCopy)
   {  temp=mymalloc(*length);
      memcpy(temp,out_buf,*length);
   }
   else
      temp=out_buf;

   while (1)
   {
      if (gTimeOut)
      {  alarm(0);
         signal(SIGALRM,(void (*)(int))blocking_call_timedout);
         alarm(gTimeOut);
      }

      if (d=(*length)-(w=write(sock,temp,*length)))
      {  
         gErr=errno;

         if (gTimeOut)
            alarm(0);

         if (!gErr)
         {  *length-=w;
            if (*length)
            {  memmove(temp,temp+w,d);
               if (useCopy)
                  continue;
               else
                  break;
            }
         }
         if (useCopy)
            free(temp);
         if (gLog>=log_err) syslog(LOG_ERR,stripcr("Write error. (out) (%i)"),gErr);
         exit_program(gErr);

      }
      else
      {
         *length=0;

         if (gTimeOut)
            alarm(0);
         break;
      }
   }

   if (useCopy)
   {  fflush(0);
      free(temp);
   }

} // out


int in(int *s,char n)
{
   size_t len=0;

   if (gTimeOut)
   {  alarm(0);
      signal(SIGALRM,(void (*)(int))blocking_call_timedout);
      alarm(gTimeOut);
   }

   gErr=0;

   if (n>1)
   {
      if (kInBufSize-gUser->d_len)
      {
         size_t r=read(s[n],gUser->d_buf+gUser->d_len,kInBufSize-gUser->d_len);
         if (r==-1)
            gErr=errno;
         else
         {  len=gUser->d_len+r;
            gUser->d_buf[len]=0;
            gUser->d_len=len;
         }
      }
   }
   else
   {  len=read(s[n],gUser->in_buf,kInBufSize);
      if (len==-1)
         gErr=errno;
      else
      {  gUser->in_buf[len]=0;
         gUser->len=len;
      }
   }

   if (gTimeOut)
      alarm(0);

   switch (gErr)
   {
   case 0:
      break;
   case ECONNRESET:
   default:
      if (gLog>=log_debug) syslog(LOG_DEBUG,"in: ");
      errorMsg(gErr);
      exit_program(gErr);
   }

   return len;

} // in

int file_in(FILE *file)
{
   size_t len=0;

   gErr=0;

   if (kInBufSize-gUser->d_len)
   {
      size_t r;

      if (feof(file))
         return 0;

      r=fread(gUser->d_buf+gUser->d_len,1,kInBufSize-gUser->d_len,file);
      if (r<=0)
         gErr=errno;
      else
      {  len=gUser->d_len+r;
         gUser->d_buf[len]=0;
         gUser->d_len=len;
      }

      switch (gErr)
      {
      case 0:
         break;
      case ECONNRESET:
      default:
         if (gLog>=log_debug) syslog(LOG_DEBUG,"file_in: ");

         errorMsg(gErr);
         exit_program(gErr);

      }
   }

   return len;

} // file_in

int cmd_in(int s,char *in_buf,size_t len,char isReply)
{
   size_t count=0;
   size_t r;
   size_t i=3;

   if (gTimeOut)
   {  alarm(0);
      signal(SIGALRM,(void (*)(int))blocking_call_timedout);
      alarm(gTimeOut);
   }

   while (len)
   {
      if (gTimeOut)
      {  alarm(0);
         signal(SIGALRM,(void (*)(int))blocking_call_timedout);
         alarm(gTimeOut);
      }

      r=read(s,in_buf+count,1);

      gErr=errno;

      if (gTimeOut)
         alarm(0);

      if (r==-1)
      {
         switch (gErr)
         {
         case ECONNRESET:
         default:
            if (gLog>=log_debug) syslog(LOG_DEBUG,"cmd_in: ");

            errorMsg(gErr);
            exit_program(gErr);
            break;

         }
      }

      if ((in_buf[count]==0xa) && (count>0) && (in_buf[count-1]==0xd))
      {
         if ((isReply) && (count>3) && in_buf[i]=='-')
            i=count+4;
         else
         {
            if (isReply)
            {
               if (count>4 && 
                   in_buf[i-1]>='0' && in_buf[i-1]<='9' &&
                   in_buf[i-2]>='0' && in_buf[i-2]<='9' &&
                   in_buf[i-3]>='0' && in_buf[i-3]<='9')
               {
                  ++count;
                  break;
               }
               else
                  i=count+4;
            }
            else
            {
               --count;
               break;
            }
         }
      }
      ++count;
      --len;
   }

   if (count==len)
   {  size_t l=strlen(eTooLong);
      out(s,eTooLong,&l,true);
      do
      {
         while (!CanRead(s,true));
         count=cmd_in(s,in_buf,len,isReply);
      } while (count==len);
      count=0;

   }

   if (!isReply && count>3)
   {  in_buf[0]=uppercase(in_buf[0]);
      in_buf[1]=uppercase(in_buf[1]);
      in_buf[2]=uppercase(in_buf[2]);
      in_buf[3]=uppercase(in_buf[3]);
   }

   in_buf[count]=0;
   return count;

} // cmd_in

void WaitConnections(void)
{
   int s=0;
   int sock=0;
   struct sockaddr_in addr;
   unsigned long oldTimeOut;

#ifdef _WIN32
   if (gPortInCmdLine && gSocket)
   {  int a=sizeof(struct sockaddr);
      getpeername(gSocket,(struct sockaddr*)&addr,&a);
      login(gSocket,&addr);
      return;
   }
#endif
#ifdef _LINUX
   if (gDaemon)
   {  int a=sizeof(struct sockaddr);
      s=1;
      getpeername(s,(struct sockaddr*)&addr,&a);
      if (rejectIP(addr.sin_addr.s_addr))
         return;
      login(s,&addr);
      return;
   }
#endif

   if (listenPort(&s,&addr,0,gPort))
      exit_program(1);

   oldTimeOut=gTimeOut;
   gTimeOut=0;
   while (true)
   {  
      if (sock!=0 && sock!=-1)
      {  close(sock);
         sock=0;
      }

//      if (CanRead(s,true))
      {  size_t a=sizeof(struct sockaddr);
         sock=acceptControlConnection(&s,&addr);
         if (sock==-1)
            continue;

#ifdef _LINUX
         if (fork())
            continue;
#endif


#ifdef _WIN32
// I've done it without the win32 api doc ! (: not easy to find info
// on the web for passing an open socket descriptor to a child process :) 
// now it is...

         {
            STARTUPINFO startupInfo;
            PROCESS_INFORMATION procInfo;
            char done;
            char shandle[32];
            int sock2;
            char *cmd;

            if (!DuplicateHandle(gCurProcess,(HANDLE)sock,gCurProcess,
                                 (HANDLE*)&sock2,0,TRUE,DUPLICATE_SAME_ACCESS))
            {
               if (gLog>=log_err) syslog(LOG_ERR,stripcr("Can't duplicate socket handle."));
               exit_program(1);
            }
            CloseHandle((HANDLE)sock);
            sock=sock2;
            _itoa((DWORD)sock,shandle,10);

            cmd=mymalloc(6+3+strlen(gHostName)+3+10+3+10+3+10);
            sprintf(cmd,"vftpd -i %s -p %d -l %d -s %s%s%s",gHostName,gPort,gLog,shandle,gUserAtHost?"":" -@",gStrictIP?" -s":"");

            GetStartupInfo(&startupInfo);
            done=CreateProcess(0,cmd,0,0,true,
                               DETACHED_PROCESS | CREATE_NEW_PROCESS_GROUP,
                               0,0,&startupInfo,&procInfo);

            free(cmd);

            if (!done)
            {
               if (gLog>=log_err) syslog(LOG_ERR,stripcr("Couldn't create process: %d"),GetLastError());
            }

            sock=0;
            continue;
         }
#endif
         close(s);
         s=0;
         gTimeOut=oldTimeOut;
         login(sock,&addr);
         break;
      }
   }

} // WaitConnections

void login(int s,struct sockaddr_in *addr)
{
   size_t len=strlen(gWelcomeMsg);
   char in_buf[1025];
   char user[1024];
   char pass[1024];
   int i=0;
   char *c;
   char badlogin=0;
   ulong oldTimeOut=gTimeOut;

   gTimeOut=60;

   if (CanWrite(s,true))
   {  out(s,gWelcomeMsg,&len,true);
      while (true)
         if (CanRead(s,true))
         {  len=cmd_in(s,in_buf,1024,false);
            if (*(long*)in_buf==ntohl('QUIT'))
            {  len=strlen(gGoodbyeMsg);
               out(s,gGoodbyeMsg,&len,true);
               close(s);
               return;
            }
            if ((len<6) || (*(long*)in_buf!=ntohl('USER')))
            {  size_t len=strlen(ePleaseLogin);
               out(s,ePleaseLogin,&len,true);
               continue;
            }
            strcpy(user,in_buf+5);
            sprintf(in_buf,iPassRequired,user);
            len=strlen(in_buf);
            out(s,in_buf,&len,false);

            while (true)
               if (CanRead(s,true))
               {  len=cmd_in(s,in_buf,1024,false);
                  if (*(long*)in_buf==ntohl('QUIT'))
                  {  len=strlen(gGoodbyeMsg);
                     out(s,gGoodbyeMsg,&len,true);
                     close(s);
                     return;
                  }
                  if ((len<5) || (*(long*)in_buf!=ntohl('PASS')))
                  {  size_t len=strlen(ePleaseLogin);
                     out(s,ePleaseLogin,&len,true);
                     continue;
                  }
                  strcpy(pass,in_buf+5);
                  
                  if (gUserAtHost)
                  {  if (c=strchr(user,'@'))
                     {  i=-1;
                        break;
                     }
                  }

                  for (i=0;i<nUsers;++i)
                     if ((gPort==gUsers[i].port) && !strcmp(gUsers[i].login,user) && !strcmp(gUsers[i].pass,pass))
                        break;
                  break;
               }

            if (i<nUsers)
               break;

            if (gLog>=log_warning) syslog(LOG_WARNING,stripcr("INVALID PASSWORD (user:%s port:%d connected from:%s)"),
                                          &user[0], gPort,
                                          inet_ntoa(addr->sin_addr));

            len=strlen(eBadLogin);
            out(s,eBadLogin,&len,true);
            if (++badlogin==3)
            {  len=strlen(gGoodbyeMsg);
               out(s,gGoodbyeMsg,&len,true);
               close(s);
               return;
            }
         }

      if (i==-1)
      {
         char *d;

         if (nUsers==0)
            gUsers=mymalloc(sizeof(User));

         i=nUsers;
         gUsers[i].login=mystrdup(user);
         *c=0;
         gUsers[i].pass=0;
         gUsers[i].port=0;
         gUsers[i].maxCon=999;
         gUsers[i].maxIdle=900;
         gUsers[i].server_login=mystrdup(user);
         gUsers[i].server_pass=mystrdup(pass);
         
         if (d=strchr(c+1,':'))
         {  *d=0;
            gUsers[i].server_port=atoi(d+1);
         }
         else
            gUsers[i].server_port=21;

         gUsers[i].address=mystrdup(c+1);
         gUsers[i].path=strdup("/");
         gUsers[i].chroot=0;
         gUsers[i].perms=-1;
         gUsers[i].ratio=0;
         gUsers[i].ul=0;
         gUsers[i].dl=0;
         gUsers[i].cache_enable=0;
         gUsers[i].cache_dir=0;
         gUsers[i].strictIP=gStrictIP;
         gUsers[i].newline=defNewline;
         gUsers[i].pasv=0;
         gUsers[i].s[0]=0;
         gUsers[i].s[1]=0;
         gUsers[i].s[2]=0;
         gUsers[i].s[3]=0;
         gUsers[i].in_buf=0;
         gUsers[i].len=0;
         gUsers[i].d_buf=0;
         gUsers[i].d_len=0;
      }
      gUsers[i].s[0]=s;
      memcpy(&gUsers[i].addr[0],addr,sizeof(struct sockaddr_in));
      gTimeOut=oldTimeOut;
      LoggedIn(gUsers+i);
   }

} // login

int WaitReply(int s,int block)
{
   char *c;
   char *buf=gUser->in_buf;

   if (!CanRead(s,block))
      return status=999;

   if (!cmd_in(s,buf,kInBufSize,true))
      return status=999;

   if (gLog>=log_info) syslog(LOG_INFO,stripcr(buf));
   return status=atoi(buf);   

} // WaitReply

void forwardReply(void)
{
   size_t len=strlen(gUser->in_buf);
   out(gUser->s[0],gUser->in_buf,&len,false);

} // forwardReply

void notify(char *note)
{
   size_t len=strlen(note);
   if (gLog>=log_info) syslog(LOG_INFO,stripcr(note));
   out(gUser->s[0],note,&len,true);

} // notify

void sendCommand(int s,char *command)
{
   char *temp;
   size_t len;

   if (!CanWrite(s,true))
      exit_program(gErr?gErr:-1);

   temp=mymalloc(strlen(command)+3);

   sprintf(temp,"%s%s",command,gUser->newline);
   if (gLog>=log_info) syslog(LOG_INFO,stripcr(command));
   len=strlen(temp);
   out(s,temp,&len,false);
   free(temp);
   fflush(0);
   WaitReply(s,true);

} // sendCommand

void ham(ulong hamCount,ulong hamTime)
{
   time_t t=time(0);
   FILE *file=0;

   if (t!=(time_t)-1 && hamTime!=0)
   {
      if (ReadConfigFile(gHamFile))
      {  hamrec *ham;
         ham=(hamrec*)gConfigFile;

         while (true)
         {  if (ham->t==0)
               break;
            if ((t-ham->t)>hamTime)
               ++ham;
            else
               break;
         }

         if (ham->t)
         {  
            long count=0;

            if (ham>(hamrec*)gConfigFile)
            {  gConfigFileSize-=((ulong)ham-(ulong)gConfigFile);
               memmove(gConfigFile,ham,gConfigFileSize);
               ham=(hamrec*)gConfigFile;
            }

            while (true)
            {
               if (ham->t==0)
                  break;
               if (ham->ip==gUser->addr[0].sin_addr.s_addr)
                  ++count;
               ++ham;
            }
            gConfigFileSize-=sizeof(hamrec);
            if (count>=hamCount)
            {
               AutoBan(ham->ip);
            }
         }
         else
            sfree((void**)&gConfigFile);

         file=fopen(gHamFile,"w");
         if (!file)
            if (gLog>=log_err) syslog(LOG_ERR,stripcr("Cant open %s for writing."),kHamFile);

         if (gConfigFile)
         {
            size_t towrite=gConfigFileSize;
            size_t w;
            char *buf=gConfigFile;

            do
            {
               w=fwrite(buf,1,towrite,file);
               if (w==0)
               {
                  gErr=errno;
                  fclose(file);
                  if (gLog>=log_debug) syslog(LOG_DEBUG,stripcr("Cant write to %s"),kHamFile);
                  errorMsg(gErr);
                  break;
               }
               towrite-=w;
               buf+=w;

            } while (towrite);

            sfree((void**)&gConfigFile);
         }
      }

      if (!file)
         file=fopen(gHamFile,"a");
      if (!file)
      {   if (gLog>=log_err) syslog(LOG_ERR,stripcr("Cant open %s for appending."),kHamFile);
      }
      else
      {
         hamrec ham[2];
         size_t w;
         
         ham[0].ip=gUser->addr[0].sin_addr.s_addr;
         ham[0].t=t;
         ham[1].t=0;

         w=fwrite(&ham[0],2,sizeof(hamrec),file);
         if (!w)
         {  gErr=errno;
            if (gLog>=log_err) syslog(LOG_ERR,stripcr("Cant append hamrec."));
            errorMsg(gErr);
         }
         fclose(file);
      }
   }

} // ham

int Server_login()
{
   char *c;
   size_t len;

   gUser->s[1]=newSocket();
   if (!gUser->s[1])
   {  if (gLog>=log_err) syslog(LOG_ERR,stripcr(eNOTSOCK));
      strcpy(gUser->in_buf,eClosed);
      return -1;
   }

   if ((gUser->addr[1].sin_addr.s_addr=resolve(gUser->address))==0)
   {  if (gLog>=log_err) syslog(LOG_ERR,stripcr("Unable to resolve %s"),gUser->address);
      strcpy(gUser->in_buf,eControlCon);
      return -1;
   }

   gUser->addr[1].sin_port=htons(gUser->server_port);

   if (openConnection(gUser->s,gUser->addr,1))
   {  strcpy(gUser->in_buf,eControlCon);  
      return -1;
   }
   WaitReply(gUser->s[1],true);
   if (status/100>2)
   {  strcpy(gUser->in_buf,eControlCon);  
      return -1;
   }
   c=mymalloc(6+strlen(gUser->server_login));
   sprintf(c,"USER %s",gUser->server_login);
   sendCommand(gUser->s[1],c);
   if (status==500)
   {  gUser->newline=otherNewline;
      sendCommand(gUser->s[1],c);
   }
   free(c);
   if (status/100>3)
   {  if (status==421)
         ham(gHamCount,gHamTime);
      strcpy(gUser->in_buf,eBadLogin);
      return -1;
   }

   c=mymalloc(6+strlen(gUser->server_pass));
   sprintf(c,"PASS %s",gUser->server_pass);
   sendCommand(gUser->s[1],c);
   free(c);
   if (status/100>3)
   {  if (status==421)
         ham(gHamCount,gHamTime);
      strcpy(gUser->in_buf,eBadLogin);
      return -1;
   }

   sprintf(gUser->in_buf,"CWD %s",gUser->path);
   sendCommand(gUser->s[1],gUser->in_buf);
   gUser->in_buf[0]=0;
   gUser->len=0;
   if (status/100>2)
   {  if (gLog>=log_err) syslog(LOG_ERR,stripcr("Root directory not found."));
      strcpy(gUser->in_buf,eBadLogin); 
      return -1;
   }
   gWD=mymalloc(strlen(gUser->path)+1);
   strcpy(gWD,gUser->path);
   
   strcpy(gUser->in_buf,"PWD");
   if (PWD(0))
   {  sprintf(gUser->in_buf,eBadLogin);
      return -1;
   }
   
   return 0;

} // Server_login

void CWD(void)
{
   size_t i;
   char *dir=0;
   char *temp=0;

   if (gUser->in_buf[3]==' ')
      i=4;
   else
      i=5;

   if (strlen(gUser->in_buf)<i+1)
   {  temp=mymalloc(strlen(eSyntaxError)+strlen(gUser->in_buf)+1);
      sprintf(temp,eSyntaxError,gUser->in_buf);
      notify(temp);
      free(temp);
      return;
   }

   if (gUser->chroot)
   {  size_t l;

      dir=mystrdup(gUser->in_buf+i);

      if (gUser->in_buf[i]=='/')
      {
         l=strlen(gUser->path);
         memmove(gUser->in_buf+i+l,gUser->in_buf+i,strlen(gUser->in_buf+i)+1);
         memmove(gUser->in_buf+i,gUser->path,l);
      }
   }

   forwardCommand();
   if (status/100==2)
   {  if (gUser->chroot)
      {  char *temp2=mystrdup(gUser->in_buf);
         strcpy(gUser->in_buf,"PWD");
         if (PWD(0))
         {  strcpy(gUser->in_buf,"CWD ");
            strcat(gUser->in_buf,gWD);
            forwardCommand();
            sprintf(gUser->in_buf,eNoSuchFile,dir);
            forwardReply();
            free(dir);
            free(temp2);
            return;
         }
         strcpy(gUser->in_buf,temp2);
         free(temp2);
      }

      free(gWD);
      gWD=malloc(strlen(gPath)+1);
      strcpy(gWD,gPath);
   }

   if (gUser->chroot)
   {
      char *k;
      char *l;

      free(dir);
      k=(char*)strchr(gUser->in_buf,'/');
      if (!k)
      {  forwardReply();
         return;
      }

      if (k==(char*)strstr(gUser->in_buf,gUser->path))
      {  l=k+strlen(gUser->path);
         if (*l!='/')
            ++k;
         memmove(k,l,strlen(l)+1);
      }
   }
   forwardReply();

} // CWD

void CDUP(void)
{
   size_t i;

   i=5;

   forwardCommand();
   if (status/100==2)
   {  char *k;

      if (gUser->chroot)
      {  char *temp=mystrdup(gUser->in_buf);
         strcpy(gUser->in_buf,"PWD");
         if (PWD(0))
         {  strcpy(gUser->in_buf,"CWD ");
            strcat(gUser->in_buf,gWD);
            forwardCommand();
            strcpy(gUser->in_buf,iCWD);
            forwardReply();
            return;
         }
         strcpy(gUser->in_buf,temp);
         free(temp);
      }

      k=(char*)strrchr(gWD,'/');
      if (k!=0 && k!=gWD)
         *k=0;
   }

   forwardReply();

} // CDUP

int PWD(char forward)
{
   char *k;

   forwardCommand();
   k=(char*)strrchr(gUser->in_buf+5,gUser->in_buf[4]);
   if (!k)
   {  if (gLog>=log_err) syslog(LOG_ERR,stripcr("Cant parse PWD reply."));
      return -1;
   }
   *k=0;
   if (gPath)
      free(gPath);
   gPath=mystrdup(gUser->in_buf+5);
   *k=gUser->in_buf[4];

   if (gUser->chroot)
   {
      char *l;

      k=(char*)strchr(gUser->in_buf,'/');
      if (!k)
      {  if (gLog>=log_err) syslog(LOG_ERR,stripcr("Invalid directory."));
         return -1;
      }
      if (k==(char*)strstr(gUser->in_buf,gUser->path))
      {  l=k+strlen(gUser->path);
         if (*l!='/')
            ++k;
         memmove(k,l,strlen(l)+1);
      }
      else
      {  if (gLog>=log_err) syslog(LOG_ERR,stripcr("Invalid directory."));
         return -1;
      }
   }

   if (forward)
      forwardReply();

   return 0;

} // PWD

int PORT(void)
{
   char c[256];
   struct sockaddr_in addr;
   char *k;
   char *l;
   ulong j;
   size_t len;
   char *temp=0;

   k=(char*)strpbrk(gUser->in_buf+4,"1234567890,");

   if (!k)
      return -1;

#ifdef _WIN32
   gUser->addr[2].sin_addr.S_un.S_un_b.s_b1=atoi(k);
   gUser->pasv=0;
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;

   gUser->addr[2].sin_addr.S_un.S_un_b.s_b2=atoi(k);
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[2].sin_addr.S_un.S_un_b.s_b3=atoi(k);
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[2].sin_addr.S_un.S_un_b.s_b4=atoi(k);
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[2].sin_port=atoi(k);
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[2].sin_port|=atoi(k)<<8;
   gUser->pasv=-1;

#endif
#ifdef _LINUX
   gUser->addr[2].sin_addr.s_addr=atoi(k);
   gUser->pasv=0;
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[2].sin_addr.s_addr|=atoi(k)<<8;
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[2].sin_addr.s_addr|=atoi(k)<<16;
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[2].sin_addr.s_addr|=atoi(k)<<24;
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[2].sin_port=atoi(k);
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[2].sin_port|=atoi(k)<<8;
   gUser->pasv=-1;

#endif

   if (listenPort(gUser->s,gUser->addr,3,0))
   {  notify(ePORTfailed);
      return -2;
   }

#ifdef _WIN32
   sprintf(c,"PORT %i,%i,%i,%i,%i,%i",
           gUser->addr[3].sin_addr.S_un.S_un_b.s_b1,
           gUser->addr[3].sin_addr.S_un.S_un_b.s_b2,
           gUser->addr[3].sin_addr.S_un.S_un_b.s_b3,
           gUser->addr[3].sin_addr.S_un.S_un_b.s_b4,
           gUser->addr[3].sin_port&0xff,
           gUser->addr[3].sin_port>>8
          );

#endif
#ifdef _LINUX
   sprintf(c,"PORT %i,%i,%i,%i,%i,%i",
           gUser->addr[3].sin_addr.s_addr&0xff,
           (gUser->addr[3].sin_addr.s_addr>>8)&0xff,
           (gUser->addr[3].sin_addr.s_addr>>16)&0xff,
           gUser->addr[3].sin_addr.s_addr>>24,
           gUser->addr[3].sin_port&0xff,
           gUser->addr[3].sin_port>>8
          );
#endif

   sendCommand(gUser->s[1],c);
   forwardReply();

   return (status/100!=2);

} // PORT

int PASV(void)
{
   char c[256];
   struct sockaddr_in addr;
   char *k;
   char *l;
   ulong j;
   size_t len;
   int sock=0;
   int   a;

   sendCommand(gUser->s[1],gUser->in_buf);
   if (status/100!=2)
   {  forwardReply();
      return;
   }


   k=(char*)strpbrk(gUser->in_buf+3,"1234567890,");

   if (!k)
      return -1;

#ifdef _WIN32
   gUser->addr[3].sin_addr.S_un.S_un_b.s_b1=atoi(k);
   gUser->pasv=0;
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;

   gUser->addr[3].sin_addr.S_un.S_un_b.s_b2=atoi(k);
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[3].sin_addr.S_un.S_un_b.s_b3=atoi(k);
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[3].sin_addr.S_un.S_un_b.s_b4=atoi(k);
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[3].sin_port=atoi(k);
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[3].sin_port|=atoi(k)<<8;
#endif
#ifdef _LINUX
   gUser->addr[3].sin_addr.s_addr=atoi(k);
   gUser->pasv=0;
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[3].sin_addr.s_addr|=atoi(k)<<8;
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[3].sin_addr.s_addr|=atoi(k)<<16;
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[3].sin_addr.s_addr|=atoi(k)<<24;
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[3].sin_port=atoi(k);
   k+=(j=strspn(k,"1234567890"))+1;
   if (!j)
      return -1;
   gUser->addr[3].sin_port|=atoi(k)<<8;
#endif

   if (openConnection(gUser->s,gUser->addr,3))
   {  notify(ePASVfailed);
      return -2;
   }

   if (listenPort(gUser->s,gUser->addr,2,0))
   {  notify(ePASVfailed);
      return -2;

   }
#ifdef _WIN32
   sprintf(c,"227 Entering Passive Mode (%i,%i,%i,%i,%i,%i)\r\n",
           gUser->addr[2].sin_addr.S_un.S_un_b.s_b1,
           gUser->addr[2].sin_addr.S_un.S_un_b.s_b2,
           gUser->addr[2].sin_addr.S_un.S_un_b.s_b3,
           gUser->addr[2].sin_addr.S_un.S_un_b.s_b4,
           gUser->addr[2].sin_port&0xff,
           gUser->addr[2].sin_port>>8
          );

#endif
#ifdef _LINUX
   sprintf(c,"227 Entering Passive Mode (%i,%i,%i,%i,%i,%i)\r\n",
           gUser->addr[2].sin_addr.s_addr&0xff,
           (gUser->addr[2].sin_addr.s_addr>>8)&0xff,
           (gUser->addr[2].sin_addr.s_addr>>16)&0xff,
           gUser->addr[2].sin_addr.s_addr>>24,
           gUser->addr[2].sin_port&0xff,
           gUser->addr[2].sin_port>>8
          );
#endif
   notify(c);

   sock=0;
   do
   {  if (sock)
      {  close(sock);
         sock=0;
         if (gLog>=log_warning) syslog(LOG_WARNING,stripcr("unexpected host: %s"),inet_ntoa(gUser->addr[2].sin_addr));
      }

      a=sizeof(struct sockaddr_in);
      if ((sock=accept(gUser->s[2],(struct sockaddr*)&gUser->addr[2],&a))==INVALID_SOCKET)
      {  if (gLog>=log_err) syslog(LOG_ERR,stripcr("Accept failed."));
         notify(ePASVfailed);
         return 0;
      }

   } while (gUser->strictIP && memcmp(&gUser->addr[2].sin_addr,&gUser->addr[0].sin_addr,sizeof(gUser->addr[0].sin_addr))); 
   close(gUser->s[2]);
   gUser->s[2]=sock;

   gUser->pasv=1;

   return (status/100!=2);

} // PASV

int makepath(char *path)
{
   if (chdir(path))
   {  char *k;
      char *temp=mystrdup(path);
      k=(char*)strchr(temp+1,'/');
      while (k)
      {
         *k=0;
         if (chdir(temp))
         {
#ifdef _WIN32
            if (mkdir(temp))
#endif
#ifdef _LINUX
               if (mkdir(temp,kUmask))
#endif
               {
                  if (gLog>=log_warning) syslog(LOG_WARNING,stripcr("Cant use the cache directory."));
                  return -1;
               }
         }
         *k='/';
         k=(char*)strchr(k+1,'/');
      }

      if (chdir(temp))
      {
#ifdef _LINUX
         if (mkdir(temp,kUmask))
#else
         if (mkdir(temp))
#endif
         {
            if (gLog>=log_warning) syslog(LOG_WARNING,stripcr("Cant use the cache directory."));
            return -1;
         }
      }
   }

   return 0;

} // makepath

char *ftpGet(char *filename,char pipe,char put,char cache)
{
   char *save=0;
   size_t len=0;
   char *data=0;
   char *tmp;
   int   a;
   int sock=0;
   char done=0;
   ulong count;
   ulong old_len;
   FILE *outFile=0;
   char  inp=(put)?2:3;
   char  outp=(put)?3:2;
   char freefilename=0;
   FILE *cachefile=0;
   ulong cachefileSize=0;
   char *name;
   
   name=(char*)strrchr(gUser->in_buf,'/');
   if ((!name) && strlen(gUser->in_buf)>5)
   {  char *temp;
      name=gUser->in_buf+5;
      temp=mystrdup(name);
      name=temp;
   }

   if (cache && !filename)
   {
      char *k=name;

      filename=mymalloc(strlen(gUser->cache_dir)+strlen(gPath)+strlen(k)+3);
      strcpy(filename,gUser->cache_dir);
      strcat(filename,gPath);
      if (strstr(filename,"../"))
      {  if (gLog>=log_warning) syslog(LOG_WARNING,stripcr("huh... '%s' is not a valid path."),filename);
         sfree((void**)&filename);
      }
      else
      {
         if (makepath(filename))
            sfree((void**)&filename);
         else
         {  strcat(filename,"/");
            strcat(filename,k);
            freefilename=1;
            switch (cmd)
            {
            case 'RETR':
               cachefile=fopen(filename,"r+");
               if (cachefile)
               {  fseek(cachefile,0,SEEK_END);
                  cachefileSize=ftell(cachefile);
                  if (isThere!=cachefileSize)
                  {  if (gRest)
                     {  if (gRest==cachefileSize)
                        {  outFile=cachefile;
                           cachefile=0;
                        }
                        else
                        {  if (gRest<cachefileSize)
                           {  fseek(cachefile,gRest,SEEK_SET);
                              outFile=cachefile;
                                // cachefile=0;
                           }
                           else
                           {  fclose(cachefile);
                              cachefile=0;
                              sfree((void**)&filename);
                              freefilename=0;
                           }
                        }
                     }
                     else
                     {  if (cachefileSize>isThere)
                        {  fclose(cachefile);
                           cachefile=0;
                        }
                        else
                        {  outFile=cachefile;
                           fseek(cachefile,0,SEEK_SET);
                        }
                     }
                  }
                  else
                  {  sfree((void**)&filename);
                     freefilename=0;
                     fseek(cachefile,gRest,SEEK_SET);
                  }
               }
               else
                  if (gRest)
                  {  sfree((void**)&filename);
                     freefilename=0;
                  }
               break;

            case 'STOR':
            case 'APPE':
               cachefile=fopen(filename,"r+");
               if (cachefile)
               {  fseek(cachefile,0,SEEK_END);
                  cachefileSize=ftell(cachefile);
                  if (cmd=='APPE')
                  {  if (isThere!=gRest)
                     {  if (gLog>=log_warning) syslog(LOG_WARNING,stripcr("APPE but REST!=size"));
                        gRest=isThere;
                     }
                  }
                  if (isThere!=cachefileSize)
                  {  if (gRest)
                     {  if (gRest==cachefileSize)
                        {  outFile=cachefile;
                           cachefile=0;
                        }
                        else
                        {  if (gRest<cachefileSize)
                           {  fseek(cachefile,gRest,SEEK_SET);
                              outFile=cachefile;
                              cachefile=0;
                           }
                           else
                           {  fclose(cachefile);
                              cachefile=0;
                              sfree((void**)&filename);
                              freefilename=0;
                           }
                        }
                     }
                     else
                     {  fclose(cachefile);
                        cachefile=0;
                     }
                  }
                  else
                  {  fclose(cachefile);
                     cachefile=0;
                     sfree((void**)&filename);
                     freefilename=0;
                  }
               }
               else
                  if (gRest)
                  {  sfree((void**)&filename);
                     freefilename=0;
                  }
               break;
            }
         }
      }
   }
   gCacheFile=(cachefile)?1:0;

   if (gUser->pasv==0)
   {
      gUser->addr[2].sin_addr=gUser->addr[0].sin_addr;
      gUser->addr[2].sin_port=htons(kDefaultDataPort);
      gUser->pasv=-1;

      if (!cachefile || (cachefile==outFile))
      {
         if (listenPort(gUser->s,gUser->addr,3,kDefaultDataPort))
         {  notify(eDataCon);
            if (freefilename)
               free(filename);
            if (name)
               free(name);
            return 0;
         }
      }
   }

   if (cachefile)
   {  if (outFile==cachefile)
         save=mystrdup(gUser->in_buf);

      sprintf(gUser->in_buf,iDataCon,gMode,name,isThere-gRest);
      status=150;
   }
   else
      forwardCommand();

   forwardReply();

   if (status/100>2)
   {  gCacheFile=0;
      return 0;
   }

   if (gUser->pasv==-1)
   {  
      if (openConnection(gUser->s,gUser->addr,2))
      {  notify(eDataCon);
         if (freefilename)
            free(filename);
         if (cachefile)
            fclose(cachefile);
         if (name)
            free(name);
         if (save)
            free(save);
         return 0;
      }

      if (!cachefile)
      {
         do
         {
            if (sock)
            {  close(sock);
               sock=0;
               if (gLog>=log_err) syslog(LOG_ERR,stripcr("unexpected host: %s"),inet_ntoa(gUser->addr[3].sin_addr));
            }

            if ((sock=accept(gUser->s[3],(struct sockaddr*)&gUser->addr[3],&a))==INVALID_SOCKET)
            {  if (gLog>=log_err) syslog(LOG_ERR,stripcr("Accept failed."));
               notify(eDataCon);
               if (freefilename)
                  free(filename);
               if (name)
                  free(name);
               if (save)
                  free(save);
               return 0;
            }

         } while (gUser->strictIP && memcmp(&gUser->addr[1].sin_addr,&gUser->addr[3].sin_addr,sizeof(gUser->addr[3].sin_addr))); 
         close(gUser->s[3]);
         gUser->s[3]=sock;
      }
   }

   if (!cachefile)
      if (!CanRead(gUser->s[inp],true))
      {  notify(eDataCon);
         if (freefilename)
            free(filename);
         if (name)
            free(name);
         if (save)
            free(save);
         return 0;
      }

   gUser->d_len=0;
   len=0;
   while (true)
   {
      char *tag;
      old_len=gUser->d_len;
      if (cachefile)
      {  if (!file_in(cachefile) && !gUser->d_len)
         {
            if (outFile==cachefile)
            {
               cachefile=0;
               gCacheFile=0;
               sprintf(gUser->in_buf,"REST %lu",cachefileSize);
               forwardCommand();
               if (status/100>3)
               {
                  if (freefilename)
                     free(filename);
                  if (name)
                     free(name);
                  if (save)
                     free(save);
                  fclose(outFile);
                  notify(eTransfer);
                  break;

               }
               strcpy(gUser->in_buf,save);
               free(save);
               save=0;
               forwardCommand();

               if (status/100>2)
                  exit_program(1);

               if (gUser->pasv==-1)
               {
                  do
                  {
                     if (sock)
                     {  close(sock);
                        sock=0;
                        if (gLog>=log_err) syslog(LOG_ERR,stripcr("unexpected host: %s"),inet_ntoa(gUser->addr[3].sin_addr));
                     }

                     if ((sock=accept(gUser->s[3],(struct sockaddr*)&gUser->addr[3],&a))==INVALID_SOCKET)
                     {  if (gLog>=log_err) syslog(LOG_ERR,stripcr("Accept failed."));
                        notify(eTransfer);
                        if (freefilename)
                           free(filename);
                        if (name)
                           free(name);
                        fclose(outFile);
                        return 0;
                     }

                  } while (gUser->strictIP && memcmp(&gUser->addr[1].sin_addr,&gUser->addr[3].sin_addr,sizeof(gUser->addr[3].sin_addr))); 
                  close(gUser->s[3]);
                  gUser->s[3]=sock;
               }

               if (!CanRead(gUser->s[inp],true))
               {  notify(eTransfer);
                  if (freefilename)
                     free(filename);
                  if (name)
                     free(name);
                  fclose(outFile);
                  return 0;
               }
            }
            else
               break;
         }

      }
      if (!cachefile)
      { // else == bug !!
         if (!in(gUser->s,inp) && !gUser->d_len)
            break;
      }
      count=gUser->d_len-old_len;
      tag=gUser->d_buf+gUser->d_len-count;

      if (filename)
      {
         if (len==0 && outFile==0)
            outFile=fopen(filename,"w");

         if (outFile && (outFile!=cachefile))
         {
            size_t r;

            do
            {
               if ((r=fwrite(tag,1,count,outFile))<=0)
               {  if (gLog>=log_err) syslog(LOG_ERR,stripcr("File write error (Ftpget)."));
                  gErr=errno;
                  errorMsg(gErr);
                  if (freefilename)
                     free(filename);
                  if (name)
                     free(name);
                  if (save)
                     free(save);
                  fclose(outFile);
                  sendCommand(gUser->s[inp-2],"ABOR");
                  forwardReply();
                  return 0;
               }
               tag+=r;
               count-=r;

            } while (count);
         }
      }
      else
         if (count)
         {
            if (data)
            {  data=(char*)realloc(data,len+count+1);
               if (!data)
                  oom();
               memcpy(data+len,tag,count);
            }
         }

      len+=count;

      if (pipe && gUser->d_len)
      {
         size_t oldlen=gUser->d_len;
         out(gUser->s[outp],gUser->d_buf,&gUser->d_len,false);
         if ((cmd!='LIST') && (cmd!='NLST'))
            if (put)
               gUser->ul+=oldlen-gUser->d_len;
            else
               gUser->dl+=oldlen-gUser->d_len;
      }
   }

   if (outFile)
   {  fclose(outFile);
      outFile=0;
   }

   if (cachefile)
      fclose(cachefile);

   if (data)
      data[len]=0;

   fflush(0);
   close(gUser->s[2]);
   close(gUser->s[3]);
   gUser->s[2]=0;
   gUser->s[3]=0;

   if (freefilename)
      free(filename);
   if (name)
      free(name);
   if (save)
      free(save);

   return data?data:(void*)-1;

} // ftpGet

int pathValid(char isFile,char mandatory,ulong *isThere)
{
   size_t i,l;
   char *dir=0;
   char *temp=0;
   char *save=0;

   if (!gUser->chroot)
      return true;

   if (gUser->in_buf[3]==' ')
      i=4;
   else
      i=5;

   if (strlen(gUser->in_buf)<i+1)
   {  
      if (!mandatory)
         return true;

      temp=mymalloc(strlen(eSyntaxError)+strlen(gUser->in_buf)+1);
      sprintf(temp,eSyntaxError,gUser->in_buf);
      notify(temp);
      free(temp);
      return 0;
   }

   save=mymalloc(strlen(gUser->in_buf)+strlen(gUser->path)+1);

   if (gUser->in_buf[i]=='/')
   {  l=strlen(gUser->path);
      memmove(gUser->in_buf+i+l,gUser->in_buf+i,strlen(gUser->in_buf+i)+1);
      memmove(gUser->in_buf+i,gUser->path,l);
   }
   strcpy(save,gUser->in_buf);

   if (isFile && !strchr(gUser->in_buf+i,'/'))
   {  if (isThere)
      {  char *k=(char*)strrchr(save,'/');
         strcpy(gUser->in_buf,"SIZE ");
         strcat(gUser->in_buf,(k)?k+1:save+i);
         forwardCommand();
         if (status/100==2)
         {  *isThere=atoi(gUser->in_buf+4);
            isThereFlag=1;
         }
         else
         {  *isThere=0;
            isThereFlag=0;
         }
         strcpy(gUser->in_buf,save);
      }
      free(save);
      if (gPath)
         free(gPath);
      gPath=mystrdup(gWD);
      return true;
   }

   dir=save+i;
   if (isFile)
   {  char *k=(char*)strrchr(gUser->in_buf,'/');
      if (k)
         *k=0;
      else
      {  free(save);
         return true;
      }
   }

   temp=mystrdup(gUser->in_buf+i);

   sprintf(gUser->in_buf,"CWD %s",temp);
   free(temp);
   forwardCommand();
   if (status/100==2)
   {  char *k;
      strcpy(gUser->in_buf,"PWD");
      if (PWD(0))
      {  strcpy(gUser->in_buf,"CWD ");
         strcat(gUser->in_buf,gWD);
         forwardCommand();
         sprintf(gUser->in_buf,eNoSuchFile,dir);
         forwardReply();
         free(save);
         return 0;
      }

      if (isThere)
      {  k=(char*)strrchr(save,'/');
         strcpy(gUser->in_buf,"SIZE ");
         strcat(gUser->in_buf,(k)?k+1:save+i);
         forwardCommand();
         *isThere=(status/100==2)?atoi(gUser->in_buf+4):0;
      }
   }

   strcpy(gUser->in_buf,"CWD ");
   strcat(gUser->in_buf,gWD);
   forwardCommand();

   if (status/100!=2)
   {  if (gLog>=log_err) syslog(LOG_ERR,stripcr("Cannot change directory."));
      notify(eClosed);
      free(save);
      exit_program(1);
   }
   strcpy(gUser->in_buf,save);
   free(save);

   return true;

} // pathValid

void AutoBan(long ip)
{
   FILE *file;

   if (gBanClass)
   {

#ifdef _LINUX
      if (gHostsDeny)
      {           
         file=fopen(gDenyFile,"a");
         if (!file)
         {  if (gLog>=log_err) syslog(LOG_ERR,stripcr("Can't open ./conf/hosts.deny"));
         }
         else
         {  fprintf(file,"vftpd: %d.%d.%d.\n",
                    gUser->addr[0].sin_addr.s_addr&0xff,
                    (gUser->addr[0].sin_addr.s_addr>>8)&0xff,
                    (gUser->addr[0].sin_addr.s_addr>>16)&0xff
                   );
         }
         fclose(file);
      }
#endif
      file=fopen(gDenyFile,"a");
      if (!file)
      {  if (gLog>=log_err) syslog(LOG_ERR,stripcr("Can't open %s"),kDenyFile);
         return;
      }

      fprintf(file,"%d.%d.%d\n",
              gUser->addr[0].sin_addr.s_addr&0xff,
              (gUser->addr[0].sin_addr.s_addr>>8)&0xff,
              (gUser->addr[0].sin_addr.s_addr>>16)&0xff
             );

      fclose(file);

      if (gLog>=log_warning) syslog(LOG_WARNING,stripcr("BANNED %d.%d.%d"),
                                    gUser->addr[0].sin_addr.s_addr&0xff,
                                    (gUser->addr[0].sin_addr.s_addr>>8)&0xff,
                                    (gUser->addr[0].sin_addr.s_addr>>16)&0xff
                                   );

   }
   else
   {

#ifdef _LINUX
      if (gHostsDeny)
      {
         file=fopen(gDenyFile,"a");
         if (!file)
         {  if (gLog>=log_err) syslog(LOG_ERR,stripcr("Can't open /etc/hosts.deny"));
         }
         else
         {  fprintf(file,"vftpd: %s\n",
                    inet_ntoa(gUser->addr[0].sin_addr));
            fclose(file);
         }
      }
#endif      
      file=fopen(gDenyFile,"a");
      if (!file)
      {  if (gLog>=log_err) syslog(LOG_ERR,stripcr("Can't open %s"),kDenyFile);
         return;
      }
      fprintf(file,"%s\n",
              inet_ntoa(gUser->addr[0].sin_addr));

      fclose(file);

      if (gLog>=log_warning) syslog(LOG_WARNING,stripcr("BANNED %s"),
                                    inet_ntoa(gUser->addr[0].sin_addr));
   }

   exit_program(0);

} // AutoBan

int rejectIP(long ip)
{
   char cip[16];
   char *c;

   sprintf(cip,"%d.%d.%d.%d",
           ip&0xff,
           (ip>>8)&0xff,
           (ip>>16)&0xff,
           ip>>24
          );

   if (ReadConfigFile(gDenyFile))
   {
      c=gConfigFile;

      c=(char*)strtok(gConfigFile," \n\t");
      while (c)
      {
         if (strlen(c))
         {
            if (*c=='*' || (char*)strstr(cip,c)==cip)
            {
               free(gConfigFile);
               gConfigFile=0;
               if (gLog>=log_warning) syslog(LOG_WARNING,stripcr("ACCESS DENIED: %s"),cip);
               return 1;
            }
         }
         c=(char*)strtok(0," \n\t");
      }

      free(gConfigFile);
      gConfigFile=0;
   }

   if (ReadConfigFile(gAllowFile))
   {
      c=gConfigFile;

      c=(char*)strtok(gConfigFile," \n\t");
      while (c)
      {
         if (strlen(c))
         {
            if (*c=='*' || (char*)strstr(cip,c)==cip)
            {
               free(gConfigFile);
               gConfigFile=0;
               return 0;
            }
         }
         c=(char*)strtok(0," \n\t");
      }

      free(gConfigFile);
      gConfigFile=0;
   }

   if (gLog>=log_warning) syslog(LOG_WARNING,stripcr("ACCESS DENIED: %s"),cip);
   return 1;

} // rejectIP

#ifdef _MACOS
int CheckProcess(pid_t pid)
{
   return 0;
}
#endif

void LoggedIn(User *user)
{
   ulong i;
   size_t len;
   char *in_buf;
   ulong count;
   int s;
   pid_t pid;

   gUser=user;

   gTimeOut=user->maxIdle;
   s=user->s[0];

   in_buf=user->in_buf=mymalloc(kInBufSize);
   user->d_buf=malloc(kInBufSize);

   if (user->port)
   {
      long count=0;
      FILE *file=0;
      size_t size;

      if (ReadConfigFile(gPidFile))
      {
         int status;
         pidfilerec *pfr=(pidfilerec*)gConfigFile;
         char *next;

         while (true)
         {  if (pfr->pid==0)
               break;

            pfr->user=(char*)(pfr+1);
            next=(char*)((pidfilerec*)(pfr->user+strlen(pfr->user)+1));
            size=gConfigFile+gConfigFileSize-next;

            if (strcmp(pfr->user,gUser->login)==0)
            {
#ifdef _LINUX
               char dir[256];
               sprintf(dir,"/proc/%d",pfr->pid);
               if (!chdir(dir))
#endif
#ifdef _WIN32
                  if (OpenProcess(0,0,pfr->pid))
#endif
#ifdef _MACOS
                     if (CheckProcess(pfr->pid))
#endif
                        ++count;
                     else
                     {  memmove(pfr,next,size);
                        continue;
                     }

            }
            pfr=(pidfilerec*)next;
         }
         size=((ulong)pfr)-((ulong)gConfigFile);
         if (size)
         {
            size_t w;
            size_t towrite;
            char *buf;

            gConfigFileSize=size;
            if (count>=gUser->maxCon)
            {
               gConfigFileSize+=sizeof(pidfilerec);
               ((pidfilerec*)(gConfigFile+size))->pid=0;
            }
            file=fopen(gPidFile,"w");

            if (!file)
            {
               gErr=errno;
               free(gConfigFile);
               gConfigFile=0;
               if (gLog>=log_debug) syslog(LOG_DEBUG,stripcr("Can't open pidfile for wr."));
               errorMsg(gErr);
               notify(eClosed);
               return;
            }

            buf=gConfigFile;
            towrite=gConfigFileSize;
            do
            {
               w=fwrite(buf,1,towrite,file);
               if (w==0)
               {
                  gErr=errno;
                  fclose(file);
                  free(gConfigFile);
                  gConfigFile=0;
                  if (gLog>=log_debug) syslog(LOG_DEBUG,stripcr("fwrite (LoggedIn) : "));
                  errorMsg(gErr);
                  notify(eClosed);
                  return;
               }
               towrite-=w;
               buf+=w;

            } while (towrite);
         }
         else
         {  fclose(file);
            file=0;
         }

         free(gConfigFile);
         gConfigFile=0;
      }

      if (count>=gUser->maxCon)
      {
         ham(gHamCount,gHamTime);      
         notify(eMaxCon);
         exit_program(0);
         return;
      }

      if (!file)
         file=fopen(gPidFile,"w");

      if (!file)
      {
         gErr=errno;
         if (gLog>=log_debug) syslog(LOG_DEBUG,stripcr("Can't open pidfile for writing ."));
         errorMsg(gErr);
         notify(eClosed);
         return;
      }

      {
         size_t w;
         size_t towrite;

         pidfilerec *pfr=malloc(towrite=strlen(gUser->login)+1+sizeof(pidfilerec)*2);
         pfr->pid=getpid();
         memmove(pfr->user=(char*)(pfr+1),gUser->login,strlen(gUser->login)+1);
         ((pidfilerec*)(pfr->user+strlen(pfr->user)+1))->pid=0;
         w=fwrite(pfr,1,towrite,file);
         free(pfr);
         if (w==0 || w<towrite)
         {
            gErr=errno;
            if (gLog>=log_debug) syslog(LOG_DEBUG,stripcr("Cant write pidfile record."));
            errorMsg(gErr);
            fclose(file);
            notify(eClosed);
            return;
         }
      }
      if (file)
         fclose(file);
   }

   if (Server_login())
   {  forwardReply();
      return; 
   }

   sprintf(in_buf,iLoggedIn,user->login);
   forwardReply();

   while (CanRead(s,true))
   {
      count=cmd_in(s,in_buf,kInBufSize,false);
      if (count==kInBufSize)
      {
         notify(eTooLong);
         while (count==kInBufSize)
            if (CanRead(s,true))
               count=cmd_in(s,in_buf,kInBufSize,false);
         continue;
      }
      if (count)
      {
         char *sname;
         i=5;
         if (in_buf[3]==' ')
            i=4;
         else
            i=5;

         sname=mystrdup(in_buf+i);

         switch (cmd=ntohl(*(long*)in_buf))
         {
         case 'PASS':
            notify(eUSERfirst);
            break;

         case 'QUIT':
            notify(gGoodbyeMsg);
            close(gUser->s[0]);
            gUser->s[0]=0;
            forwardCommand();
            free(sname);
            return;

         case 'USER':
            notify(eAlready);
            break;

         case 'PORT':
            if (PORT()==-1)
               notify(eIllegalPORT);
            break;

         case 'PASV':
            if (PASV()==-1)
               notify(ePASVinvalid);
            break;

         case 'LIST':
         case 'NLST':
            if (pathValid(true,false,0))
            {
               if (ftpGet(0,1,false,false))
               {  WaitReply(gUser->s[1],true);
                  forwardReply();  
               }
            }
            break;

         case 'PWD\0':
         case 'XPWD':
            PWD(1);
            break;

         case 'CWD ':
         case 'XCWD':
            CWD();
            break;

         case 'CDUP':
         case 'XCUP':
            CDUP();
            break;

         case 'SIZE':
         case 'MDTM':
            if (pathValid(true,true,0))
            {  forwardCommand();
               forwardReply();
            }
            break;                  

         case 'RETR':   //down_perm
            if (gUser->perms&down_perm)
            {
               if (pathValid(true,true,&isThere))
               {  long credit=(((long)gUser->ratio*(long)gUser->ul)-(long)gUser->dl);

                  if ((gUser->ratio) && (credit<isThere-gRest))
                  {  sprintf(gUser->in_buf,eRatio,credit/(long)1024);
                     forwardReply();
                     sprintf(gUser->in_buf,ePermDenied,sname,"(Ratio)");
                     forwardReply();

                  }
                  else
                  {  if (ftpGet(0,1,false,gUser->cache_enable))
                     {  if (gUser->ratio)
                        {  sprintf(gUser->in_buf,iDlCredit,((long)gUser->ratio*(long)gUser->ul-(long)gUser->dl)/(long)1024);
                           forwardReply();
                        }
                        if (gCacheFile)
                           strcpy(gUser->in_buf,iTransferComp);
                        else
                           WaitReply(gUser->s[1],true);

                        forwardReply();
                     }
                  }
               }
            }
            else
            {  sprintf(gUser->in_buf,ePermDenied,sname,"(Download)");
               forwardReply();
            }
            break;

         case 'STOU':
         case 'STOR':
         case 'APPE':
            if (gUser->perms&up_perm)
            {  if (pathValid(true,true,&isThere))
               {  if ((cmd=='STOR' || cmd=='APPE') && ((gUser->perms&chg_perm)==0))
                  {  if (isThereFlag)
                     {  sprintf(gUser->in_buf,ePermDenied,sname,(cmd=='STOR')?"(Overwrite)":"(Append)");
                        forwardReply();
                        break;
                     }
                  }
                  if (ftpGet(0,1,true,gUser->cache_enable))
                  {  if (gUser->ratio)
                     {  sprintf(gUser->in_buf,iDlCredit,((long)gUser->ratio*(long)gUser->ul-(long)gUser->dl)/(long)1024);
                        forwardReply();
                     }
                     WaitReply(gUser->s[1],true);
                     forwardReply();
                  }
               }
            }
            else
            {  sprintf(gUser->in_buf,ePermDenied,sname,"(Upload)");
               forwardReply();
            }
            break;

         case 'MKD ':   //up_perm
         case 'XMKD':
            if (gUser->perms&up_perm)
            {  if (pathValid(true,true,0))
               {  forwardCommand(); 
                  forwardReply();
               }
            }
            else
            {  sprintf(gUser->in_buf,ePermDenied,sname,"(Make directory)");
               forwardReply();
            }
            break;

         case 'ABOR':
         case 'TYPE':
         case 'MODE':
         case 'NOOP':
         case 'HELP':
         case 'STRU':
         case 'SYST':
            forwardCommand();
            forwardReply();
            break;

         case 'REST':
            forwardCommand();
            forwardReply();
            if (status/100<4)
               gRest=atol(gUser->in_buf+5);
            else
               gRest=0;
            break;

         case 'XRMD':
         case 'RMD ':
         case 'DELE':     // chg_perm
         case 'RNFR':
         case 'RNTO':
            if (gUser->perms&chg_perm)
            {  if (pathValid(true,true,0))
               {  forwardCommand(); 
                  forwardReply();
               }
            }
            else
            {  sprintf(gUser->in_buf,ePermDenied,sname,((cmd=='RNFR') || (cmd=='RNTO'))?"(Rename)":"(Delete)");
               forwardReply();
            }
            break;

         case 'STAT':
         case 'SITE':
         case 'ALLO':
         default:
            {  char msg[2048];
               if ((strlen(in_buf)+strlen(eSyntaxError))>2047)
                  in_buf[2046-strlen(eSyntaxError)]=0;
               sprintf(msg,eSyntaxError,in_buf);
               notify(msg);
               break;
            }
         }
         free(sname);
         if (cmd!='REST')
            gRest=0;
      }
   }

} // LoggedIn
