// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"afx.h"
#include	"newdialog.h"
#include	"ftpsystem.h"
#include	"config.h"
#include	<pwd.h>
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<sys/types.h>

static const char rcsid[]="$Id: userdialog.C,v 1.2 1998/06/09 02:12:11 mrsam Exp $";

CCUserDialog::CCUserDialog() : m_system(NULL)
{
}

CCUserDialog::~CCUserDialog()
{
}

void CCUserDialog::Create()
{
	if (!m_system)	return;

CCDialogWindowInfo CreateInfo[] = {
	CCDialogWindowInfo(1, 15, 20, 64, &m_ftpuser, (CString)_T("User:")),

	} ;

	Title(_T("FTP User Id"));

	CCTitledDialogWindow::Create(40, 3, CreateInfo,
		sizeof(CreateInfo)/sizeof(CreateInfo[0]));
	m_ftpuser=_T("");
}

void CCUserDialog::Selected()
{
	m_system->m_uid=m_ftpuser;

	if (((CString)m_ftpuser).GetLength())
	{
		m_system->SendUser();
	}
	else
	{
		m_system->SendSyst(0, TRUE, _T(""));
	}
	Destroy();
}

BOOL CCUserDialog::AcceptInputNonFocus(int key)
{
	if (key == ESCKEY)
	{
		Destroy();
		if (m_system)	// We aborted a mandatory pwd
			m_system->SendQuit();
		return (TRUE);
	}
	return (CCTitledDialogWindow::AcceptInputNonFocus(key));
}
