// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#ifndef	system_h
#define	system_h

#include	"afxtempl.h"
#include	"filelist.h"

#define	DIRNAME_CURRENT	_T(".")
#define	DIRNAME_PARENT	_T("..")

static const char system_h_rcsid[]="$Id: system.h,v 1.2 1998/02/27 04:22:19 mrsam Exp $";

class CCLogWindow;
class CFileList;
class CDirEntry;
class CFTPSystem;

////////////////////////////////////////////////////////////////////////////
//
// CSystem class represents a "system", either the local one, or the remote
// FTP directory.  The CSystem class is the companion class to CFileList.
//
// While CFileList represents the contents of a directory, this class
// represents the system where the directory comes from.
//
// CLocalSystem defines functions to read the contents of the local system.
// CFTPSystem is used to derive functions to read the contents of the
// directory from the remote system.
//

class CSystem {
protected:
	CCLogWindow *m_log;	// My log window
public:
	CString	m_curdir;	// My current directory
	CFileList *m_fwindow;	// My corresponding filelist
	void operator=(CCLogWindow *p)	{ m_log=p; }
	void operator=(CFileList *p)	{ m_fwindow=p; }

	CSystem() : m_log(NULL), m_fwindow(NULL)	{}
	virtual ~CSystem();
	virtual void ReReadCurrentDir()=0;
	virtual BOOL UpFromCurrentDir()=0;
	virtual BOOL ChangeDir(CString dir)=0;
	virtual void Transfer(const CList<CDirEntry, const CDirEntry &> &)=0;
	virtual BOOL MakeDir(CString)=0;
	virtual BOOL RemoveDir(CString)=0;
	virtual BOOL Rename(CString old, CString)=0;
	virtual BOOL Delete(CString)=0;
} ;

class CLocalSystem : public CSystem {
private:
	BOOL readdir();
	CFTPSystem *m_remote_system;
public:
	CLocalSystem()	{}
	virtual ~CLocalSystem();
	void operator=(CCLogWindow *p)	{ CSystem::operator=(p); }
	void operator=(CFileList *p)	{ CSystem::operator=(p); }
	void operator=(CFTPSystem *p)	{ m_remote_system=p; }
	void	Initialize();
	virtual void ReReadCurrentDir();
	virtual BOOL UpFromCurrentDir();
	virtual BOOL ChangeDir(CString dir);
	virtual void Transfer(const CList<CDirEntry, const CDirEntry &> &);

	virtual BOOL MakeDir(CString);
	virtual BOOL RemoveDir(CString);
	virtual BOOL Rename(CString old, CString);
	virtual BOOL Delete(CString);

	} ;
#endif
