// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"filelist.h"
#include	"system.h"
#include	"ftpsystem.h"
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	"my_dirent.h"
#include	<errno.h>
#include	<sys/stat.h>

static const char rcsid[]="$Id: system.C,v 1.5 1998/06/17 04:18:11 mrsam Exp $";

CSystem::~CSystem()
{
}

CLocalSystem::~CLocalSystem()
{
}

void	CLocalSystem::Initialize()
{
int	l=PATH_MAX;
CString	dirname;

	for (;;)
	{
	LPTSTR p=dirname.GetBuffer(l);

		if (getcwd(p, l) != NULL)	break;
		dirname.ReleaseBuffer(0);
		if (errno != ERANGE)
			AfxThrowInternalException();
		l += PATH_MAX;
	}
	m_curdir=dirname;
	dirname.ReleaseBuffer(-1);
	readdir();
}

BOOL	CLocalSystem::readdir()
{
DIR	*dirp=0;

	if (!m_fwindow)	return (FALSE);
	m_fwindow->OpenDir(m_curdir);

	dirp=opendir(_T("."));
	if (!dirp)	return (FALSE);
	try
	{
	struct dirent *p;
	CDirEntry dirEntry;
	struct stat buf;

		while ((p= ::readdir(dirp)) != NULL)
		{
			dirEntry.m_name=p->d_name;
			if (stat(dirEntry.m_name, &buf) == 0)
				dirEntry.m_isdirectory= S_ISDIR(buf.st_mode)
					? TRUE:FALSE;
			m_fwindow->AddDirEntry(dirEntry);
		}
		closedir(dirp);
	}
	catch (...)
	{
		closedir(dirp);
		throw;
	}
	m_fwindow->CloseDir();
	return (TRUE);
}

void CLocalSystem::ReReadCurrentDir()
{
	readdir();
}

BOOL CLocalSystem::UpFromCurrentDir()
{
	if (chdir(_T("..")))
	{
		if (m_log)
			m_log->AddLine(_T("Unable to change directory."));
		return (FALSE);
	}
	Initialize();
	return (TRUE);
}

BOOL CLocalSystem::ChangeDir(CString subdir)
{
	if (chdir(subdir))
	{
		if (m_log)
			m_log->AddLine(_T("Unable to change directory."));
		return (FALSE);
	}
	Initialize();
	return (TRUE);
}

void CLocalSystem::Transfer(const CList<CDirEntry, const CDirEntry &> &list)
{
	if (m_remote_system)
		m_remote_system->TransferStore(list);
}

BOOL CLocalSystem::MakeDir(CString dirname)
{
	if (mkdir(dirname, 0777))
	{
		if (m_log)
			m_log->AddLine(_T("Unable to create directory ")
				+ dirname + _T("."));
		return (FALSE);
	}
	CLocalSystem::ReReadCurrentDir();
	return (TRUE);
}

BOOL CLocalSystem::RemoveDir(CString dirname)
{
	if (rmdir(dirname))
	{
		if (m_log)
			m_log->AddLine(_T("Unable to remove ") + dirname
				+ _T("."));
		return (FALSE);
	}
	CLocalSystem::ReReadCurrentDir();
	return (TRUE);
}

BOOL CLocalSystem::Rename(CString old, CString newname)
{
	if (rename(old, newname))
	{
		if (m_log)
			m_log->AddLine(_T("Unable to rename ") + old
				+ _T("."));
		return (FALSE);
	}
	CLocalSystem::ReReadCurrentDir();
	return (TRUE);
}

BOOL CLocalSystem::Delete(CString str)
{
	if (remove(str))
	{
		if (m_log)
			m_log->AddLine(_T("Unable to remove ") + str
				+ _T("."));
		return (FALSE);
	}
	CLocalSystem::ReReadCurrentDir();
	return (TRUE);
}
