// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#include	"afx.h"
#include	"afxtempl.h"

#include	<iostream.h>
#include	<memory.h>
#include	<ctype.h>

// $Id: string2.C,v 1.4 1998/06/04 05:05:33 mrsam Exp $

// This string is a filename/pathname.  If string is too long for our needs
// shorten it a bit, and replace cut out stuff with "..."

#define	ELLIPSIS	_T("...")

CString CString::FileTitleTruncate(size_t maxLength)
{
int	l=GetLength();

	if ((size_t)l <= maxLength)	return (*this);	// Not necessary

CString	buf= ELLIPSIS;

	if (l && *(LPCTSTR)*this == '/')
		buf= _T("/") ELLIPSIS;

	if ((size_t)buf.GetLength() >= maxLength)
		return (buf.Left(maxLength));	// Cutting it a wee bit much

int	left=maxLength-buf.GetLength();

CString	temp_buf=Right(left);

	l=temp_buf.Find('/');
	if (l < 0)	l=0;

	return (buf + temp_buf.Mid(l));
}

CStringArray CStringTok(CString string, CString sep, BOOL smart=FALSE)
{
CStringList tokens;
int	inquotes=0;
int	prevtoken=0;
LPCSTR	strptr=string;
size_t	strleft=string.GetLength();
CString	buf;

	while (strleft)
	{
	int	ischar=TRUE;

		if (!inquotes)
		{
		LPCSTR sep_ptr=sep;
		size_t sep_cnt=sep.GetLength();

			while (sep_cnt)
			{
				if (*sep_ptr == *strptr)
					break;
				--sep_cnt;
				++sep_ptr;
			}
			if (sep_cnt)	ischar=FALSE;
		}

		if (ischar && !prevtoken)
			buf=_T("");
		if (!ischar && prevtoken)
			tokens.AddTail(buf);
		if (ischar)
		{
			if (smart && *strptr == '\\' && strleft > 1)
				++strptr, --strleft;
			else if (smart && *strptr == '"')
			{
				inquotes= !inquotes;
				++strptr; -- strleft;
				continue;
			}
			buf += *strptr;
		}
		prevtoken=ischar;
		++strptr;
		--strleft;
	}
	if (prevtoken)
		tokens.AddTail(buf);	// Last token

CStringArray array;

	array.SetSize(tokens.GetCount());

size_t	i=0;
POSITION p=tokens.GetHeadPosition();

	while (p)
		array[i++]=tokens.GetNext(p);
	return (array);
}

CStringArray CStringSplit(CString s, TCHAR fld)
{
CStringArray a;
size_t	i, j, k, n;

	j=s.GetLength();
	n=1;
	for (i=0; i<j; i++)
		if (s[i] == fld)	++n;

	a.SetSize(n);
	n=0;
	k=0;
	for (i=0; i<j; i++)
		if (s[i] == fld)
		{
			a[n++]=s.Mid(k, i-k);
			k=i+1;
		}
	a[n]=s.Mid(k);
	return (a);
}

CString CStringPaste(CStringArray a, TCHAR fld)
{
CString	s;
size_t	i, n;

	n=a.GetSize();
	for (i=0; i<n; i++)
	{
		if (i)	s += fld;
		s += a[i];
	}
	return (s);
}
