// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"afx.h"
#include	"stordialog.h"
#include	"ftpsystem.h"
#include	"filelist.h"
#include	"config.h"
#include	"session.h"
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif

static const char rcsid[]="$Id: stordialog.C,v 1.2 1998/06/09 02:12:11 mrsam Exp $";

CCStorDialog::CCStorDialog()
{
	m_local.Required();
	m_remote.Required();
}

CCStorDialog::~CCStorDialog()
{
}

void CCStorDialog::Create()
{
	if (!m_filelist || ! m_system)	return;

CCDialogWindowInfo CreateInfo[] = {
	CCDialogWindowInfo(3, 20, 30, 255, &m_remote, (CString)_T("FTP file:")),
	CCDialogWindowInfo(1, 20, 30, 255, &m_local, (CString)_T("Local file:")),
	} ;

CString	name=m_filelist->CurrentItemText();

	Title(_T("Store file"));

	CCTitledDialogWindow::Create(55, 5, CreateInfo,
		sizeof(CreateInfo)/sizeof(CreateInfo[0]));
	m_local=name;
}

void CCStorDialog::Selected()
{
	Destroy();
	m_system->StoreFile(m_local, m_remote);
}
