// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#ifndef	status_h
#define	status_h

#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif

static const char status_h_rcsid[]="$Id: status.h,v 1.2 1998/06/09 02:12:11 mrsam Exp $";

#if TIME_WITH_SYS_TIME
#include	<sys/time.h>
#include	<time.h>
#else
#if HAVE_SYS_TIME_H
#include	<sys/time.h>
#else
#include	<time.h>
#endif
#endif
#include	"afxwindow.h"

class CFTPSystem;

//////////////////////////////////////////////////////////////////////
//
//  Transfer status window
//

class CTransferWindow : public CCTitledWindow {

	long	m_totalbytes;		// # of bytes that will be transferred
	long	m_bytestransferred;	// How many transferred so far

	time_t	m_starttime;
	time_t	m_lastupdate;		// Last time we took measurements

	CFTPSystem *m_ftpptr;
	void	(CFTPSystem::*m_ftpAbort)();

public:
	CTransferWindow();
	~CTransferWindow();
	void Create();
	void Destroy();

	void Start(CString filename, long nbytes);
	void SetSize(long nbytes);
	void Finish();
	void Processed(long nbytes);
	void SetEscapeHandler(CFTPSystem *, void (CFTPSystem::*)() );
	BOOL AcceptInput(int ch);
private:
	void Redraw();
	CString FormatSize();
	CString FormatNum(long, CString &);

	CString FormatTime();
	} ;

#endif
