// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"status.h"
#include	"debug.h"

static const char rcsid[]="$Id: status.C,v 1.3 1998/06/09 02:12:11 mrsam Exp $";

#define	WIDTH	50
#define	HEIGHT	7

CTransferWindow::CTransferWindow() :
	m_ftpptr(NULL), m_ftpAbort((void (CFTPSystem::*)())NULL)
{
}

CTransferWindow::~CTransferWindow()
{
	Destroy();
}

void CTransferWindow::Create()
{
	m_totalbytes=0;
	m_bytestransferred=0;

int	w=BaseWindow->Width(), h=BaseWindow->Height();

	h= (h < HEIGHT+2) ? 1: (h-HEIGHT+2)/2+1;
	w= (w < WIDTH+2) ? 1: (w-WIDTH+2)/2+1;

	CCTitledWindow::Title(_T(""));
	CCTitledWindow::Create(h, w, WIDTH, HEIGHT);
	SetCursorPos(HEIGHT-1, WIDTH-1);
	time(&m_starttime);
	m_lastupdate=m_starttime-1;

	CTransferWindow::Redraw();
}

void CTransferWindow::Destroy()
{
	CCTitledWindow::Destroy();
}

void CTransferWindow::Start(CString filename, long bytes)
{
	if (m_totalbytes == 0)
		m_totalbytes=bytes;
	m_bytestransferred=0;

int	w=Width();

	if (w > 14)	w -= 14;
	else		w = 14;

	Title(_T("Transferring " ) + filename.FileTitleTruncate(w));

	time(&m_starttime);
	m_lastupdate=m_starttime-1;
}

void CTransferWindow::Finish()
{
	m_totalbytes=m_bytestransferred;
	Processed(0);
	CTransferWindow::Redraw();
}

void CTransferWindow::Processed(long nbytes)
{
	m_bytestransferred += nbytes;

time_t	t;

	time(&t);
	if (t != m_lastupdate)
	{
		m_lastupdate=t;
		CTransferWindow::Redraw();
	}
}

void CTransferWindow::SetSize(long nbytes)
{
	if (m_totalbytes < nbytes)
	{
		m_totalbytes=nbytes;
		CTransferWindow::Redraw();
	}
}

void CTransferWindow::Redraw()
{
	if (!m_window)	return;

	Write(1, 1, _T("Bytes transferred: ") +
		(FormatSize() + CString(' ', 30)).Left(30) );
	Write(3, 4,    _T("Time remaining: ") +
		(FormatTime() + CString(' ', 30)).Left(30) );

	if (m_lastupdate > m_starttime)
	{
	long	nsecs=m_lastupdate - m_starttime;

	CString	units, num=FormatNum(
			(m_bytestransferred + nsecs/2)/nsecs, units );

		Write(5, 14,             _T("Rate: ") +
			(num + units + _T("/sec") + CString(' ', 30)).Left(30));
	}
	Refresh();
}

CString CTransferWindow::FormatSize()
{
	if (m_totalbytes < m_bytestransferred)
		m_totalbytes=m_bytestransferred;

CString	units1, units2;
CString num1=FormatNum(m_bytestransferred, units1);
CString num2=FormatNum(m_totalbytes, units2);

	if (m_totalbytes == m_bytestransferred)
		return (num1 + units1);

	return (num1 + units1 + _T(" of ") + num2 + units2);
}

CString CTransferWindow::FormatNum(long nbytes, CString &units)
{
char	buf[40];

	if (nbytes < 1024)
	{
		sprintf(buf, "%ld", nbytes);
		units=_T(" bytes");
		return (buf);
	}

	if (nbytes < 1024 * 1024)
	{
		sprintf(buf, "%ld.%ld", nbytes / 1024,
			(nbytes % 1024) * 10 / 1024);
		units=_T("K");
		return (buf);
	}

	sprintf(buf, "%ld.%02ld", nbytes / (1024L * 1024),
		(nbytes % (1024L * 1024)) * 100 / (1024L * 1024L));
	units=_T("MB");
	return (buf);
}

CString CTransferWindow::FormatTime()
{
CString	buf;
char	chbuf[20];

	if (m_totalbytes <= m_bytestransferred ||
		m_bytestransferred == 0 ||
		m_lastupdate < m_starttime + 3)
		return (_T("N/A"));

long	nsecs=m_lastupdate - m_starttime;
long	nleft= (long)((double)m_totalbytes/m_bytestransferred*nsecs)-nsecs;

	if (nleft >= 60 * 60)
	{
		sprintf(chbuf, "%ld", nleft / (60*60));
		buf += chbuf + (CString)_T(" hr, ");
	}

	if (nleft >= 60)
	{
		sprintf(chbuf, "%ld", (nleft % (60*60)) / 60);
		buf += chbuf + (CString)_T(" min, ");
	}

	sprintf(chbuf, "%ld", (nleft % 60));
	return (buf + chbuf + _T(" sec"));
}

BOOL CTransferWindow::AcceptInput(int ch)
{
	if (ch == ESCKEY)
	{
		if (m_ftpptr)
			(m_ftpptr->*m_ftpAbort)();
		return (TRUE);
	}

	if (ch != MENUKEY)
		return (TRUE);
	return (FALSE);
}

void CTransferWindow::SetEscapeHandler(CFTPSystem *obj,
	void (CFTPSystem::*func)() )
{
	m_ftpptr=obj;
	m_ftpAbort=func;
}
