// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#ifndef	session_h
#define	session_h

#include	"afxtempl.h"
#include	"config.h"

static const char session_h_rcsid[]="$Id: session.h,v 1.2 1998/06/16 01:20:56 mrsam Exp $";

#define	CONFIGFORBIDDEN	_T(":# \t")

#define	SESSION_KEY	_T("S")
#define	USERSETTING_KEY	_T("U")
#define	CONFIGASCIIEXT	_T("A")

//////////////////////////////////////////////////////////////////////////////
//
//  Save sessions in $HOME/.sftp/session file.  Load sessions from the same
//  file, as well as IDIR1/session and IDIR2/session.
//
//

class CSession {
public:
	CString m_name;
	CString	m_host;
	CString m_port;
	CString m_user;
	CString m_acct;
	CString m_remotedir;
	CString m_hostdir;

	CSession()	{}
	~CSession()	{}

	CStringArray LoadSessionNames();
	BOOL	Load(CString name);

	BOOL	SaveSession(CString name, CString host,
			CString port, CString uid,
			CString acct, CString remote_dir,
			CString local_dir);

	CStringArray GetMultipleSettings(CString name);
	CString	GetSetting(CString name);
	void	SetSetting(CString name, CString value);
	void	SetSetting(CString name, CStringArray values);

private:
	CString ConfigDir();
	CString ConfigName();
	CString BackupName();
	void	Split(CString s);
	void	Split(CString s, CStringArray &a);

	CStringArray GetMultipleSettings(CString name, CString configfile);
	} ;
#endif
