// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"session.h"
#include	"config.h"
#include	<sys/stat.h>
#include	<iostream.h>
#include	<fstream.h>
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<pwd.h>

static const char rcsid[]="$Id: session.C,v 1.4 1998/06/17 04:12:30 mrsam Exp $";

CString CSession::ConfigDir()
{
CString	s;
struct	passwd	*pwd;

	if ((pwd=getpwuid(getuid())) == NULL)
		s="/";
	else
		s=(CString)pwd->pw_dir;

	s += IDIR3;
	mkdir(s, 0644);	// Just in case
	return (s);
}

CString	CSession::ConfigName()
{
CString	s=ConfigDir() + "/" SESSIONS;

	return (s);
}

CString	CSession::BackupName()
{
	return (ConfigDir() + "/~" SESSIONS);
}

BOOL CSession::Load(CString id)
{
ifstream	f;
CString	filenames[3];
CString name, host, port, user, acct, remotedir, hostdir;
BOOL	found=FALSE;
int	i;

	filenames[0] = IDIR1 "/" SESSIONS;
	filenames[1] = IDIR2 "/" SESSIONS;
	filenames[2] = ConfigName();

	for (i=0; i<3; i++)
	{
	CString		line;

		f.open(filenames[i]);
		if (f.fail())
			continue;
		while ( (line << f) == 0)
		{
			Split(line);

			if (m_name.GetLength() == 0)
				continue;

			if (m_name != id)
				continue;
			name=m_name;
			host=m_host;
			port=m_port;
			user=m_user;
			acct=m_acct;
			remotedir=m_remotedir;
			hostdir=m_hostdir;
			found=TRUE;
		}
		f.close();
	}

	if (!found)	return (FALSE);
	m_name=name;
	m_host=host;
	m_port=port;
	m_user=user;
	m_acct=acct;
	m_remotedir=remotedir;
	m_hostdir=hostdir;
	return (TRUE);
}

CStringArray CSession::LoadSessionNames()
{
ifstream	f;
CString	filenames[3];
CStringList l;
int	i;

	filenames[0] = IDIR1 "/" SESSIONS;
	filenames[1] = IDIR2 "/" SESSIONS;
	filenames[2] = ConfigName();

	for (i=0; i<3; i++)
	{
	CString		line;

		f.close();
		f.open(filenames[i]);
		if (f.fail())
			continue;
		while ( (line << f) == 0)
		{
			Split(line);

			if (m_name.GetLength() == 0)
				continue;

		POSITION p=l.GetHeadPosition();
		POSITION savepos;
		int	rc=1;

			while ( (savepos=p) )
			{
				rc=m_name.Compare(l.GetNext(p));
				if (rc <= 0)
					break;
			}
			if (rc) // New entry
				if (savepos)
					l.InsertBefore(savepos, m_name);
				else
					l.AddTail(m_name);
		}
	}

CStringArray a;

	a.SetSize(l.GetCount());

size_t	n;
POSITION p;

	for (n=0, p=l.GetHeadPosition(); p; n++)
		a[n]=l.GetNext(p);
	return (a);
}

void CSession::Split(CString line, CStringArray &a)
{
int	i;

	if ((i=line.Find('#')) >= 0)
		line=line.Left(i);
	line.TrimLeft();
	line.TrimRight();
	a=CStringSplit(line, ':');
}


void CSession::Split(CString line)
{
CStringArray	a;

	Split(line, a);
	m_name=_T("");
	m_host=_T("");
	m_port=FTP_CONTROL_PORT_DEFAULT_S;
	m_user=_T("");
	m_acct=_T("");
	m_remotedir=_T("");
	m_hostdir=_T("");
	if (a.GetSize() == 0 || a[0] != SESSION_KEY)	return;

	if (a.GetSize() > 1) m_name=a[1];
	if (a.GetSize() > 2) m_host=a[2];
	if (a.GetSize() > 3) m_user=a[3];
	if (a.GetSize() > 4) m_acct=a[4];
	if (a.GetSize() > 5) m_remotedir=a[5];
	if (a.GetSize() > 6) m_hostdir=a[6];
	if (a.GetSize() > 7) m_port=a[7];
}
 
BOOL	CSession::SaveSession(CString name, CString host, CString port,
		CString uid, CString acct, CString remote_dir,
		CString local_dir)
{
ifstream fold;
ofstream fnew;
CString file_name=ConfigName();
CString new_file=BackupName();
CString	line;

	fnew.open(new_file, ios::out | ios::trunc);
	if (!fnew.is_open())
		return (FALSE);

	fold.open(file_name, ios::in);
	if (fold.is_open())
		while ( (line << fold) == 0)
		{
			Split(line);
			if (line.GetLength() && m_name == name)
				break;
			fnew << line << endl;
		}

CStringArray	a;

	a.SetSize(8);
	a[0]=SESSION_KEY;
	a[1]=name;
	a[2]=host;
	a[3]=uid;
	a[4]=acct;
	a[5]=remote_dir;
	a[6]=local_dir;
	a[7]=port;
	fnew << CStringPaste(a, ':') << endl;

	while (fold.is_open() && (line << fold) == 0)
		fnew << line << endl;
	if (fold.is_open())
		fold.close();
	if (fnew.fail() || fnew.bad() || (fnew.close(), fnew.fail()))
		return (FALSE);
	rename(new_file, file_name);
	return (TRUE);
}

CStringArray CSession::GetMultipleSettings(CString name)
{
CStringArray	a=GetMultipleSettings(name, ConfigName());

	if (a.GetSize() > 0)	return (a);

	// If we don't find anything in the user's file, try load the defaults
	// from the global files

	a=GetMultipleSettings(name, IDIR2 "/" SESSIONS);
	if (a.GetSize() == 0)
		a=GetMultipleSettings(name, IDIR1 "/" SESSIONS);
	return (a);
}

CStringArray CSession::GetMultipleSettings(CString name, CString configname)
{
CStringArray	a, b;
ifstream	ifs;
CString		line;

	ifs.open(configname);
	if (!ifs.is_open())
		return (a);

	while ( (line << ifs) == 0)
	{
		Split(line, b);
		if (b.GetSize() >= 3 && b[0] == USERSETTING_KEY && b[1] == name)
			a.Add(b[2]);
	}
	ifs.close();
	return (a);
}

CString	CSession::GetSetting(CString name)
{
CStringArray	a=GetMultipleSettings(name);

	return (a.GetSize() == 0 ? (CString)_T(""):a[0]);
}

void	CSession::SetSetting(CString name, CString value)
{
CStringArray	a;

	a.SetSize(1);
	a[0]=value;
	SetSetting(name, a);
}

void	CSession::SetSetting(CString name, CStringArray values)
{
ifstream	ifs;
ofstream	ofs;
CString	old_file=ConfigName();
CString new_file=BackupName();
CString	line;
BOOL	saved;
int	rc;
CStringArray a;
CStringArray b;

	ifs.open(old_file);
	ofs.open(new_file, ios::out | ios::trunc);

	if (!ofs.is_open())	return;

	saved=FALSE;

	b.SetSize(3);
	b[0]=USERSETTING_KEY;
	b[1]=name;

	do
	{
		rc= (line << ifs);
		if (rc == 0)
			Split(line, a);

		if ( !saved && (
			(rc || ( a.GetSize() >= 3 &&
				 a[0] == USERSETTING_KEY && a[1] == name)
			)
				)
		) {
		size_t i, n;

			saved=TRUE;
			for (i=0, n=values.GetSize(); i<n ; i++)
			{
				b[2]=values[i];
				ofs << CStringPaste(b, ':') << endl;
			}
		}
		else if (rc == 0)
		{
			if ( !(a.GetSize() >= 3 &&
				 a[0] == USERSETTING_KEY && a[1] == name))
				ofs << line << endl;
		}
	} while (rc == 0);
	ifs.close();
	if (!ofs.bad())
	{
		ofs.close();
		rename(new_file, old_file);
	}
	else
		ofs.close();
}
