// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"afx.h"
#include	"savedialog.h"
#include	"ftpsystem.h"
#include	"session.h"
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<sys/types.h>

static const char rcsid[]="$Id: savedialog.C,v 1.3 1998/06/16 01:20:56 mrsam Exp $";

CCSaveDialog::CCSaveDialog()
	: m_remote(NULL), m_local(NULL)
{
	m_savename.Required();
}

CCSaveDialog::~CCSaveDialog()
{
}

void CCSaveDialog::Create()
{
CCDialogWindowInfo CreateInfo[] = {
	CCDialogWindowInfo(1, 20, 30, 255, &m_savename, (CString)_T("Save As:")),
	} ;

	if (!m_remote || !m_local || m_remote->m_host == NULL
		|| m_remote->m_host == "")
	{
		if (m_remote)
			m_remote->ReportError(
				_T("Please create an FTP connection first!"));
		return;
	}
	Title(_T("Save connection"));

CStringArray a=CSession().LoadSessionNames();

	m_savename=a;
	m_savename=_T("");
	m_savename.Forbidden(CONFIGFORBIDDEN);

	CCTitledDialogWindow::Create(55, 3, CreateInfo,
		sizeof(CreateInfo)/sizeof(CreateInfo[0]));
}

void CCSaveDialog::Selected()
{
char	buf[40];

	Destroy();
	sprintf(buf, "%ld", (long)m_remote->m_control_port);
	if (!CSession().SaveSession(m_savename,
		m_remote->m_host, buf, m_remote->m_uid, m_remote->m_acct,
		m_remote->m_curdir, m_local->m_curdir))
	{
		m_remote->ReportError(_T("Unable to save session"));
		return;
	}
	m_remote->m_log->AddLine(_T("Session saved"));

}
