// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"afx.h"
#include	"retrdialog.h"
#include	"ftpsystem.h"
#include	"filelist.h"
#include	"config.h"
#include	"session.h"
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif

static const char rcsid[]="$Id: retrdialog.C,v 1.2 1998/06/09 02:12:11 mrsam Exp $";

CCRetrDialog::CCRetrDialog()
{
	m_local.Required();
	m_remote.Required();
}

CCRetrDialog::~CCRetrDialog()
{
}

void CCRetrDialog::Create()
{
	if (!m_filelist || ! m_system)	return;

CCDialogWindowInfo CreateInfo[] = {
	CCDialogWindowInfo(1, 20, 30, 255, &m_local, (CString)_T("Local file:")),
	CCDialogWindowInfo(3, 20, 30, 255, &m_remote, (CString)_T("FTP file:")),

	} ;

CString	name=m_filelist->CurrentItemText();

	Title(_T("Retrieve file"));

	CCTitledDialogWindow::Create(55, 5, CreateInfo,
		sizeof(CreateInfo)/sizeof(CreateInfo[0]));
	m_remote=name;
}

void CCRetrDialog::Selected()
{
	Destroy();
	m_system->RetrieveFile(m_local, m_remote);
}
