// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"afx.h"
#include	"newdialog.h"
#include	"ftpsystem.h"
#include	"config.h"
#include	<pwd.h>
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<sys/types.h>

static const char rcsid[]="$Id: passdialog.C,v 1.2 1998/06/09 02:12:11 mrsam Exp $";

CCPassDialog::CCPassDialog() : m_system(NULL)
{
	m_ftppassword.Password();
}

CCPassDialog::~CCPassDialog()
{
}

void CCPassDialog::Create()
{
CCDialogWindowInfo CreateInfo[] = {
	CCDialogWindowInfo(1, 15, 20, 64, &m_ftppassword, (CString)_T("Password:")),

	} ;

	Title(_T("Password required"));

	CCTitledDialogWindow::Create(40, 3, CreateInfo,
		sizeof(CreateInfo)/sizeof(CreateInfo[0]));
	m_ftppassword=_T("");
	if (m_system && m_system->m_uid == ANON)
		m_ftppassword=CFTPSystem::AnonPassword();
}

void CCPassDialog::Selected()
{
	if (((CString)m_ftppassword).GetLength() && m_system)
	{
		m_system->m_pwd=m_ftppassword;
		m_system->SendPass();
	}
	else
		m_system->NotBusy();
	Destroy();
}

BOOL CCPassDialog::AcceptInputNonFocus(int key)
{
	if (key == ESCKEY)
	{
		Destroy();
		if (m_system && !m_system->Busy())	// We aborted a mandatory pwd
			m_system->SendQuit();
		return (TRUE);
	}
	return (CCTitledDialogWindow::AcceptInputNonFocus(key));
}
