// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"afx.h"
#include	"opendialog.h"
#include	"ftpsystem.h"
#include	"session.h"
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<sys/types.h>

static const char rcsid[]="$Id: opendialog.C,v 1.3 1998/06/16 01:20:56 mrsam Exp $";

CCOpenDialog::CCOpenDialog() : m_remote(NULL), m_local(NULL)
{
	m_sessionList.DoSelects(FALSE);
	m_sessionList= this;
}

CCOpenDialog::~CCOpenDialog()
{
}

void CCOpenDialog::Create()
{
CCDialogWindowInfo CreateInfo[] = {
	CCDialogWindowInfo(0, 0, 30, 8, &m_sessionList, (CString)_T("")),
	} ;

	Title(_T("Open connection"));

	m_sessionList.m_listStrings=CSession().LoadSessionNames();

	CCTitledDialogWindow::Create(30, 8, CreateInfo,
		sizeof(CreateInfo)/sizeof(CreateInfo[0]));
}

void CCOpenDialog::Selected(size_t ndx)
{
CString	name;

	if (ndx >= m_sessionList.GetCount())	return;
	name=m_sessionList.m_listStrings[ndx];

	Destroy();

	ConnectSession(name);
}

BOOL CCOpenDialog::ConnectSession(CString name)
{
CSession	session;

	if (!session.Load(name))
		return (FALSE);
	m_local->ChangeDir(session.m_hostdir);
	m_remote->Connect(session.m_host, session.m_port,
		session.m_user, _T(""), session.m_acct, session.m_remotedir);
	return (TRUE);
}
