// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"afx.h"
#include	"newdialog.h"
#include	"ftpsystem.h"
#include	"config.h"
#include	"session.h"
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif

static const char rcsid[]="$Id: newdialog.C,v 1.3 1998/06/16 01:20:56 mrsam Exp $";

CCNewDialogAnonymous::CCNewDialogAnonymous()
{
}

CCNewDialogAnonymous::~CCNewDialogAnonymous()
{
}

void CCNewDialogAnonymous::Selected()
{
	m_pDialog->m_ftpuserid=ANON;
	m_pDialog->m_ftppassword=CFTPSystem::AnonPassword();
	m_pDialog->Selected();
}

CCNewDialog::CCNewDialog() : m_system(NULL)
{
	m_anonymous.m_pDialog=this;
	m_ftpsite.Required();
	m_ftpport.Required();
	m_ftppassword.Password();
}

CCNewDialog::~CCNewDialog()
{
}

void CCNewDialog::Create()
{
CCDialogWindowInfo CreateInfo[] = {
	CCDialogWindowInfo(1, 20, 30, 255, &m_ftpsite, (CString)_T("FTP Site:")),
	CCDialogWindowInfo(3, 20, 4, 6, &m_ftpport, (CString)_T("FTP Port:")),
	CCDialogWindowInfo(5, 20, &m_anonymous),
	CCDialogWindowInfo(7, 20, 20, 64, &m_ftpuserid, (CString)_T("FTP Userid:")),
	CCDialogWindowInfo(9, 20, 20, 64, &m_ftppassword, (CString)_T("FTP Password:")),
	CCDialogWindowInfo(11, 20, 20, 64, &m_ftpaccount, (CString)_T("FTP Account:")),

	} ;

	Title(_T("New connection"));

CString	forbiddenChars=CONFIGFORBIDDEN;

	m_ftpsite.Forbidden(forbiddenChars);
	m_ftpport.Forbidden(forbiddenChars);
	m_ftpuserid.Forbidden(forbiddenChars);
	m_ftppassword.Forbidden(forbiddenChars);
	m_ftpaccount.Forbidden(forbiddenChars);

	m_anonymous.Title(_T("Anonymous FTP"));
	CCTitledDialogWindow::Create(55, 14, CreateInfo,
		sizeof(CreateInfo)/sizeof(CreateInfo[0]));
	m_ftpport=FTP_CONTROL_PORT_DEFAULT_S;
}

void CCNewDialog::Selected()
{
	Destroy();
	m_system->Connect(m_ftpsite, m_ftpport,
		m_ftpuserid, m_ftppassword, m_ftpaccount, _T(""));
}
