// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	<iostream.h>
#include	<signal.h>
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<stdlib.h>
#include	"afx.h"
#include	"afxtempl.h"
#include	"afxwindow.h"
#include	"filelist.h"
#include	"system.h"
#include	"ftpsystem.h"
#include	"newdialog.h"
#include	"opendialog.h"
#include	"savedialog.h"
#include	"extdialog.h"
#include	"retrdialog.h"
#include	"stordialog.h"
#include	"viewdialog.h"
#include	"commands.h"
#include	"filetype.h"
#include	"config.h"

static const char rcsid[]="$Id: main.C,v 1.4 1998/06/16 01:20:56 mrsam Exp $";

#ifdef	DEBUG
int debug_level=0;
#endif

const char *progname;

class CFtp : public CCBaseWindow {

	BOOL m_quitsent;
public:
	CLocalSystem	m_local_system;
	CFTPSystem 	m_remote_system;

	CFtp();
	BOOL AcceptInputNonFocus(int);
	~CFtp()	{}
} ;

CFtp::CFtp()	: m_quitsent(FALSE)
{
	m_remote_system= &m_local_system;
		// Remote system needs to know about the local
		// one
	m_local_system= &m_remote_system;
		// And vice-versa
}

CFtp	*base_window_ptr;

BOOL CFtp::AcceptInputNonFocus(int ch)
{
	if (ch == ESCKEY)
	{
		if (m_quitsent)	// If user axes again, just give up the ghost
			QuitWindows();
		m_quitsent=TRUE;
		m_remote_system.Quit();
		return (TRUE);
	}
	return (CCBaseWindow::AcceptInputNonFocus(ch));
}

class CCWindowCloseCommand : public CCWindow {
public:
	CFTPSystem *m_remote_system;

	CCWindowCloseCommand(): m_remote_system(NULL)	{}
	void operator=(CFTPSystem *p) { m_remote_system=p; }
	~CCWindowCloseCommand()	{}
	void Create()	{ if (m_remote_system) m_remote_system->Close(); }
} ;

class CCWindowCDUPCommand : public CCWindow {
public:
	CFTPSystem *m_remote_system;

	CCWindowCDUPCommand(): m_remote_system(NULL)	{}
	void operator=(CFTPSystem *p) { m_remote_system=p; }
	~CCWindowCDUPCommand()	{}
	void Create()	{ if (m_remote_system)
				m_remote_system->UpFromCurrentDir(); }
} ;

class CCWindowExitCommand : public CCWindow {
public:
	CFtp *m_ftp;

	CCWindowExitCommand() : m_ftp(NULL) {}
	void operator=(CFtp *p) { m_ftp=p; }
	void Create()	{ if (m_ftp)	m_ftp->AcceptInputNonFocus(ESCKEY); }
	~CCWindowExitCommand() {}
} ;

class CCWindowViewDirCommand : public CCWindow {
public:
	CFTPSystem *m_ftp;

	CCWindowViewDirCommand() : m_ftp(NULL) {}
	void operator=(CFTPSystem *p) { m_ftp=p; }
	void Create()	{ if (m_ftp)	m_ftp->ViewDir(); }
	~CCWindowViewDirCommand() {}
} ;

class CSymbolicLinkOptionList : public CCListButtonWindow {

	CFTPSystem	*m_ftp;

public:
	BOOL		m_selected;

	CSymbolicLinkOptionList() : m_ftp(NULL), m_selected(FALSE) {}
	void	operator=(CCListWindow *p) { CCListButtonWindow::operator=(p); }
	void	operator=(CFTPSystem *p)   { m_ftp=p; }
	void	SelectedButton(size_t)
		{
			m_selected= !m_selected;
			IsSelected(0, m_selected);
			m_ftp->FollowSymbolicLinks(m_selected);
		}
} ;


// Only one instance of the following!

class CCMainWindow : public CCDialogWindow {
public:
	CFileList local_filelist, remote_filelist;

	CCMenuBarWindow menu_bar;
	CCNewDialog new_dialog;
	CCSaveDialog save_dialog;
	CCOpenDialog open_dialog;
	CCAsciiExtensionsDialog ext_dialog;
	CCMenuPopupWindow file_menu, local_menu, remote_menu, options_menu;
	CFileTypeList file_type_list;
	CSymbolicLinkOptionList symbolic_option_list;
	CCLogWindow log;
	CCWindowCloseCommand close_cmd;
	CCWindowCDUPCommand cdup_cmd;
	CCWindowExitCommand exit_cmd;
	CCWindowViewDirCommand viewdir_cmd;

	CCWindowChdirCommand	local_chdir, remote_chdir;
	CCWindowMkdirCommand	local_mkdir, remote_mkdir;
	CCWindowRmdirCommand	local_rmdir, remote_rmdir;
	CCWindowRenameCommand	local_rename, remote_rename;
	CCWindowDeleteCommand	local_delete, remote_delete;
	CCViewDialog				remote_view;
	CCRetrDialog				remote_retr;
	CCStorDialog				remote_stor;
	CCMainWindow();

	~CCMainWindow();
	void Create();
	} ;

CCMainWindow::CCMainWindow() : menu_bar(base_window_ptr)
{
	local_filelist= &base_window_ptr->m_local_system;
	remote_filelist= &base_window_ptr->m_remote_system;
	base_window_ptr->m_local_system=&local_filelist;
	base_window_ptr->m_local_system= &log;
	base_window_ptr->m_remote_system=&remote_filelist;
	base_window_ptr->m_remote_system.LogWindow(&log);

	new_dialog= &base_window_ptr->m_remote_system;
	save_dialog=&base_window_ptr->m_remote_system;
	save_dialog=&base_window_ptr->m_local_system;
	open_dialog=&base_window_ptr->m_remote_system;
	open_dialog=&base_window_ptr->m_local_system;

	file_type_list= &options_menu.m_menuList;
	symbolic_option_list= &options_menu.m_menuList;
	symbolic_option_list= &base_window_ptr->m_remote_system;

	base_window_ptr->m_remote_system= &file_type_list;
	Transparent(TRUE);

	close_cmd= &base_window_ptr->m_remote_system;
	cdup_cmd= &base_window_ptr->m_remote_system;
	exit_cmd= base_window_ptr;
	viewdir_cmd= &base_window_ptr->m_remote_system;

	local_chdir= &base_window_ptr->m_local_system;
	local_mkdir= &base_window_ptr->m_local_system;
	local_rmdir= &base_window_ptr->m_local_system;
	local_rename= &base_window_ptr->m_local_system;
	local_delete= &base_window_ptr->m_local_system;

	local_chdir= &local_filelist;
	local_mkdir= &local_filelist;
	local_rmdir= &local_filelist;
	local_rename= &local_filelist;
	local_delete= &local_filelist;

	remote_chdir= &base_window_ptr->m_remote_system;
	remote_mkdir= &base_window_ptr->m_remote_system;
	remote_rmdir= &base_window_ptr->m_remote_system;
	remote_rename= &base_window_ptr->m_remote_system;
	remote_delete= &base_window_ptr->m_remote_system;
	remote_view= &base_window_ptr->m_remote_system;
	remote_retr= &base_window_ptr->m_remote_system;
	remote_stor= &base_window_ptr->m_remote_system;

	remote_chdir= &remote_filelist;
	remote_mkdir= &remote_filelist;
	remote_rmdir= &remote_filelist;
	remote_rename= &remote_filelist;
	remote_delete= &remote_filelist;
	remote_view= &remote_filelist;
	remote_retr= &remote_filelist;
	remote_stor= &local_filelist;
}

void CCMainWindow::Create()
{
int	nrows, ncols;

	menu_bar.Add(_T("FTP"), &file_menu);
	menu_bar.Add(_T("Local"), &local_menu);
	menu_bar.Add(_T("Remote"), &remote_menu);
	menu_bar.Add(_T("Options"), &options_menu);
	menu_bar.Create();
	file_menu.Add(_T("New"), &new_dialog);
	file_menu.Add(_T("Open"), &open_dialog);
	file_menu.Add(_T("Save"), &save_dialog);
	file_menu.Add(_T("Close"), &close_cmd);
	file_menu.Add(_T(""), NULL);
	file_menu.Add(_T("Exit"), &exit_cmd);

	file_type_list.AddButtonListEntry(
			options_menu.Add(_T("ASCII Transfer"), &file_type_list));
	file_type_list.AddButtonListEntry(
			options_menu.Add(_T("BINARY Transfer"), &file_type_list));
	file_type_list.AddButtonListEntry(
			options_menu.Add(_T("Auto Transfer"), &file_type_list));
	file_type_list.SelectedAuto();
	options_menu.Add(_T("Set extensions"), &ext_dialog);
	options_menu.Add(_T(""), NULL);

	symbolic_option_list.AddButtonListEntry(
			options_menu.Add(_T("Follow FTP symbolic links"),
			&symbolic_option_list));
	symbolic_option_list.IsSelected(0, FALSE);
	symbolic_option_list.m_selected=FALSE;

	local_menu.Add(_T("Change directory"), &local_chdir);
	local_menu.Add(_T("Create directory"), &local_mkdir);
	local_menu.Add(_T("Remove directory"), &local_rmdir);
	local_menu.Add(_T("Rename file"), &local_rename);
	local_menu.Add(_T("Remove file"), &local_delete);

	remote_menu.Add(_T("Change directory"), &remote_chdir);
	remote_menu.Add(_T("Change directory up"), &cdup_cmd);
	remote_menu.Add(_T("Create directory"), &remote_mkdir);
	remote_menu.Add(_T("Remove directory"), &remote_rmdir);
	remote_menu.Add(_T("View directory"), &viewdir_cmd);
	remote_menu.Add(_T("Rename file"), &remote_rename);
	remote_menu.Add(_T("Remove file"), &remote_delete);
	remote_menu.Add(_T("View file"), &remote_view);
	remote_menu.Add(_T(""), NULL);
	remote_menu.Add(_T("Retrieve"), &remote_retr);
	remote_menu.Add(_T("Store"), &remote_stor);

	nrows=base_window_ptr->Height();
	nrows -= 5;
	if (nrows <= 0)	nrows=1;
	ncols=base_window_ptr->Width();

	nrows -= 8;
	if (nrows < 0)	nrows=0;

	ncols=(ncols-8)/2;
	if (ncols < 0)	ncols=0;

	local_filelist.Prefix(_T("LCL: "));
	remote_filelist.Prefix(_T("FTP: "));

CCDialogWindowInfo CreateInfo[] = {
	CCDialogWindowInfo(1, 2, ncols, nrows, &local_filelist, (CString)_T("")),
	CCDialogWindowInfo(1, base_window_ptr->Width()-2-ncols,
		ncols, nrows, &remote_filelist, (CString)_T("")),
	CCDialogWindowInfo(base_window_ptr->Height()-10, 1, base_window_ptr->Width()-2,
		4, &log, (CString)_T("")),
	} ;
	CCDialogWindow::Create(4, 0, base_window_ptr->Width(), nrows+8,
		CreateInfo, sizeof(CreateInfo)/sizeof(CreateInfo[0]));
}

CCMainWindow::~CCMainWindow()
{
}

static void usage(const char *p)
{
	cerr << "Usage: " << p << " [options] [host|session]" << endl
		<< endl
		<< "         host      Optional host to connect to." << endl
		<< "         session   Optional session to connect to." << endl
		<< endl
		<< "Options:" << endl
#ifdef	DEBUG
		<< "         -d n   Set debug output level to n." << endl
#endif
		<< "         -h     Show this help message." << endl
		<< "         -z     Run a subshell on a suspend signal." << endl
		<< "         -U n   Set FTP user to n." << endl
		<< "         -A n   Set FTP account to n." << endl;
}

static int main2(CString, CString, CString);

int main(int argc, char *argv[])
{
CFtp	base_window;
int rc;
CString	host=_T(""), user=_T(""), acct=_T("");

	base_window_ptr= &base_window;
	progname=argv[0];

int	optc;

	while ((optc=getopt(argc, argv,

#ifdef	DEBUG
		"d:"
#endif
			"hzU:A:"

			)) >= 0)
	{
		switch (optc)	{
		case 'h':
			usage(argv[0]);
			return (0);
#ifdef	DEBUG
		case 'd':
			debug_level=atoi(optarg);
			break;
#endif
		case 'z':
			CCBaseWindowSUSPEND::UseSubshell();
			break;
		case 'U':
			user=optarg;
			break;
		case 'A':
			acct=optarg;
			break;
		case '?':
			usage(argv[0]);
			return (1);
		}
	}

	if (optind < argc)
	{
		if (optind+1 < argc)
		{
			usage(argv[0]);
			return (1);
		}
		host=argv[optind];
	}

	try
	{
		base_window.Create();
		rc=main2(host, user, acct);
		base_window.Destroy();
	}
	catch (CException *ce)
	{
		base_window.Destroy();
		ce->ReportError();
		ce->Delete();
		rc= 99;
	}
	return (rc);
}

static int main2(CString host, CString user, CString acct)
{
CCMainWindow main_window;

	signal(SIGPIPE, SIG_IGN);

	base_window_ptr->Create();
	main_window.Create();
	base_window_ptr->m_local_system.Initialize();
	main_window.local_filelist.SetInput();
	main_window.log << VERSION " Copyright 1997-1998 Double Precision, Inc.";
	main_window.log << "Use " MENUKEYNAME " to access menus.";

	// If a name is given on the command line, first try to run a session
	// by that name, if failed, use it as a hostname to connect to (with
	// command line options).

	if ( host.GetLength() && !main_window.open_dialog.ConnectSession(host))
	{
	CString	port=FTP_CONTROL_PORT_DEFAULT_S;
	LPCTSTR p=host;
	unsigned i,j;

		for (i=j=0; p[i]; i++)
			if (p[i] == ':')	j=i+1;
		if (j && p[j])
		{
			port=p+j;
			host=host.Left(j-1);
		}

		base_window_ptr->m_remote_system.Connect(host, port,
			user, _T(""), acct, _T(""));
	}

	while (!CCWindow::QuitWindowsFlag)
		CIoh::Select();
}
