// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#ifndef	interpreter_h
#define	interpreter_h

static const char interpreter_h_rcsid[]="$Id: interpreter.h,v 1.3 1998/06/09 05:08:31 mrsam Exp $";

#include	<sys/types.h>
#include	"afx.h"
#include	"afxioh.h"

////////////////////////////////////////////////////////////////////////////
//
// We invoke a shell script to interpret remote FTP directory structure.
//
// This class encapsulates the shell script invocation, and works with
// the CFTPSystem class

class CFTPSystem;
class CFTPInterpreter;

class CFTPInterpreter {

	CFTPSystem *m_ftp;
	CString		m_sysid;
	CString		m_sysname;
	CString		m_script;
	CIohRedirect<CFTPInterpreter>	m_shread, m_shwrite, m_sherror;

	int		m_pid;	// process ID of running shell command.
	BOOL		m_boolDestructing;
	BOOL		m_boolInitializing;

public:
	CFTPInterpreter()	{ m_shread=this; m_shwrite=this;
					m_sherror=this; m_pid= -1;
					m_boolDestructing=FALSE;}
	void operator=(CFTPSystem *p) { m_ftp=p; }
	~CFTPInterpreter()
		{
			m_boolDestructing=TRUE;
			Kill();
		}

	BOOL Initialize(CString sysid, CString sysname);
private:
	void init(CString filename);
public:
	void	Abort()
		{
			(void)Kill();
		}

	CString	m_strDir;	// The DIR command

	void (CFTPInterpreter::*FilterDirectory(
			void (CFTPSystem::*writeDirFunc)(CString),
				CIoh *ReadDirPtr,
			void (CFTPSystem::*completedFunc)(int))
		)(CString);

	// Extract the size of the file from server transfer message
	void InterpretByteCount(
			void (CFTPSystem::*byteCountFunc)(long),
			CString message);

	// Take the name of the previous directory, plus what we chdired
	// into, and tell me what the name of the directory should be now
	// (this is used to check for symbolic links)

	void ComposeDirName(CString dir, CString subdir,
			void (CFTPSystem::*newdirFunc)(CString));
private:
	void (CFTPSystem::*m_writeDirFunc)(CString);
	void (CFTPSystem::*m_completedFunc)(int);
	void (CFTPSystem::*m_newdirFunc)(CString);

	CIoh *m_ReadDirPtr;
	void ReadFmtDir(CString);
	BOOL WriteRawDir(CString &);
	void FormatFinished(int);
	void SaveRawDirToWrite(CString);
	CString m_rawdirstring;

	void (CFTPSystem::*m_byteCountFunc)(long);
	CString m_byteCountMsg, m_byteCountNum;
	void SaveByteCount(CString);
	BOOL ReadByteCount(CString &);
	void ProcessByteCount(int);

	void ComposedDirName(int);
////////////
//
//  Identifying system:


	CStringList	m_scripts;	// Scripts left to do.

	void	TestNextScript();
	void	CheckTestScript(int);
	void	Initialized(int);

	void	ShellScriptFailure(int);
	void	ShellScriptUnexpected();
////////////

private:
	BOOL	Fork( CStringArray &args,
			void (CFTPInterpreter::*readHandler)(CString),
			void (CFTPInterpreter::*errorHandler)(CString),
			BOOL (CFTPInterpreter::*writeHandler)(CString &),
			void (CFTPInterpreter::*shellHandler)(int));
	int	Kill();
	int	Kill2(int, pid_t);
	BOOL	KillReadEOF();

	void	readTimeout(), readShell(), errorShell(), writeShell();
	CString	m_readshell, m_errorshell;
	int	Read(int, CString &);
	CString	m_writeBuf;

	void	ReadDir(CString);

	void	ReadEcho(CString), ErrorEcho(CString);
	BOOL	WriteEOF(CString &);

	void	(CFTPInterpreter::*m_shellHandler)(int);
	void	(CFTPInterpreter::*m_readHandler)(CString);
	void	(CFTPInterpreter::*m_errorHandler)(CString);
	CString	m_readBuf, m_errorBuf;
	BOOL	(CFTPInterpreter::*m_writeHandler)(CString &);
} ;

#endif

