// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#ifndef	ftpsystem_h
#define	ftpsystem_h

static const char ftpsystem_h_rcsid[]="$Id: ftpsystem.h,v 1.4 1998/06/16 01:20:56 mrsam Exp $";

#include	"afxtempl.h"
#include	"afxioh.h"
#include	"system.h"
#include	"filelist.h"
#include	"interpreter.h"
#include	"status.h"
#include	"passdialog.h"
#include	"userdialog.h"
#include	"config.h"

#if HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<errno.h>
#include	<sys/types.h>
#include	<netinet/in.h>
#include	<iostream.h>
#include	<fstream.h>

//////////////////////////////////////////////////////////////////////////////
//
// CFTPIoh

class CFTPSystem;
class CCLogWindow;
class CFileTypeList;
class CDirEntry;

class CFTPSystem : public CSystem {

	CSystem	*m_local_system;
	CFileTypeList *m_filetypeptr;

	CString	m_ctrlbuf;
	CFTPInterpreter m_interpreter;
	CTransferWindow	m_status;
	CCViewWindow	m_view;
	CStringList	m_viewList;
	CStringList	m_dirList;	// Directory listing.
	CCViewWindow	m_viewDir;
	BOOL	m_viewFile;
	BOOL	m_busy;

	CString	m_savelclcurdir, m_savesubdir;
	CString	m_saveftpcurdir;
			// When doing transfers of directory structures,
			// save previous directory, and the name of the
			// directory we chdired into.  After chdir-ing, check
			// the name of the current directory in order to
			// detect symbol links.


public:
	CIohRedirect<CFTPSystem> m_control, m_data;

static CString AnonPassword();

	struct in_addr	m_connect_addr;

	BOOL	m_followSymLinks;
	CString	m_host, m_uid, m_pwd, m_acct;
	unsigned short	m_control_port, m_data_port;
	CCLogWindow *m_log;
	BOOL	m_doQuit;
private:
	BOOL	Busy()
	{
	BOOL	flag=m_busy;

		m_busy=TRUE;
		return (flag);
	}

	void	NotBusy();
public:
	CFTPSystem();
	void operator=(CFileList *p)
		{
			CSystem::operator=(p);
		}
	void operator=(CSystem *p) { m_local_system=p; }
	void operator=(CFileTypeList *p) { m_filetypeptr=p; }
			
	~CFTPSystem()
		{
		}

	// Initialize, and open connection

	void LogWindow(CCLogWindow *log)
		{m_log=log; CSystem::operator=(m_log); }
	void Connect(CString host, CString port, CString uid, CString pwd, CString acct,
		CString dir);

	// Report errno, then close all sockets

	void ErrorTimeout();
	void ErrnoError();
	void ReportErrnoError();
	void ReportError(CString);
	void Error(CString);

private:
	// Control connection established
	void Connected();
	void SendUser(int, BOOL, CString);
	void SendUser();
	void SendPass(int, BOOL, CString);
	void SendPass();
	void SendAcct(int, BOOL, CString);
	void SendSyst(int, BOOL, CString);
	void ProcessSyst(int, BOOL, CString);

	CCPassDialog m_pwddialog;
	CCUserDialog m_userdialog;

	BOOL IsConnected()
		{
			return (m_control.fd() >= 0);
		}
public:
	friend class CCPassDialog;
	friend class CCUserDialog;
	void Initialized(BOOL);
	void Quit();
	virtual void ReReadCurrentDir();
	virtual BOOL UpFromCurrentDir();
	virtual BOOL ChangeDir(CString dir);

	virtual BOOL MakeDir(CString);
	virtual BOOL RemoveDir(CString);
	virtual BOOL Rename(CString old, CString newf);
	virtual BOOL Delete(CString);
private:
	void DoUpFromCurrentDir();
	void DoChangeDir(CString dir);
	void DoMakeDir(CString dir);
	void ProcessedMKD(int, BOOL, CString);
	void ProcessedRNFR(int, BOOL, CString);
	BOOL m_treeTransfer;	// TRUE when changing directories as part
				// of transferring an entire directory tree
	CString m_transferDir;	// Directory just MKDIRed
	enum FTPTransferMode { retrieve_file, store_file }
		m_transferMode;
public:
	virtual void Transfer(const CList<CDirEntry, const CDirEntry &> &);
	void TransferStore(const CList<CDirEntry, const CDirEntry &> &);
	void Transfer(const CList<CDirEntry, const CDirEntry &> &, enum FTPTransferMode);
	void FollowSymbolicLinks(BOOL flag)
		{
			m_followSymLinks=flag;
		}
	void View(CString);
	void RetrieveFile(CString local_name, CString remote_name);
	void StoreFile(CString local_name, CString remote_name);
	void Close();
	void ViewDir();
private:
	void DoReadCurrentDir();
	void ProcessedCWD(int, BOOL, CString);
	void ProcessPWD(int, BOOL, CString);
	void SendDIR();
	void ProcessDIRType(int, BOOL, CString);
	void DirReadHandler(CString);
	void SaveDirContents(CString);
	void SavedDirContents(int);
	void (CFTPInterpreter::*m_writeDirToFilterPtr)(CString);

	void SendPort( void (CFTPSystem::*)());
	void (CFTPSystem::*m_portHandler)();
	void ProcessPort(int, BOOL, CString);

	void ProcessedDir();

	void SendQuit();
	void QuitSent(int, BOOL, CString);

	void ReadReply( void (CFTPSystem::*replyHandler)(int, BOOL, CString) );
	void ReadReplyRetrieve( void (CFTPSystem::*replyHandler)(int, BOOL, CString) );

	void (CFTPSystem::*m_replyHandler)(int, BOOL, CString);

	// Wait for a line from FTP server.

	void ReadAndProcessControlLine();
	size_t ReadControlLine();
	void ProcessControlLine();
	void FilterControlLine();
	void FilteredControlLine(long);
	BOOL ReceivedReplyLine();
	CString m_filterLine;

	void (CFTPSystem::*m_processlinehandler)();
	void (CFTPSystem::*m_readlinehandler)(CString);

	void ReadReplyCode(CString);	// Process reply line from server
	void ReadExtReply(CString); // Process extended reply from server
	CString m_extreplycode;	// Extended reply code
	void CallReplyHandler(CString);	// Process result code, call the
					// handler result code handler if
					// findal result code

	// Accept & process data connection
	// We must already have a listen on m_data

	char m_transferType;	// A-ASCII, I-Image
	fstream m_transferFile;
	CString m_transferFileName;

	CList<CDirEntry, const CDirEntry &> m_transferList;
	void StartTransfer();
	void StartTransferNewDir();
	void CheckSymbolicLink(CString);
	void ProcessedCwdTransfer(int, BOOL, CString);

	BOOL OpenTransferFile();
	void ProcessTransferType(int, BOOL, CString);
	void SendTYPE();
	void SendRETR();
	void SendSTOR();
	void RetrieveComplete();
	void StoreComplete();
	void ReadFile(CString);
	BOOL WriteFile(CString &s);

	void BeginDataTransfer( CString command,
				CString filename,
				long nbytes,
				void (CFTPSystem::*m_funcPtr)(),
				void (CFTPSystem::*m_readPtr)(CString),
				BOOL (CFTPSystem::*m_writePtr)(CString &),
				BOOL isRetrieve);
	time_t m_listenTimeout;
	CString m_dataFilename;
	long m_dataBytes;
	BOOL m_AbortSent;

	void SendAbort();
	void AcceptDataConnection();
	void ReadDataConnection();
	void WriteDataConnection();
	void DataTransferComplete();
	CString m_readBuf, m_readLineBuf, m_writeBuf;
	size_t m_writeBufPtr;

	BOOL m_boolDataTransferComplete;
	BOOL m_boolDataTransferStatusReceived;

	void (CFTPSystem::*m_ptrDataTransferred)();

	void (CFTPSystem::*m_ptrDataTransferRead)(CString);
	BOOL (CFTPSystem::*m_ptrDataTransferWrite)(CString &);

	void ProcessedTransferCommand(int, BOOL, CString);

	void CheckTransferComplete()
	{
		if (m_boolDataTransferComplete &&
			m_boolDataTransferStatusReceived)
		{
		void	(CFTPSystem::*p)()=m_ptrDataTransferred;

			if (p)		// Make sure we'll call the handler
					// only once
			{
				m_ptrDataTransferred=(void (CFTPSystem::*)())NULL;
				(this->*p)();
			}
			return;
		}
	}

	// Low-level writing functions

	void WriteLine(CString);	// Display this string in the log
					// window, append CRLF, write it.
	void Write(CString);		// Write this string
	void WriteHandler();
	CString m_writeBuffer;
	int	m_writePtr;
} ;
#endif
