// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"filetype.h"
#include	"session.h"

CFileTypeList::CFileTypeList()
{
}

CFileTypeList::~CFileTypeList()
{
}

void	CFileTypeList::SelectedButton(size_t n)
{
	if (n == 0)
		SelectedAscii();

	if (n == 1)
		SelectedBinary();

	if (n == 2)
		SelectedAuto();
}

void	CFileTypeList::SelectedAscii()
{
	m_transferType=ASCII_TRANSFER;
	IsSelected(0, TRUE);
	IsSelected(1, FALSE);
	IsSelected(2, FALSE);
}

void	CFileTypeList::SelectedBinary()
{
	m_transferType=IMAGE_TRANSFER;
	IsSelected(0, FALSE);
	IsSelected(1, TRUE);
	IsSelected(2, FALSE);
}

void	CFileTypeList::SelectedAuto()
{
	m_transferType=AUTO_TRANSFER;
	IsSelected(0, FALSE);
	IsSelected(1, FALSE);
	IsSelected(2, TRUE);
}

// Check transfer type to use for filename.  If it is fixed as ASCII or IMAGE,
// use that, otherwise look at the extension to figure out.  Match the
// extension against the list of ASCII extensions stored in the configuration
// file.  Config extension '*' matches a null extension.

char	CFileTypeList::TransferType(CString filename)
{
	if (m_transferType != AUTO_TRANSFER)
		return (m_transferType);
CStringArray	ascii_extensions=CSession().GetMultipleSettings(CONFIGASCIIEXT);
int	n=filename.ReverseFind('.');
CString	ext=_T("*");

	if (n >= 0)
	{
	CString	s=filename.Mid(n+1);

		if (s != _T("") && s.Find('/') < 0)
			ext=s;
	}
size_t	cnt=ascii_extensions.GetSize();
size_t	i;

	for (i=0; i<cnt; i++)
		if (ascii_extensions[i] == ext)
			return (ASCII_TRANSFER);
	return (IMAGE_TRANSFER);
}
