// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#ifndef	filelist_h
#define	filelist_h

static const char filelist_h_rcsid[]="$Id: filelist.h,v 1.3 1998/06/09 02:12:11 mrsam Exp $";

#include	"afxwindow.h"
#include	"afxtempl.h"

class CSystem;

/////////////////////////////////////////////////////////////////////
//
// Derives CTextListWindow to show contents of a directory
//

class CDirEntry {
public:
	CString	m_name;
	CString m_lclparent, m_ftpparent;
			// Used by CFTPSystem to return from symbolic
			// links

	int	m_isdirectory;	// TRUE - directory, FALSE - file

	CDirEntry();
	CDirEntry(const CDirEntry &o);
	CDirEntry &operator=(const CDirEntry &o);
	} ;

class CFileList : public CCTextListWindow {
	CCTitledWindow m_title;

	CSystem *m_mySystem;		// Which system I am representing.

	CString	m_curdir;		// The current directory
	CList<CDirEntry, const CDirEntry &> m_contents;
					// Contents of this directory

	CString m_prefix;		// What to show before directory name
					// as title

	BOOL	m_transferring;		// We are currently transferring files
public:
	CFileList();
	void operator=(CSystem *p) { m_mySystem=p; }
	~CFileList() { Destroy(); }
	void	Prefix(CString prefix) { m_prefix=prefix; }
virtual void	OpenDir(CString dirname);
	void	AddDirEntry(const CDirEntry &);
private:
	void	DoAddDirEntry(const CDirEntry &);
public:
	void	CloseDir();
	void	Redraw();
	void	Refresh();
	void	Selected(size_t);
private:
	void	SelectedFiles();
public:
	void	GetSelectedFiles(CList<CDirEntry, const CDirEntry &> &);
	void	Create(int row, int col, int width, int height);
	void	Destroy();
	void	Transferring() { m_transferring=TRUE; }
	BOOL	IsTransferring() { return (m_transferring); }
	void	SelectEntry(CString, BOOL flag);
	void	SelectAll();
	CString	CurrentItemText();
} ;

#endif
