// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"afx.h"
#include	"afxtempl.h"
#include	"extdialog.h"
#include	"config.h"
#include	"session.h"
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif

static const char rcsid[]="$Id: extdialog.C,v 1.2 1998/06/09 02:12:11 mrsam Exp $";

CCAsciiExtensionsDialog:: CCAsciiExtensionsDialog()
{
	m_ok=this;
	m_cancel=this;
}

CCAsciiExtensionsDialog::~CCAsciiExtensionsDialog()
{
}

void CCAsciiExtensionsDialog::Create()
{
CCDialogWindowInfo CreateInfo[] = {
	CCDialogWindowInfo(1, 15, 6, 32, &m_extension, (CString)_T("Extension:")),
	CCDialogWindowInfo(3, 15, 10, 8, &m_extensions, _T("")),
	CCDialogWindowInfo(12, 2, &m_ok),
	CCDialogWindowInfo(12, 28, &m_cancel),

	} ;

	Title(_T("Extensions of ASCII files"));
	m_ok.Title(_T("OK"));
	m_cancel.Title(_T("CANCEL"));
	m_cancel.RightAlign(TRUE);
	m_extension.Forbidden("." CONFIGFORBIDDEN);

	m_extensions.m_listStrings.RemoveAll();
CStringArray exts=CSession().GetMultipleSettings(CONFIGASCIIEXT);
size_t	n=exts.GetSize(), i;

	for (i=0; i<n; i++)
		AddExtension(exts[i]);

	CCTitledDialogWindow::Create(30, 13, CreateInfo,
		sizeof(CreateInfo)/sizeof(CreateInfo[0]));
}

void CCAsciiExtensionsDialog::Redraw()
{
CString	dashes('-', Width());

	CCTitledDialogWindow::Redraw();
	Write(2, 0, dashes);
	Write(11, 0, dashes);
}

void CCAsciiExtensionsDialog::Selected()
{
	if (m_extension != _T(""))
		AddExtension(m_extension);
	m_extension=_T("");
}

void CCAsciiExtensionsDialog::Ok()
{
	CSession().SetSetting(CONFIGASCIIEXT, m_extensions.m_listStrings);
	Destroy();
}

void CCAsciiExtensionsDialog::Cancel()
{
	Destroy();
}

void CCAsciiExtensionsDialog::AddExtension(CString newext)
{
size_t	n=m_extensions.m_listStrings.GetSize();
size_t	i;

	for (i=0; i<n; i++)
	{
	int	rc=m_extensions.m_listStrings[i].Compare(newext);

		if (rc == 0)	return;	// Already here
		if (rc > 0)	break;
	}
	m_extensions.m_listStrings.InsertAt(i, newext);
	m_extensions.Redraw();
}

void CCAsciiExtensionsListWindow::DeleteKey(size_t n)
{
	m_listStrings.RemoveAt(n);
	Redraw();
}
