// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#ifndef	debug_h
#define	debug_h

#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif

static const char debug_h_rcs_id[]="$Id: debug.h,v 1.2 1998/06/09 02:12:11 mrsam Exp $";

#ifdef	DEBUG

#if TIME_WITH_SYS_TIME
#include	<sys/time.h>
#include	<time.h>
#else
#if HAVE_SYS_TIME_H
#include	<sys/time.h>
#else
#include	<time.h>
#endif
#endif

extern int debug_level;

#define	TRACE(level, fmt)	TRACE2((level), __LINE__, __FILE__, fmt)

#define	TRACE2(level, line, file, fmt)	\
	if ((level) < debug_level)	\
	{				\
		cerr << file << "(" << line << "): " << fmt;	\
	}

class DebugFunction {
	char *funcname;
public:
	DebugFunction(char *p) : funcname(p)
	{
		if (4 < debug_level)
			cerr << "*** Entering function " << funcname << "***\n";
	}

	~DebugFunction()
	{
		if (4 < debug_level)
			cerr << "*** Exiting function " << funcname << "***\n";
	}
} ;

#define	TRACE_FUNCTION(p)	DebugFunction debug_function(p);

class DebugTimeStamp {
char	buf[10];
public:
	DebugTimeStamp()	{}
	operator const char *()	{
		time_t	t;

			time(&t);
			strftime(buf, sizeof(buf), "%H:%M:%S",
				localtime(&t));
			return (buf);
		}
	~DebugTimeStamp()	{}
} ;

#else

#define	TRACE(level,fmt)
#define	TRACE_FUNCTION(p)

#endif
#endif
