// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#ifndef	commands_h
#define	commands_h

static const char commands_h_rcsid[]="$Id: commands.h,v 1.1 1997/01/17 01:46:17 mrsam Exp $";

#include	"afxwindow.h"

class	CSystem;
class	CFileList;

///////////////////////////////////////////////////////////////////////////
//
// Various FTP commands...

class	CCWindowChdirCommand : public CCTitledDialogWindow {

	CSystem	*m_psystem;
	CFileList *m_pfilelist;

	CCEditWindow m_dirname;
public:
	CCWindowChdirCommand() : m_psystem(NULL), m_pfilelist(NULL)	{}
	~CCWindowChdirCommand()	{}
	void	Create();
	void	operator=(CSystem *p)	{ m_psystem=p; }
	void	operator=(CFileList *p)	{ m_pfilelist=p; }
	void	Selected();
} ;

class	CCWindowMkdirCommand : public CCTitledDialogWindow {

	CSystem	*m_psystem;
	CFileList *m_pfilelist;

	CCEditWindow m_dirname;
public:
	CCWindowMkdirCommand() : m_psystem(NULL), m_pfilelist(NULL)	{}
	~CCWindowMkdirCommand()	{}
	void	Create();
	void	operator=(CSystem *p)	{ m_psystem=p; }
	void	operator=(CFileList *p)	{ m_pfilelist=p; }
	void	Selected();
} ;

class	CCWindowRmdirCommand : public CCTitledDialogWindow {

	CSystem	*m_psystem;
	CFileList *m_pfilelist;

	CCEditWindow m_dirname;
public:
	CCWindowRmdirCommand() : m_psystem(NULL), m_pfilelist(NULL)	{}
	~CCWindowRmdirCommand()	{}
	void	Create();
	void	operator=(CSystem *p)	{ m_psystem=p; }
	void	operator=(CFileList *p)	{ m_pfilelist=p; }
	void	Selected();
} ;

class	CCWindowRenameCommand : public CCTitledDialogWindow {

	CSystem	*m_psystem;
	CFileList *m_pfilelist;

	CCEditWindow m_oldname, m_newname;
public:
	CCWindowRenameCommand() : m_psystem(NULL), m_pfilelist(NULL)	{}
	~CCWindowRenameCommand()	{}
	void	Create();
	void	operator=(CSystem *p)	{ m_psystem=p; }
	void	operator=(CFileList *p)	{ m_pfilelist=p; }
	void	Selected();
} ;

class	CCWindowDeleteCommand : public CCTitledDialogWindow {

	CSystem	*m_psystem;
	CFileList *m_pfilelist;

	CCEditWindow m_filename;
public:
	CCWindowDeleteCommand() : m_psystem(NULL), m_pfilelist(NULL)	{}
	~CCWindowDeleteCommand()	{}
	void	Create();
	void	operator=(CSystem *p)	{ m_psystem=p; }
	void	operator=(CFileList *p)	{ m_pfilelist=p; }
	void	Selected();
} ;

#endif
