// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"afx.h"
#include	"commands.h"
#include	"system.h"
#include	"filelist.h"
#include	"session.h"

static const char rcsid[]="$Id: commands.C,v 1.2 1998/06/09 02:12:11 mrsam Exp $";

//////////////////////////////////////////////////////////////////////////////
//
// CWD command

void CCWindowChdirCommand::Create()
{
	if (!m_psystem || !m_pfilelist)	return;

CCDialogWindowInfo CreateInfo[] = {
	CCDialogWindowInfo(1, 20, 30, 255, &m_dirname, (CString)_T("Change to:")),
	} ;

	Title(_T("Change directory"));

	m_dirname.Forbidden(CONFIGFORBIDDEN);
	m_dirname.Required();

	CCTitledDialogWindow::Create(55, 3, CreateInfo,
		sizeof(CreateInfo)/sizeof(CreateInfo[0]));
	m_dirname= m_pfilelist->CurrentItemText();
}

void CCWindowChdirCommand::Selected()
{
	Destroy();
	(void)m_psystem->ChangeDir(m_dirname);
}

//////////////////////////////////////////////////////////////////////////////
//
// MKD command

void CCWindowMkdirCommand::Create()
{
	if (!m_psystem || !m_pfilelist)	return;

CCDialogWindowInfo CreateInfo[] = {
	CCDialogWindowInfo(1, 20, 30, 255, &m_dirname, (CString)_T("Create:")),
	} ;

	Title(_T("Create directory"));

	m_dirname.Forbidden(CONFIGFORBIDDEN);
	m_dirname.Required();

	CCTitledDialogWindow::Create(55, 3, CreateInfo,
		sizeof(CreateInfo)/sizeof(CreateInfo[0]));
	m_dirname=_T("");
}

void CCWindowMkdirCommand::Selected()
{
	Destroy();
	(void)m_psystem->MakeDir(m_dirname);
}

//////////////////////////////////////////////////////////////////////////////
//
// RMD command

void CCWindowRmdirCommand::Create()
{
	if (!m_psystem || !m_pfilelist)	return;

CCDialogWindowInfo CreateInfo[] = {
	CCDialogWindowInfo(1, 20, 30, 255, &m_dirname, (CString)_T("Remove:")),
	} ;

	Title(_T("Remove directory"));

	m_dirname.Forbidden(CONFIGFORBIDDEN);
	m_dirname.Required();

	CCTitledDialogWindow::Create(55, 3, CreateInfo,
		sizeof(CreateInfo)/sizeof(CreateInfo[0]));
	m_dirname= m_pfilelist->CurrentItemText();
}

void CCWindowRmdirCommand::Selected()
{
	Destroy();
	(void)m_psystem->RemoveDir(m_dirname);
}

//////////////////////////////////////////////////////////////////////////////
//
// RENAME command

void CCWindowRenameCommand::Create()
{
	if (!m_psystem || !m_pfilelist)	return;

CCDialogWindowInfo CreateInfo[] = {
	CCDialogWindowInfo(3, 20, 30, 255, &m_newname, (CString)_T("Rename to:")),
	CCDialogWindowInfo(1, 20, 30, 255, &m_oldname, (CString)_T("Rename from:")),
	} ;

	Title(_T("Rename file"));

	m_newname.Forbidden(CONFIGFORBIDDEN);
	m_newname.Required();

	m_oldname.Forbidden(CONFIGFORBIDDEN);
	m_oldname.Required();

	CCTitledDialogWindow::Create(55, 5, CreateInfo,
		sizeof(CreateInfo)/sizeof(CreateInfo[0]));
	m_newname= _T("");
	m_oldname= m_pfilelist->CurrentItemText();
}

void CCWindowRenameCommand::Selected()
{
	Destroy();
	(void)m_psystem->Rename(m_oldname, m_newname);
}

//////////////////////////////////////////////////////////////////////////////
//
// DELETE command

void CCWindowDeleteCommand::Create()
{
	if (!m_psystem || !m_pfilelist)	return;

CCDialogWindowInfo CreateInfo[] = {
	CCDialogWindowInfo(1, 20, 30, 255, &m_filename, (CString)_T("Remove:")),
	} ;

	Title(_T("Remove file"));

	m_filename.Forbidden(CONFIGFORBIDDEN);
	m_filename.Required();

	CCTitledDialogWindow::Create(55, 3, CreateInfo,
		sizeof(CreateInfo)/sizeof(CreateInfo[0]));
	m_filename= m_pfilelist->CurrentItemText();
}

void CCWindowDeleteCommand::Selected()
{
	Destroy();
	(void)m_psystem->Delete(m_filename);
}
