// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"afxwindow.h"

static const char rcsid[]="$Id: afxwindow5.C,v 1.2 1998/06/09 02:12:11 mrsam Exp $";

CCEditComboTextListWindow::CCEditComboTextListWindow()
	: m_pComboBox(NULL)
{
	DoSelects(FALSE);
}

CCEditComboTextListWindow::~CCEditComboTextListWindow()
{
}

void CCEditComboTextListWindow::Selected(size_t n)
{
	(*m_pComboBox)=(m_listStrings[n]);
	m_pComboBox->m_listwindow.Destroy();
}

BOOL CCEditComboTextListWindow::AcceptInput(int ch)
{
	if (ch == ESCKEY)
	{
		if (m_pComboBox)
			m_pComboBox->m_listwindow.Destroy();
		return (TRUE);
	}
	if (ch == KEY_UP && CurrentItem() == 0)
	{
		m_pComboBox->m_listwindow.Destroy();
		return (TRUE);
	}

	CCTextListWindow::AcceptInput(ch);
	return (TRUE);
}

//

CCEditComboListWindow::CCEditComboListWindow()
{
}

CCEditComboListWindow::~CCEditComboListWindow()
{
	CCEditComboListWindow::Destroy();
}

void CCEditComboListWindow::operator=(CStringArray &list)
{
	m_list.m_listStrings=list;
	m_list.Redraw();
}

void CCEditComboListWindow::Create(int row, int col, int minwidth)
{
int	i, l=m_list.m_listStrings.GetSize();
int	j;

	for (i=0; i<l; i++)
	{
		j=m_list.m_listStrings[i].GetLength()+2;
		if (j > minwidth)	minwidth=j;
	}
	if (l > BaseWindow->Height())	l=BaseWindow->Height();
	CCTitledWindow::Create(row, col, minwidth, l ? l:1);
	m_list.DoSelects(FALSE);
	m_list.Create(Row(), Col(), Width(), Height());
}

void CCEditComboListWindow::Destroy()
{
	m_list.Destroy();
	CCTitledWindow::Destroy();
}

CCEditComboBoxWindow::CCEditComboBoxWindow()
{
	m_listwindow.m_list.m_pComboBox=this;
	m_isComboBox=TRUE;
}

CCEditComboBoxWindow::~CCEditComboBoxWindow()
{
	CCEditComboBoxWindow::Destroy();
}

void CCEditComboBoxWindow::Destroy()
{
	m_listwindow.Destroy();
	CCEditWindow::Destroy();
}

void CCEditComboBoxWindow::operator=(CStringArray &a)
{
	m_listwindow=a;
}

void CCEditComboBoxWindow::operator=(CString list)
{
	CCEditWindow::operator=(list);
}

BOOL CCEditComboBoxWindow::AcceptInput(int ch)
{
	if (ch == KEY_DOWN)
	{
		m_listwindow.Create(Row()+2, Col(), Width());

	size_t	n=m_listwindow.m_list.m_listStrings.GetSize(), i;

		for (i=0; i<n; i++)
		{
			if (_tcscmp( (CString)(*this),
				m_listwindow.m_list.m_listStrings[i]) < 0)
				break;
		}
		if (n)
			m_listwindow.m_list.MoveTo(i ? i-1:0);
			
		return (TRUE);
	}
	return (CCEditWindow::AcceptInput(ch));
}

/////////////////////////////////////////////////////////////////////////
//
// View window

CCViewWindow::CCViewWindow() : m_cursorRow(0), m_firstRow(0), m_firstCol(0)
{
}

CCViewWindow::~CCViewWindow()
{
}

void CCViewWindow::Create()
{
	Create(0, 0, BaseWindow->Width(), BaseWindow->Height());
}

void CCViewWindow::Create(int row, int col, int width, int height)
{
	CCTitledWindow::Create(row, col, width, height);
	CCViewWindow::Redraw();
}

void CCViewWindow::operator=(CStringArray &a)
{
	m_text=a;
	Redraw();
}

void CCViewWindow::operator=(CStringList &l)
{
CStringArray a;

	a.SetSize(l.GetCount());

POSITION p;
size_t	i=0;

	for (p=l.GetHeadPosition(); p; i++)
		a[i]=l.GetNext(p);
	operator=(a);
}

void CCViewWindow::Destroy()
{
	CCTitledWindow::Destroy();
}

void CCViewWindow::Redraw()
{
	if (m_cursorRow >= (size_t)m_text.GetSize())
	{
		m_cursorRow=m_text.GetSize();
		if (m_cursorRow)
			--m_cursorRow;
	}

	if ((size_t)m_text.GetSize() <= (size_t)Height())
		m_firstRow=0;
	if (m_cursorRow < m_firstRow)
		m_firstRow=m_cursorRow;
	if (m_firstRow + Height() <= m_cursorRow)
		m_firstRow=m_cursorRow-Height()+1;

size_t	i;
size_t	maxw=0;

	for (i=0; i<(size_t)Height(); i++)
	{
		if (i+m_firstRow < (size_t)m_text.GetSize())
		{
		size_t	w;

			w=m_text[i+m_firstRow].GetLength();
			if (w > maxw)
				maxw=w;
		}
	}

	if (maxw <= (size_t)Width())
		maxw=Width();

	if (m_firstCol + Width() > maxw)
		m_firstCol=maxw-Width();

CString	s;

	for (i=0; i<(size_t)Height(); i++)
	{
		s=(i+m_firstRow < (size_t)m_text.GetSize()
			? m_text[i+m_firstRow]:
				(CString)_T("")).Mid(m_firstCol);

		Write(i, 0, s + CString(' ', Width()), Width());
	}
	SetCursorPos(m_cursorRow - m_firstRow, 0);
	Refresh();
}

BOOL CCViewWindow::AcceptInput(int ch)
{
	switch (ch)	{
	case ESCKEY:
	case '\r':
	case '\n':
		Destroy();
		return (TRUE);
	case KEY_RIGHT:
		++m_firstCol;
		CCViewWindow::Redraw();
		return (TRUE);
	case KEY_LEFT:
		if (m_firstCol > 0)
			--m_firstCol;
		CCViewWindow::Redraw();
		return (TRUE);
	case KEY_PPAGE:
		if (m_cursorRow < (size_t)Height())
			m_cursorRow=0;
		else
			m_cursorRow -= Height();
		CCViewWindow::Redraw();
		return (TRUE);
	case KEY_UP:
		if (m_cursorRow > 0)	--m_cursorRow;
		CCViewWindow::Redraw();
		return (TRUE);
	case KEY_NPAGE:
		if (m_text.GetSize() - m_cursorRow <= (size_t)Height())
		{
			m_cursorRow=m_text.GetSize();
			if (m_cursorRow)	--m_cursorRow;
		}
		else
			m_cursorRow += Height();

		CCViewWindow::Redraw();
		return (TRUE);
	case KEY_DOWN:
		if (m_cursorRow + 1 < (size_t)m_text.GetSize())
			++m_cursorRow;
		CCViewWindow::Redraw();
		return (TRUE);
	}
	return (TRUE);
}
