// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"afxwindow.h"

static const char rcsid[]="$Id: afxwindow3.C,v 1.3 1998/06/11 04:32:37 mrsam Exp $";

CCMenuBarWindow:: CCMenuBarWindow(CCWindow *main)
	: m_mainWindow(main), m_prevWindow(0)
{
	m_menuBarList.SetHorizontal();
	m_menuBarList.DoSelects(FALSE);
	m_menuBarList.m_menuBar=this;
}

CCMenuBarWindow::~CCMenuBarWindow()
{
}

void	CCMenuBarWindow::Create()
{
int	w=m_mainWindow->Width();

	w= w>2 ? w-2:0;

	CCTitledWindow::Create(1, 1, w, 1);
	m_menuBarList.Create(Row(), Col(), Width(), Height());
}

void	CCMenuBarWindow::Destroy()
{
	CCTitledWindow::Destroy();
}

void	CCMenuBarWindow::SetInput()
{
// When we regain input, we close any popups, and move input focus
// to the list window.

POSITION p;

	for (p=m_popUps.GetHeadPosition(); p; )
		m_popUps.GetNext(p)->Destroy();

	MoveToFront();
	m_menuBarList.SetInput();
}

void	CCMenuBarWindow::Add(CString str, CCMenuPopupWindow *wptr)
{
	m_popUps.AddTail(wptr);
	try
	{
		m_menuBarList.m_listStrings.Add(str);
	}
	catch (...)
	{
		m_popUps.RemoveTail();
	}
}

BOOL	CCMenuBarWindow::MenuInput()
{
POSITION p;

	if (m_menuBarList.HasInput())
		return (TRUE);

	for (p=m_popUps.GetHeadPosition(); p; )
	{
	CCMenuPopupWindow *w=m_popUps.GetNext(p);

		if (w->MenuInput())	return (TRUE);
	}
	return (FALSE);
}

BOOL	CCMenuBarWindow::AcceptInputNonFocus(int ch)
{
	if (m_window && ch == ESCKEY && MenuInput())
		ch=MENUKEY;		// ESC turns off menu mode

	if (m_window && ch == MENUKEY)	// CTRL-O
	{
		if (!MenuInput())
		{
			m_prevWindow=CurrentInputWindow;
			m_menuBarList.MoveTo(0);
			m_menuBarList.AlwaysSelected(TRUE);
			SetInput();
			return (TRUE);
		}

		MenuOff();
		return (TRUE);
	}

	if (MenuInput())
		return (TRUE);	// Process all other keys when active

	return (CCTitledWindow::AcceptInputNonFocus(ch));
}

void CCMenuBarWindow::MenuOff()
{
	if (MenuInput())
	{
	POSITION p;

		for (p=m_popUps.GetHeadPosition(); p; )
			m_popUps.GetNext(p)->Destroy();

		m_menuBarList.AlwaysSelected(FALSE);
		m_prevWindow->SetInput();
	}
}

void CCMenuBarWindow::Selected(size_t ndx)
{

// Create popup window so that the title goes right over the label!

int	row=m_menuBarList.m_stringRow[ndx];
int	col=m_menuBarList.m_stringCol[ndx];

POSITION p=m_popUps.FindIndex(ndx);
CCMenuPopupWindow *w=m_popUps.GetNext(p);

	w->Title(m_menuBarList.m_listStrings[ndx]);
	w->Create(row+1, col, this);
}

////////////////////////////////////////////////////////////////////////////

CCMenuPopupWindow::CCMenuPopupWindow() : m_pMenubar(NULL)
{
	m_menuList.m_menuPopup=this;
	m_menuList.DoSelects(FALSE);
}

CCMenuPopupWindow::~CCMenuPopupWindow()
{
}

void CCMenuPopupWindow::Create(int row, int col, CCMenuBarWindow *pMenubar)
{
size_t	maxWidth, w;
size_t	i,cnt=m_menuList.GetCount();

	m_pMenubar=pMenubar;
	maxWidth=0;
	for (i=0; i<cnt; i++)
	{
		w=m_menuList.RenderWidth(i);
		if (w > maxWidth)	maxWidth=w;
	}

	maxWidth += 3;

	CCTitledWindow::Create(row+1, col+1, maxWidth+2, cnt);
	try
	{
		m_menuList.Create(row+1, col+1, maxWidth, cnt);
		m_menuList.MoveTo(0);
	}
	catch (...)
	{
		CCTitledWindow::Destroy();
	}
}


void CCMenuPopupWindow::Destroy()
{
	m_menuList.Destroy();
	CCTitledWindow::Destroy();
}

size_t	CCMenuPopupWindow::CurrentItem()
{
	return (m_menuList.CurrentItem());
}

size_t CCMenuPopupWindow::Add(CString str, CCWindow *wptr)
{
	m_menuList.m_listStrings.Add(str);
	try
	{
		m_menuList.m_menuWindow.Add(wptr);
	}
	catch (...)
	{
		m_menuList.m_listStrings.RemoveAt(
			m_menuList.m_listStrings.GetSize()-1);
	}
	return (m_menuList.m_listStrings.GetSize()-1);
}

BOOL CCMenuPopupWindow::MenuInput()
{
	return (m_menuList.HasInput());
}

///////////////////////////////////////////////////////////////

BOOL CCMenuPopupWindowList::AcceptInput(int ch)
{
	if (m_menuPopup && m_menuPopup->m_pMenubar)
	{
		// Do not let this list class handle left/right keys

		if (ch == KEY_LEFT)
		{
			m_menuPopup->m_pMenubar->Left(TRUE);
			return (TRUE);
		}

		if (ch == KEY_RIGHT)
		{
			m_menuPopup->m_pMenubar->Right(TRUE);
			return (TRUE);
		}

		if ((ch == KEY_UP && CurrentItem() == 0)
			|| ch == ESCKEY)	// Close me
		{
			m_menuPopup->m_pMenubar->SetInput();
			return (TRUE);
		}
	}
	return ( CCTextListWindow::AcceptInput(ch));
}

void CCMenuPopupWindowList::Selected(size_t ndx)
{
CCWindow *w=m_menuWindow[ndx];

	m_menuPopup->m_pMenubar->MenuOff();
	if (w)	w->Create();
}
