// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"afxwindow.h"

static const char rcsid[]="$Id: afxwindow2.C,v 1.4 1998/06/17 04:12:30 mrsam Exp $";

///////////////////////////////////////////////////////////////////////////
//	The List Window

CCListWindow::CCListWindow() : m_firstRow(0), m_firstCol(0), m_cursorRow(0),
	m_alwaysSelected(FALSE), m_biggestWidth(0), m_listType(Vertical),
	m_doSelects(TRUE)
{
}

CCListWindow::CCListWindow(ListType type)
	: m_firstRow(0), m_firstCol(0), m_cursorRow(0),
	m_alwaysSelected(FALSE), m_listType(type), m_doSelects(TRUE)
{
}


CCListWindow::~CCListWindow()
{
}

void CCListWindow::Create(int row, int col, int width, int height)
{
	CCWindow::Create(row, col, width, height);
	CCListWindow::Redraw();
}

void CCListWindow::Destroy()
{
	CCWindow::Destroy();
}

size_t CCListWindow::GetCount()
{
	return (0);
}

void CCListWindow::Selected(size_t)
{
}

void CCListWindow::DeleteKey(size_t)
{
}

void CCListWindow::Render(size_t, size_t, int, int, int, BOOL, BOOL)
{
}

size_t CCListWindow::RenderWidth(size_t)
{
	return (0);
}

void CCListWindow::GetFocus()
{
	CCListWindow::Redraw();
}

void CCListWindow::KillFocus()
{
	CCListWindow::Redraw();
}

void CCListWindow::DoSelects(BOOL flag)
{
	m_doSelects=flag;

	if (!flag)
	{
	size_t n=m_selected.GetSize(), i;

		for (i=0; i<n; i++)
			m_selected[i]=FALSE;
	}
}

void CCListWindow::SizeSelected()
{
size_t	cnt=GetCount();
size_t	s_cnt=m_selected.GetSize();

	m_selected.SetSize(cnt);
	while (s_cnt < cnt)
		m_selected[s_cnt++]=FALSE;
}

void CCListWindow::Redraw()
{
	if (!m_window)	return;

	SizeSelected();

size_t	y, i;
int	x;
size_t	cnt=GetCount();
size_t	cntshown;

	if (cnt <= m_cursorRow)
		m_cursorRow = cnt ? cnt-1:0;
	if (m_cursorRow < m_firstRow)
		m_firstRow=m_cursorRow;

	if (Type() == Vertical)
	{
		m_biggestWidth=0;
		cntshown=ListShown();

		if (m_cursorRow >= m_firstRow + Height())
			m_firstRow = m_cursorRow - Height()+1;

		for (y=0; y<cntshown; y++)
		{
			if (y + m_firstRow >= cnt)
				continue;

		size_t	iw=RenderWidth(y+m_firstRow);

			if (iw > m_biggestWidth)
				m_biggestWidth=iw;
		}
		m_biggestWidth += WidthOverhead();

	size_t	w=Width();

		if (m_biggestWidth < w)
			m_firstCol=0;
		else if (m_firstCol > m_biggestWidth - w)
			m_firstCol=m_biggestWidth-w;
	}
	else	// Horizontal list
	{
		m_biggestWidth=0;
		for (y=m_firstRow; y<cnt; y++)
		{
		size_t w=RenderWidth(y) + WidthOverhead();

			while (w + m_biggestWidth > (size_t)Width() &&
				y <= m_cursorRow && m_firstRow < m_cursorRow)
				m_biggestWidth -= RenderWidth(m_firstRow++)
					+ WidthOverhead();
			if (w + m_biggestWidth > (size_t)Width())	break;
			m_biggestWidth += w;
		}

		cntshown=y-m_firstRow;
		if (cntshown == 0)	cntshown=1;
		m_firstCol=0;
	}

CString	blanks;

	memset(blanks.GetBuffer(Width()), ' ', Width());
	blanks.ReleaseBuffer(Width());

	if (Type() != Vertical)
		Write(0, 0, blanks, Width());

	x=0;
	for (i=0; i<cntshown; i++)
	{
		if (Type() == Vertical)
			y=i;
		else
			y=0;

		if (i + m_firstRow >= cnt)
		{
			if (cnt == 0 && i == 0)
				SetCursorPos(y, x);
			if (Type() == Vertical)
				Write(y, 0, blanks, Width());
			continue;
		}

		Write(y, x, m_selected[m_firstRow+i] ? ACS_DIAMOND:' ');
		if (i + m_firstRow == m_cursorRow)
			SetCursorPos(y, x);

	int	w;

		if (Type() == Vertical)	w=Width()-WidthOverhead();
		else
		{
			w=RenderWidth(i);
			if ( Width() - (x+1) < w)
				w=Width()-(x+1);
		}


		Render(i+m_firstRow, m_firstCol, y, x+1, w,
			m_selected[m_firstRow+i],
			(HasInput() || m_alwaysSelected)
				&& i + m_firstRow == m_cursorRow);
		if (Type() != Vertical)
			x += w + WidthOverhead();
	}
	Refresh();
}

BOOL	CCListWindow::IsSelected(size_t ndx)
{
	return ((size_t)ndx < (size_t)m_selected.GetSize() ?
			m_selected[ndx]:FALSE);
}

void	CCListWindow::IsSelected(size_t ndx, BOOL flag)
{
	SizeSelected();
	if ((size_t)ndx < (size_t)m_selected.GetSize())
	{
		m_selected[ndx]=flag;
		CCListWindow::Redraw();
	}
}

void CCListWindow::Reset()
{
	m_cursorRow=0;
	m_firstRow=0;
	CCListWindow::Redraw();
	SizeSelected();
}

BOOL CCListWindow::AcceptInput(int theChar)
{
	if (Type() != Vertical)
		switch (theChar)	{
		case KEY_RIGHT:
		case KEY_NPAGE:
			theChar=KEY_DOWN;
			break;
		case KEY_LEFT:
		case KEY_PPAGE:
			theChar=KEY_UP;
			break;
		}

	switch (theChar)	{
	case KEY_LEFT:
		if (m_firstCol > 0)
		{
			--m_firstCol;
			CCListWindow::Redraw();
		}
		return (TRUE);
	case KEY_RIGHT:
		++m_firstCol;
		CCListWindow::Redraw();
		return (TRUE);
	case KEY_PPAGE:
		if (m_cursorRow < (size_t)Height())
			m_cursorRow=0;
		else
			m_cursorRow -= Height();
		while (m_cursorRow + 1 < GetCount() && IsSeparator(m_cursorRow))
			++m_cursorRow;
		CCListWindow::Redraw();
		return (TRUE);
	case KEY_UP:
		while (m_cursorRow > 0 && IsSeparator(--m_cursorRow))
			;
		CCListWindow::Redraw();
		return (TRUE);
	case KEY_NPAGE:
		if (GetCount() - m_cursorRow <= (size_t)Height())
		{
			m_cursorRow=GetCount();
			if (m_cursorRow)	--m_cursorRow;
		}
		else
		{
			m_cursorRow += Height();
			while (m_cursorRow > 0 && IsSeparator(m_cursorRow))
				--m_cursorRow;
		}
		CCListWindow::Redraw();
		return (TRUE);
	case KEY_DOWN:
		while (m_cursorRow + 1 < GetCount() &&
			IsSeparator(++m_cursorRow))
			;
		CCListWindow::Redraw();
		return (TRUE);
	case KEY_ENTER:
	case '\n':
	case '\r':
		if (m_cursorRow < GetCount())
			Selected(m_cursorRow);
		return (TRUE);
	case ' ':
		if (m_cursorRow < GetCount())
		{
			if (DoSelects())
			{
				m_selected[m_cursorRow]=
					!m_selected[m_cursorRow];
				CCListWindow::Redraw();
			}
			else
				Selected(m_cursorRow);
		}
		return (TRUE);
	case 0x7F:
		if (m_cursorRow < GetCount())
			DeleteKey(m_cursorRow);
		return (TRUE);
	}

	if (theChar >= ' ')	return (TRUE);

	return (this->CCWindow::AcceptInput(theChar));
}

BOOL CCListWindow::IsSeparator(size_t)
{
	return (FALSE);
}

//////////////////////////////////////////////////////////////////////////
//
//  CCListButtonWindow

void CCListButtonWindow :: Selected(size_t i)
{
size_t n=m_radioButtons.GetSize();
size_t j;

	for (j=0; j<n; j++)
		if (m_radioButtons[j] == i)
		{
			SelectedButton(j);
			return;
		}
	SelectedNonButton(i);
}

void	CCListButtonWindow::SelectedButton(size_t)
{
}

void	CCListButtonWindow::SelectedNonButton(size_t)
{
}

void	CCListButtonWindow::IsSelected(size_t n, BOOL flag)
{
	if (n < (size_t)m_radioButtons.GetSize() && m_plist)
		m_plist->IsSelected(m_radioButtons[n], flag);
}

void	CCListButtonWindow::Create()
{
	if (m_plist)
		Selected(m_plist->CurrentItem());
}

//////////////////////////////////////////////////////////////////////////
//
//	CCTextListWindow

CCTextListWindow::CCTextListWindow()
{
}

CCTextListWindow::~CCTextListWindow()
{
}

void CCTextListWindow::Create(int row, int col, int width, int height)
{
	CCListWindow::Create(row, col, width, height);
}

void CCTextListWindow::Destroy()
{
	CCListWindow::Destroy();
}

size_t CCTextListWindow::GetCount()
{
	return (m_listStrings.GetSize());
}

size_t CCTextListWindow::RenderWidth(size_t ndx)
{
	return (m_listStrings[ndx].GetLength());
}

BOOL CCTextListWindow::IsSeparator(size_t ndx)
{
	return (m_listStrings[ndx] == _T(""));
}

void CCTextListWindow::Render(size_t ndx, size_t off,
	int row, int col, int cnt, BOOL, BOOL hascursor)
{
CString	s;

	if (IsSeparator(ndx))
		s=CString('-', cnt);
	else
		s=m_listStrings[ndx].Mid(off);

int	l=s.GetLength();

	if (l < cnt)
	{
		memset(s.GetBuffer(cnt)+l, ' ', cnt-l);
		s.ReleaseBuffer(cnt);
	}

	if (hascursor)
		WriteAttrOn(A_REVERSE);

	Write(row, col, s, cnt);
	if (hascursor)
		WriteAttrOff(A_REVERSE);

	// Save row/column where we last drew this string.

	m_stringRow.SetSize(GetCount());
	m_stringCol.SetSize(GetCount());
	m_stringRow[ndx]=row;
	m_stringCol[ndx]=col;
}
