// DSTART
//                  sFTP - a curses-based FTP client for Linux.
// 
//                            Current version is 0.81
// 
//                  Copyright 1997-1998, Double Precision, Inc.
// 
// This program is distributed under the terms of the GNU General Public
// License. See COPYING for additional information.
// DEND
#if HAVE_CONFIG_H
#include	"autoconfig.h"
#endif
#include	"afxwindow.h"
#include	"config.h"
#include	<signal.h>
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<termios.h>
#include	<stdlib.h>
#include	<sys/types.h>
#if HAVE_SYS_WAIT_H
#include	<sys/wait.h>
#endif
#ifndef WEXITSTATUS
#define WEXITSTATUS(stat_val)	((unsigned)(stat_val)>>8)
#endif
#ifndef WIFEXITED
#define WIFEXITED(stat_val)	(((unsigned)(stat_val) & 255)) == 0)
#endif

#if HAVE_SYS_IOCTL_H
#include	<sys/ioctl.h>
#endif

static const char rcsid[]="$Id: afxwindow.C,v 1.5 1998/06/11 04:32:37 mrsam Exp $";

BOOL	CCWindow::FlushedFlag;
CList<CCWindow *, CCWindow *> CCWindow::AllWindowList;
//static	CList< CList<CCWindow *, CCWindow *>, CList<CCWindow *, CCWindow *> &>
//					InputWindowListStack;
CCBaseWindow * CCWindow::BaseWindow=NULL;
CCWindow *CCWindow::CurrentInputWindow=NULL;

CCWindow::CCWindow() :
	m_row(0), m_col(0), m_width(0), m_height(0),
	m_cursrow(0), m_curscol(0), m_window(NULL), m_listPos(0)
{
}

CCWindow::~CCWindow()
{
	Destroy();
}

BOOL CCWindow::IsBaseWindow()
{
	return (FALSE);
}

void CCWindow::Create(int width, int height)
{
	Destroy();

	if (!BaseWindow)
		AfxThrowInternalException();	// Base window not defined!

	if (!BaseWindow->m_window)
		BaseWindow->Create(0, 0, 0, 0);

int	sWidth=BaseWindow->Width();
int	sHeight=BaseWindow->Height();

	Create( sHeight < height ? 0 : (sHeight - height)/2,
		sWidth < width ? 0 : (sWidth - width)/2,
		width, height);
}

void CCWindow::Create()	// Provide a default one
{
	Destroy();

	if (!BaseWindow)
		AfxThrowInternalException();	// Base window not defined!

	if (!BaseWindow->m_window)
		BaseWindow->Create(0, 0, 0, 0);

	Create(0, 0, BaseWindow->Width(), BaseWindow->Height());
}

BOOL CCWindow::Validate()	// Default validation function
{
	return (TRUE);
}

void CCWindow::Create(int row, int col, int width, int height)
{
	CCWindow::Destroy();

	if (!BaseWindow)
		AfxThrowInternalException();	// Base window not defined!

	if (!BaseWindow->m_window)
		BaseWindow->Create(0, 0, 0, 0);
		// Initialize curses on behalf of lazy programmers

	FlushedFlag=FALSE;
	if (height < 1)	height=1;
	if (width < 1)	width=1;

	if (width >= BaseWindow->Width())
	{
		col=0;
		width=BaseWindow->Width();
	}
	else if (col > BaseWindow->Width()-width)
		col=BaseWindow->Width()-width;

	if (height >= BaseWindow->Height())
	{
		row=0;
		height=BaseWindow->Height();
	}
	else if (row > BaseWindow->Height()-height)
		row=BaseWindow->Height()-height;

	if (!(m_window=newpad(height, width)))
		AfxThrowMemoryException();

	try
	{
		m_row=row;
		m_col=col;
		m_width=width;
		m_height=height;
		m_cursrow=0;
		m_curscol=0;

		leaveok(m_window, FALSE);
		keypad(m_window, TRUE);
		m_listPos=AllWindowList.AddHead( this );
	}
	catch (...)
	{
		delwin(m_window);
		m_window=NULL;
		throw;
	}
}

void	CCWindow::SetInput()
{
	if (CurrentInputWindow)
	{
	CCWindow	*w=CurrentInputWindow;

		CurrentInputWindow=NULL;
		w->KillFocus();
	}
	if (!CurrentInputWindow)
		CurrentInputWindow=this;
	GetFocus();
	MoveToFront();
}

void	CCWindow::Destroy()
{
	if (CurrentInputWindow)
	{
	CCWindow	*w=CurrentInputWindow;

		CurrentInputWindow=NULL;
		w->KillFocus();
	}

	if (!m_window)	return;
	werase(m_window);
	if (!IsBaseWindow())
		refreshpad();
	delwin(m_window);
	m_window=NULL;

	AllWindowList.RemoveAt( m_listPos );
	BaseWindow->Refresh();
}

void	CCWindow::refreshpad()
{
int	pminrow=0, pmincol=0, sminrow=m_row, smincol=m_col;
int	smaxrow=m_row+m_height, smaxcol=m_col+m_width;
int	w=BaseWindow->Width(), h=BaseWindow->Height();

	if (sminrow >= h || smincol >= w)	return;
	if (smaxrow <= 0 || smaxcol <= 0)	return;
	if (sminrow < 0)
	{
		pminrow -= sminrow;
		sminrow=0;
	}
	if (smincol < 0)
	{
		pmincol -= smincol;
		smincol=0;
	}
	if (smaxrow > h)	smaxrow=h;
	if (smaxcol > w)	smaxcol=w;
	pnoutrefresh(m_window, pminrow, pmincol, sminrow, smincol,
		smaxrow-1, smaxcol-1);
}
//	Change contents

void	CCWindow::WriteAttrOn(int attrs)
{
	if (m_window)
		wattron(m_window, attrs);
}

void	CCWindow::WriteAttrOff(int attrs)
{
	if (m_window)
		wattroff(m_window, attrs);
}

void	CCWindow::Write(int row, int col, LPCTSTR str, int cnt)
{
	if (!m_window || cnt <= 0 || row < 0 || row >= Height() ||
		col >= Width() || col + cnt < 0)	return;

	if (col < 0)
	{
		cnt += col;
		str -= col;
		col=0;
	}

	wmove(m_window, row, col);
	waddnstr(m_window, str, cnt);
}

void	CCWindow::Write(int row, int col, int theChar)
{
	if (row >= 0 && row < Height() && col >= 0 && col < Width())
	{
		wmove(m_window, row, col);
		waddch(m_window, theChar);
	}
}

void	CCWindow::Redraw()
{
	if (m_window)	werase(m_window);
	Refresh();
}

//	Refresh this window, all all windows up the stack.

void	CCWindow::Refresh()
{
	if (!m_window)	return;

	wmove(m_window, m_cursrow, m_curscol);
	if (!IsBaseWindow())	// Base window is not a pad
		refreshpad();

POSITION p=m_listPos;

	(void)AllWindowList.GetPrev(p);

CCWindow *wp;

	while (p)
	{
		wp=AllWindowList.GetPrev(p);
			wp->refreshpad();
	}
	FlushedFlag=FALSE;
}

int	CCWindow::Width()
{
	return (m_width);
}

int	CCWindow::Height()
{
	return (m_height);
}

int	CCWindow::Row()
{
	return (m_row);
}

int	CCWindow::Col()
{
	return (m_col);
}

BOOL	CCWindow::AcceptInput(int ch)
{
	if (ch == REFRESHKEY)
	{
		endwin();
		doupdate();
	}
	return (FALSE);
}

BOOL	CCWindow::AcceptInputNonFocus(int)
{
	return (FALSE);
}

void	CCWindow::GetFocus()
{
}

void	CCWindow::KillFocus()
{
}

// Put this window in front of another window on window stack.

void	CCWindow::MoveInFrontOf(CCWindow *other_win)
{
	if (!BaseWindow)	AfxThrowInternalException();

	if (!m_window || !other_win->m_window)	AfxThrowInternalException();

POSITION my_pos=m_listPos;
POSITION its_pos=other_win->m_listPos;

POSITION new_pos=AllWindowList.InsertBefore(its_pos, this);
	AllWindowList.RemoveAt(my_pos);
	m_listPos=new_pos;
	BaseWindow->Refresh();
}

// Put this window behind another window on window stack.

void	CCWindow::MoveBehindOf(CCWindow *other_win)
{
	if (!BaseWindow)	AfxThrowInternalException();

	if (!m_window || !other_win->m_window)	AfxThrowInternalException();

POSITION my_pos=m_listPos;
POSITION its_pos=other_win->m_listPos;

POSITION new_pos=AllWindowList.InsertAfter(its_pos, this);
	AllWindowList.RemoveAt(my_pos);
	m_listPos=new_pos;
	BaseWindow->Refresh();
}

BOOL	CCWindow::QuitWindowsFlag;

void	CCWindow::InputLoop()
{
	while (!QuitWindowsFlag)
	{
	CCWindow	*w;
	int		ch;

		GetInput(ch, w);
		ProcessInput(ch, w);
	}
}

void	CCWindow::ProcessInput(int ch, CCWindow *w)
{
	FlushedFlag=FALSE;
	if (w && w->AcceptInput(ch))
		return;

POSITION	p;

	for (p=AllWindowList.GetHeadPosition(); p; )
		if (AllWindowList.GetNext(p)->AcceptInputNonFocus(ch))
			break;
}

void	CCWindow::Flush()
{
	if (FlushedFlag)	return;

	if (!CurrentInputWindow || !CurrentInputWindow->m_window)
	{
//	Find another window to get input

	POSITION	p;
	CCWindow	*wp=NULL;

		for (p=AllWindowList.GetHeadPosition(); p; )
		{
			if ((wp=AllWindowList.GetNext(p)) != NULL
				&& wp->m_window)
					break;
			wp=NULL;
		}

		if (wp)
			wp->SetInput();
	}

	if (CurrentInputWindow)
		CurrentInputWindow->MoveToFront();
	doupdate();
	FlushedFlag=TRUE;
}

void	CCWindow::GetInput(int &ch, CCWindow *&w)
{
	Flush();
	w=CurrentInputWindow;
	if (!w)
		ch=getch();
	else
		ch=wgetch(w->m_window);
}

void	CCWindow::MoveToFront()
{
	if (!BaseWindow)	AfxThrowInternalException();

	if (!m_window)	return;

POSITION	my_pos=m_listPos;
POSITION	p=my_pos;

	(void)AllWindowList.GetPrev(p);
	if (p == NULL)	// We are already at the front
		return;
	m_listPos=AllWindowList.AddHead(this);
	AllWindowList.RemoveAt(my_pos);
	Refresh();
}

void CCWindow::Resize(int nrows, int ncols)
{
	if (!m_window)	return;
	if (nrows <= 0 || ncols <= 0)	return;

	if (!IsBaseWindow())
	{
	WINDOW *npad=newpad(nrows, ncols);

		if (!npad)	AfxThrowMemoryException();
		delwin(m_window);
		m_window=npad;
	}
	m_width=ncols;
	m_height=nrows;
	Resized();
}

void CCWindow::Resized()
{
	Redraw();
}

void	CCWindow::QuitWindows()
{
	QuitWindowsFlag=TRUE;
}

//////////////////////////////////////////////////////////////////////////
//	The base window.
//	Creation of base window initializes curses.
//	Destruction of base window shuts down curses.

BOOL CCBaseWindowSUSPEND::use_subshell=FALSE;

void CCBaseWindowSUSPEND::UseSubshell()
{
	use_subshell=TRUE;
}

void CCBaseWindowSUSPEND::Signal()
{
	if (!isendwin())
	{
		endwin();
		cout << VERSION << " suspended" << endl << flush;
		suspend();
		doupdate();
	}
	else
		suspend();
}

void CCBaseWindowSUSPEND::suspend()
{
	if (!use_subshell)
	{
		kill(getpid(), SIGSTOP);
		return;
	}

pid_t	pid=fork();

	if (pid == -1)
	{
		cerr << "Unable to fork.\n";
		return;
	}
	if (pid == 0)
	{
	const char *p;

		CIoh::Forked();
		p=getenv("SHELL");
		if (!p || !*p)	p="/bin/sh";
		execl(p, p, NULL);
		exit(1);
	}

pid_t	rc;

	while ((rc=wait(NULL)) != pid)
		;
}

CCBaseWindowSUSPEND::CCBaseWindowSUSPEND() : CSigIoh(SIGTSTP)
{
}

void CCBaseWindowTERMINATE::Signal()
{
	CCWindow::QuitWindows();
}

CCBaseWindow::CCBaseWindow()
	: m_sigint(SIGINT), m_sigterm(SIGTERM), m_sighup(SIGHUP)
{
	if (BaseWindow)
		AfxThrowInternalException();

	BaseWindow=this;
}

CCBaseWindow::~CCBaseWindow()
{
	Destroy();
	BaseWindow=NULL;
}

BOOL	CCBaseWindow::IsBaseWindow()
{
	return (TRUE);
}

void CCBaseWindow::Create()
{
	CCBaseWindow::Create(0, 0, 0, 0);
}

void	CCBaseWindow::Create(int, int, int, int)
{
	if (m_window)	return;

	m_listPos=AllWindowList.AddHead( this );

	initscr();
	cbreak();
	noecho();
	nonl();
	intrflush(stdscr, FALSE);
	keypad(stdscr, TRUE);
	scrollok(stdscr, FALSE);
	getmaxyx(stdscr, m_height, m_width);
	leaveok(stdscr, FALSE);
	m_row=0;
	m_col=0;
	m_window=stdscr;
	CurrentInputWindow=NULL;
	fd(0);
	QuitWindowsFlag=FALSE;
}

void	CCBaseWindow::Destroy()
{
	if (!m_window)	return;

	for (;;)
	{
	POSITION p=AllWindowList.GetHeadPosition();
	CCWindow *wp=NULL;

		while (p)
		{
			wp=AllWindowList.GetNext(p);
			if (!wp->IsBaseWindow())	// Prevent loops!
				break;
			wp=NULL;
		}
		if (!wp)	break;
		wp->Destroy();
	}

	endwin();
	m_window=NULL;
}

//	Refresh of base window clears stdscr, then calls the standard refresh logic.

void CCBaseWindow::Refresh()
{
	if (m_window)
	{
//		touchwin(m_window);
//		werase(m_window);
		wrefresh(m_window);
	}
	this->CCWindow::Refresh();
}

//	Two ways to run the show:
//
//	1)  Call CCWindow::InputLoop
//
//	2)  Use CIoh classes.  Implement CanRead() and Read() in this case.

BOOL	CCBaseWindow::CanRead()
{
	if (QuitWindowsFlag)	return (FALSE);
	Flush();
	return (TRUE);
}

void	CCBaseWindow::Read()
{
int	ch;
CCWindow *w;

	GetInput(ch, w);
	ProcessInput(ch, w);
}

///////////////////////////////////////////////////////////
//
//  Window with a border and a title

CCTitledWindow::CCTitledWindow()
{
}

CCTitledWindow::CCTitledWindow(CString title) : m_title(title)
{
}

CCTitledWindow::~CCTitledWindow()
{
}

void CCTitledWindow::Create(int row, int col, int width, int height)
{
	m_title_window.Create(row-1, col-1, width+2, height+2);

	// We might've been repositioned, reset coordinates

	row=m_title_window.Row()+1;
	col=m_title_window.Col()+1;
	width=m_title_window.Width();
	height=m_title_window.Height();
	width=width <= 2 ? 1:width-2;
	height=height <= 2 ? 1:height-2;

	CCWindow::Create(row, col, width, height);
	MoveInFrontOf(&m_title_window);
	CCTitledWindow::Redraw();
	m_title_window.Refresh();
}

void CCTitledWindow::Destroy()
{
	CCWindow::Destroy();
	m_title_window.Destroy();
}

void CCTitledWindow::Redraw()
{
const int	&w=m_title_window.m_width;
const int	&h=m_title_window.m_height;
int	y,x;

	if (!m_title_window.m_window)	return;

	for (y=0; y<h; y++)
	{
		wmove(m_title_window.m_window, y, 0);
		if (y == 0 || y == h-1)
			for (x=0; x<w; x++)
				waddch(m_title_window.m_window,
					(x == 0 ? y ? ACS_LLCORNER:ACS_ULCORNER
					:x == w-1 ?  y ? ACS_LRCORNER:ACS_URCORNER
					:ACS_HLINE));
		else
		{
			waddch(m_title_window.m_window, ACS_VLINE);
			wmove(m_title_window.m_window, y, w-1);
			waddch(m_title_window.m_window, ACS_VLINE);
		}
	}

int l=m_title.GetLength();

	if (l > w-2)
		l=w-2;
	if (l < 0)
		l=0;
	if (l)
		mvwaddnstr(m_title_window.m_window, 0, 1, (LPCTSTR)m_title, l);
}

///////////////////////////////////////////////////////////////////////////////
// SIGWINCH is handled internally

class CSigIohWinch : public CSigIoh {
public:
	CSigIohWinch();
	~CSigIohWinch();
	virtual void Signal();
} ;

static CSigIohWinch sig_winch;

CSigIohWinch::CSigIohWinch() : CSigIoh(SIGWINCH)
{
}

CSigIohWinch::~CSigIohWinch()
{
}

void CSigIohWinch::Signal()
{
struct winsize wsize;

	endwin();
	if (ioctl(1, TIOCGWINSZ, &wsize) == 0 &&
		CCWindow::BaseWindow)
	{
		CCWindow::BaseWindow->Resize(LINES, COLS);
	}
	doupdate();
}
