#! /usr/bin/perl
sub ver {print "
getls-lR  version 1.0 1999/09/05
(C) Ian Maclaine-cross 1999 (i.maclaine-cross\@unsw.edu.au)
You may use this only under the conditions of the
General Public Licence in file GPL.

";
exit;
}

sub use {print "Usage: getls-lR \[options\] SITE RPATH LPATH
Options:
	--help          this message
	--version       version
Logs into SITE anonymously or from ~/.netrc file.
FTPs RPATH.times then from this and file LPATH
decides whether to:
	do nothing as LPATH is up to date;
	FTP RPATH.patch.gz and patch LPATH;
	or FTP RPATH.gz and replace LPATH.
See: man mkls-lR; man Net::Netrc; README.ls-lR
";
	 exit;
}

($s, $r, $l)=@ARGV;
&ver if $s =~ /^--version$/;
&use if length $l == 0;

$lp="$l.patch";
$lpz="$lp.gz";
$lt="$l.times";

sub end {
	print "@_\n";
	$ftp->quit;
	exit;
}

use Net::Netrc;
use Net::FTP;
$h=`hostname -f`;
chop $h;
$ul=getpwuid($<);
$p="-$ul\@$h";
$u="anonymous";

if( $mach=Net::Netrc->lookup("$s") ){ 
	$u=$tu if $tu=$mach->login;
	$p=$tp if $tp=$mach->password;
}

$ftp = Net::FTP->new("$s") or &end( "$s did not respond" );
$ftp->login("$u","$p") or &end( "$s login failed" );
$ftp->binary();
$ftp->get( "$r.times", $lt ) or &end( "failed to get $lt" );
open FT, $lt;
($ot,$nt)=<FT>;
close FT;
unlink $lt;

$ft= -f $l?(stat($l))[9]:0;
if( $ft == $nt ){
	$g="$l up to date";
} elsif( $ft == $ot ){
	$ftp->get( "$r.patch.gz", $lpz ) or &end( "failed to get $lpz" );
	system( "gunzip -f $lpz" );
	system( "patch -usNZ $l $lp" );
	unlink $lp;
	$g="$l patched";
} else {
	$ftp->get( "$r.gz", "$l.gz" ) or &end( "failed to get $l.gz" );
	system( "gunzip -f $l.gz" );
	utime $nt, $nt, $l;
	$g="Got $r.gz for $l";
}
end( $g );
