
#ifndef	_FTPSYNC_INCLUDED_
#define	_FTPSYNC_INCLUDED_


#include "ftp.h"

extern char *program;
extern int debug;
extern int verbose;


#define	MODE_SYNC	0
#define	MODE_MASTER	1
#define	MODE_SLAVE	2
#define	MODE_MIRROR	3
#define	MODE_ORIGINAL	4


#define	FT_FILE		1
#define	FT_DIR		2


#define	ST_UNCHANGED	0
#define	ST_CHANGED	1
#define	ST_DELETED	2
#define	ST_NOSUCHFILE	3

#define	ST_CHAR		"ucdx"
#define	statchar(x)	(ST_CHAR[x])


#define	AC_ERROR	0
#define	AC_NOTHING	1
#define	AC_GET		2
#define	AC_PUT		3
#define	AC_DUPLICATE	4
#define	AC_REMOVE	5
#define	AC_IGNORE	6

#define	AC_CHAR		"ENGPDRI"
#define	actionchar(x)	(AC_CHAR[x])




typedef struct {
    int		exists;
    int		type;			/* FT_... */
    char	prev[80];
    char	current[80];
    int		status;
    } fileinfo_t;

typedef struct {
    int		code;
    char	filename[80];

    int		sync;
    int		action;
    fileinfo_t	info[2];		/* 0 = local node, 1 = peer */
    } file_t;

#define	nodeinfo	(info[0])	/* shortcut macros */
#define	peerinfo	(info[1])

typedef struct {
    char	infofile[2][80];

    int		listc, listmax;
    file_t	*list;

    unsigned long send, recv;
    } dir_t;


typedef struct {
    char	configfile[200];
    char	localdir[200];

    char	nodename[80];
    char	peername[80];

    char	dir[200];
    int		allowblanks;
    int		createdirs;
    int		dotfiles;
    int		forceupdate;
    int		printonly;
    int		recurse;
    int		syncmode;
    int		symsync;

    int		modeid;
    int		synctab[4][4];

    ftp_t	*server;
    } sync_t;



extern int readprevinfo(sync_t *s, dir_t *dir, int index);
extern int writeinfo(sync_t *s, dir_t *dir, int index);
extern int getnodeinfo(sync_t *s, dir_t *dir);
extern int computestatus(sync_t *s, dir_t *dir, int index);

extern int syncdir(sync_t *s, char *basedir, char *dirname);

#endif

