
/*

    File: ftp.h

    Copyright (C) 2000,2003  Wolfgang Zekoll  <wzk@happy-ent.de>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */


#ifndef	_FTP_INCLUDED
#define	_FTP_INCLUDED


extern char *program;
extern char progname[80];

extern int debug;

#define	MAXBSIZE	4096

typedef struct _ftp {
    char	server[200];
    unsigned int port;
    char	username[200];
    char	password[200];

    int		control;
    int		timeout;

    int		ascii;
    int		bsize;

    int		usepassive;
    struct {
	char	ipnum[40];
	unsigned int port;
	} pasv;

    struct {
	char		interface[80];
	unsigned int	port;

	int		fd;
	} data;
    } ftp_t;


extern int read_netrc(char *hostname, char *username, int usize,
					char *password, int psize);

extern unsigned get_interface_info(int pfd, char *ip, int max);
extern int waitfd(ftp_t *x, int fd, int write, int timeout);
extern int getc_fd(ftp_t *x, int fd);
extern char *readline_fd(ftp_t *x, int fd, char *line, int size);

extern char *sfgets(ftp_t *x, char *line, int size);
extern int sfputs(ftp_t *x, char *format, ...);
extern int sfputc(ftp_t *x, char *command, char *parameter, char *line, int size, char **here);

extern int dotype(ftp_t *x, char *type);
extern int doport(ftp_t *x);
extern int connect_server(ftp_t *x);
extern int doretr(ftp_t *x, char *remote, char *local);
extern int dostor(ftp_t *x, char *remote, char *local);
extern int domkdir(ftp_t *x, char *dirname);
extern int dormdir(ftp_t *x, char *dirname);
extern int dorename(ftp_t *x, char *rnfr, char *rnto);
extern int dosize(ftp_t *x, char *filename, char *buffer, int size);
extern int domdtm(ftp_t *x, char *filename, char *buffer, int size);
extern int dopwd(ftp_t *x, char *buffer, int size);
extern int docwd(ftp_t *x, char *dir, int create, int pe);
extern int docheckdir(ftp_t *x, char *dir);
extern int dodele(ftp_t *x, char *filename, int pe);
extern int doquit(ftp_t *x);
extern int dolist(ftp_t *x, int nlist, char *par, char **buffer, int *size);
extern int dologin(ftp_t *x);

extern int ftp_request(ftp_t *x);

#endif

