    /*********************************************************************\
    *  Copyright (c) 1991 by Wen-King Su (wen-king@vlsi.cs.caltech.edu)   *
    *  Copyright (c) 1993 by Phil Richards (pgr@prg.ox.ac.uk)             *
    *                                                                     *
    *  You may copy or modify this file in any manner you wish, provided  *
    *  that this notice is always included, and that you hold the author  *
    *  harmless for any loss or damage resulting from the installation or *
    *  use of this software.                                              *
    \*********************************************************************/

/* ---INFOBEGIN--- *  DO NOT DELETE THIS COMMENT BLOCK!!!
COMMAND cat remote "cat the contents of remote files"
 *  ---INFOEND---  */

#include "client.h"
#include "table.h"
#include <setjmp.h>
#include <stdlib.h>

#define FSPENVVAR "FSPFILE"

static int recursive;
static int use_pager;

static jmp_buf my_sigpipe_env;
static int longjmp_set, pipe_broken;

static RETSIGTYPE
dont_die(int sig)
{
    pipe_broken = 1;
    client_intr_cnt++;

    if (longjmp_set)
	longjmp(my_sigpipe_env, 0);
}

static int
cat_file(char *name, struct stat *sbufp, int depth)
{
    int retval;
    FILE *catout;
    RETSIGTYPE (*oldsig)(int);

    if (sbufp->st_size == 0)
    {
	ffprintf(STDOUT, "nothing to download for `%s'\n", name);
	return 0;
    }

    if (!validate_operation(name, UTIL_DOWNLOAD))
	return -1;

    longjmp_set = 0;
    pipe_broken = 0;
    oldsig = signal(SIGPIPE, dont_die);

    if (use_pager)
    {
	unsigned int l1, l2;
	static char *oldenv = 0;
	char *newenv;

	l1 = strlen(FSPENVVAR);
	l2 = strlen(name);

	newenv = (char *)malloc(l1 + l2 + 2);
	(void)strcpy(newenv, FSPENVVAR);
	newenv[l1] = '=';
	(void)strcpy(newenv + l1 + 1, name);
	newenv[l1 + l2 + 1] = '\0';

	(void)putenv(newenv);

	if (oldenv)
	    (void)free(oldenv);
	oldenv = newenv;

	catout = popen(pager_command, "w");
	if (catout == (FILE*)0)
	{
	    use_pager = 0;
	    ffprintf(STDERR, "?cat: cannot open pipe to command `%s'\n",
		     pager_command);
	    catout = STDOUT;
	}
    }
    else
	catout = STDOUT;

    retval = 0;

    if (pipe_broken)
	client_intr_cnt--;
    else
    {
	if (!setjmp(my_sigpipe_env))
	{
	    int bytes;
	    longjmp_set = 1;

	    bytes = util_download(name, fileno(catout), 0, sbufp->st_size);
	    if (bytes < 0)
		retval = 1;
	    else
		ffprintf(STDINFO, "downloaded %d bytes out of %d\n",
			 bytes, sbufp->st_size);
	}
	else
	    client_intr_cnt--;
    }

    if (use_pager)
	(void)pclose(catout);

    (void)signal(SIGPIPE, SIG_DFL);

    return retval;
}

static int
do_cat_file(char *name)
{
    if (!validate_operation(name, UTIL_PROCESS_FILE))
	return -1;

    return util_process_file(name, recursive, 0, cat_file, 0, 0);
}

/* ARGSUSED */
int
rcat_main(int argc, char *const*argv, char **envp)
{
    int retval, errcnt, ch;
    int client_trace_preserve = client_trace;

    recursive = 0;

    optind = 0;
    opterr = 0;
    errcnt = 0;
#ifdef HAVE_OPTRESET
    optreset = 1;
    optind = 1;
#endif        

    while ((ch = getopt(argc, argv, "r")) != EOF)
        switch (ch)
        {
          case 'r':
            recursive = MAXRECURSION;
            break;
          default:
            errcnt++;
            break;
        }

    if (errcnt > 0)
        return 1;

    if (isatty(fileno(STDOUT)))
    {
	client_trace = 0;
	use_pager = (pager_command && *pager_command);
    }
    else
	use_pager = 0;

    retval = -util_process_arglist(argv + optind, do_cat_file);

    client_trace = client_trace_preserve;
    client_done();

    return retval;
}
