import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;

/**
 * This is core class for download machine downloading engine. It itself
 * supports HTTP downloads and redirects downloads for other protocols into
 * protocol specific factories.
 *
 * @author Radim Kolar
 */
public abstract class downloadfactory
{

	// protected data = file information
	/** last-modified timestamp for downloaded file */
	protected long  lastModified;
	/** total size of downloaded file */
	protected long  fileSize;    /* total size of file */
	/** size of data which is server sending, might be less than fileSize because
	 * we are resuming transfer. 0 if unknown */
	protected long  contentSize;
	/** return code downloadcore.DOWNLOAD_XX */
	protected byte  rc;
	/** how many bytes of file we already have */
	protected long  havebytes;
	/** URL of downloaded data */
	protected URL   url;
	/** qfile of downloaded data */
	protected qfile qf;
	/** direct (noproxy) connection flag */
	protected boolean direct;

	/* master connection DATA streams */
	protected DataInputStream datain;
	protected DataOutputStream dataout;

	/**
	 * This is constuctor for download engine itself. It is intended for subclassing.
	 *
	 * @param URL URL to be downloaded
	 * @param qf Qeueue file to be downloaded
	 * @param dirc direct (no proxy) connection.
	 * @throws java.net.MalformedURLException
	 */
	downloadfactory(String URL,qfile qf,boolean dirc) throws java.net.MalformedURLException
	{
		this.direct=dirc;
		this.qf=qf;
		this.url=new URL(URL);
		this.havebytes=new File(dmachine.tmp_dir,qf.getLocalName()).length();
	}

	/** This procedure must modify protected variables as result.
	    prepares data connection for download. */
	abstract void processRequest(InetAddress server,int port,boolean nocache) throws IOException,java.net.MalformedURLException;


	/* close connection to server */
	/* Download factory should override this if needed */
	protected synchronized void close()
	{
		if(datain!=null)
			try
		{
				datain.close();
		}
		catch (IOException ignore) {}

		if(dataout!=null)
			try
		{
				dataout.close();
		}
		catch (IOException ignore) {}
		dataout=null;
		datain=null;
	}

}  /* class */
