/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <stdio.h>
#include "version.h"


char *version (char *buf);
char is_it_a_new_prog_version (char *buf);
char *a_little_version_infos (char *buf);
char *a_little_more_infos (char *buf);
char *yet_a_little_more_infos (char *buf);
char *many_version_infos (char *buf);
char *compile_host (char *buf);

char *a_parano_version_infos (char *buf);
char *http_version_infos (char *buf);

char *
version (char *buf)
{
  strcpy (buf, PROG_VERSION);
  return buf;
}

char
is_it_a_new_prog_version (char *buf)
{
  return strcmp (buf, PROG_VERSION);
}


char *
a_parano_version_infos (char *buf)
{
  sprintf (buf, "%s ALPHA v%s - Copyright (c)JM Jacquet 1998,%s - ALL RIGHTS RESERVED.", PROG_NAME, PROG_VERSION, VERSION_DATE);
  return buf;
}

char *
http_version_infos (char *buf)
{
  sprintf (buf, "%s ALPHA v%s - http://www.littleigloo.org", PROG_NAME, PROG_VERSION);
  return buf;
}


char *
a_little_version_infos (char *buf)
{
  sprintf (buf, "%s ALPHA v%s - (c)Jean-Marc Jacquet 1998-%s.", PROG_NAME, PROG_VERSION, VERSION_DATE);
  return buf;
}

char *
a_little_more_infos (char *buf)
{
  sprintf (buf, "Compiled by %s on %s the %s at %s", COMPILE_BY, COMPILE_HOST, COMPILE_DATE, COMPILE_TIME);
  return buf;
}

char *
yet_a_little_more_infos (char *buf)
{
  sprintf (buf, "Using %s and %s", CC_VERSION, GTK_VERSION);
  return buf;
}

char *
many_version_infos (char *buf)
{
  char this_buf[250];
  sprintf (buf, "%s\n%s\n%s\n---", a_little_version_infos (this_buf), a_little_more_infos (this_buf), yet_a_little_more_infos (this_buf));
  return buf;
}

char *
compile_host (char *buf)
{
  strcpy (buf, COMPILE_HOST);
  return buf;
}


/* EOF */
