/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>

#include "protos.h"
#include "toolbar.h"



/*
   * MAIN TOOLBAR
   * PUBLIC :
   * show_or_hide_toolbar
   * toolbar_set_style
   * toolbar_set_sensitive  
   * toolbar_xfer_buttons_set_sensitive
   * toolbar_queue_buttons_set_sensitive
   * create_toolbar
 */

void
show_or_hide_toolbar (GtkWidget * widget)
{
  show_hide_widget (handle_box, GTK_CHECK_MENU_ITEM (widget)->active);
  menu_set_toolbar_style (GTK_CHECK_MENU_ITEM (widget)->active);
}

void
toolbar_set_style (GtkWidget * widget, GtkToolbarStyle style)
{
  if (toolbar == NULL)
    return;
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar), style);
  user_rc.toolbar_style = style;
  gtk_widget_set_usize (handle_box, -1, -1);	// redraw toolbar

}

void
toolbar_buttons_set_sensitive (void)
{
  gint local_selected_items = local_selection_info ();
  gint remote_selected_items = remote_selection_info ();

  gtk_widget_set_sensitive (button_disconnect, this_connexion.is_connected);
  gtk_widget_set_sensitive (button_bookmark_path, (this_connexion.is_connected && USER_CONNECT_VIA_SITE_MANAGER));
  gtk_widget_set_sensitive (button_bookmark, (this_connexion.is_connected && !USER_CONNECT_VIA_SITE_MANAGER));
  gtk_widget_set_sensitive (button_upload, local_selected_items && this_connexion.is_connected);
  gtk_widget_set_sensitive (button_download, remote_selected_items && this_connexion.is_connected);
  gtk_widget_set_sensitive (button_queue_add, (remote_selected_items || local_selected_items) && this_connexion.is_connected);
}

void
toolbar_xfer_buttons_set_sensitive (char FLAG)
{
  gtk_widget_set_sensitive (button_upload, FLAG && this_connexion.is_connected);
  gtk_widget_set_sensitive (button_download, FLAG && this_connexion.is_connected);
}

void
toolbar_queue_buttons_set_sensitive (char FLAG)
{
  gtk_widget_set_sensitive (button_queue_clear, FLAG);
  gtk_widget_set_sensitive (button_queue_run, FLAG);
}




GtkWidget *
create_toolbar (GtkWidget * window, GtkWidget * vbox)
{
#ifndef ALT_FTP_ICONS
#include "pixmaps/connect.xpm"
#include "pixmaps/disconnect.xpm"
#include "pixmaps/abort.xpm"
#include "pixmaps/download.xpm"
#include "pixmaps/upload.xpm"
#include "pixmaps/queue_add.xpm"
#include "pixmaps/queue_xfer.xpm"
#include "pixmaps/queue_del.xpm"
#include "pixmaps/find.xpm"
#include "pixmaps/site_bookmark.xpm"
#include "pixmaps/path_bookmark.xpm"
#else
#include "pixmaps/alt/connect.xpm"
#include "pixmaps/alt/disconnect.xpm"
#include "pixmaps/alt/abort.xpm"
#include "pixmaps/alt/download.xpm"
#include "pixmaps/alt/upload.xpm"
#include "pixmaps/alt/queue_add.xpm"
#include "pixmaps/alt/queue_xfer.xpm"
#include "pixmaps/alt/queue_del.xpm"
#include "pixmaps/alt/find.xpm"
#include "pixmaps/alt/site_bookmark.xpm"
#include "pixmaps/alt/path_bookmark.xpm"
#endif


  handle_box = gtk_handle_box_new ();
  gtk_box_pack_start (GTK_BOX (vbox), handle_box, FALSE, FALSE, 0);
  show_hide_widget (handle_box, user_rc.view_toolbar);

  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar), user_rc.toolbar_style);
  gtk_container_add (GTK_CONTAINER (handle_box), toolbar);
  gtk_widget_show (toolbar);

  gtk_container_border_width (GTK_CONTAINER (toolbar), 2);
  gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar), GTK_RELIEF_NONE);
  gtk_toolbar_set_space_style (GTK_TOOLBAR (toolbar), 1);

  gtk_toolbar_set_space_size (GTK_TOOLBAR (toolbar), 10);


  button_connect = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), "Connect", " Connect / Reconnect ", "",
					    new_pixmap (window, connect_xpm),
			GTK_SIGNAL_FUNC (IGLOO_connect_or_reconnect), NULL);

  button_abort = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), "Stop", " Stop ", "",
					  new_pixmap (window, abort_xpm),
				       GTK_SIGNAL_FUNC (IGLOO_abort), NULL);

  button_disconnect = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), "Disconnect", " Disconnect ", "",
					new_pixmap (window, disconnect_xpm),
				      GTK_SIGNAL_FUNC (IGLOO_logoff), NULL);

  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

  button_preferences = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), "Preferences", " Set Preferences ", "",
						preferences_pixmap (window),
				   GTK_SIGNAL_FUNC (custom_notebook), NULL);

  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

  button_bookmark = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), "Bookmark site", " Bookmark site ", "",
				     new_pixmap (window, site_bookmark_xpm),
			 GTK_SIGNAL_FUNC (SMAN_bookmark_site_dialog), NULL);

  button_bookmark_path = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), "Bookmark path", " Bookmark Local / Remote path ", "",
				     new_pixmap (window, path_bookmark_xpm),
			 GTK_SIGNAL_FUNC (SMAN_bookmark_path_dialog), NULL);

  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

  button_queue_add = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), "Add to Queue", " Add to Queue ", "",
					 new_pixmap (window, queue_add_xpm),
			       GTK_SIGNAL_FUNC (QUEUE_add_selection), NULL);

  button_queue_clear = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), "Clear Queue", " Clear Queue ", "",
					 new_pixmap (window, queue_del_xpm),
				       GTK_SIGNAL_FUNC (QUEUE_clear), NULL);

  button_queue_run = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), "Transfer Queue", " Transfer Queue ", "",
					new_pixmap (window, queue_xfer_xpm),
					GTK_SIGNAL_FUNC (QUEUE_xfer), NULL);

  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

  button_upload = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), "Upload", " Upload Selection ", "",
					   new_pixmap (window, upload_xpm),
				  GTK_SIGNAL_FUNC (upload_selection), NULL);

  button_download = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), "Download", " Download Selection ", "",
					  new_pixmap (window, download_xpm),
				GTK_SIGNAL_FUNC (download_selection), NULL);

  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

  gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), "Find", " Find a File ", "",
			   new_pixmap (window, find_xpm),
			   GTK_SIGNAL_FUNC (FOCUS_LIST_find), NULL);

  return toolbar;
}








/*  MINI TOOLBAR (in statusbar) */

/* PUBLIC :
 * create_mini_toolbar
 */

GtkWidget *
create_mini_toolbar (GtkWidget * window, GtkWidget * vbox)
{
/*
   #include "pixmaps/mail.xpm"
   #include "pixmaps/mail_to.xpm"
   #include "pixmaps/browser.xpm"
   #include "pixmaps/news.xpm"
 */
#include "pixmaps/mini_mail.xpm"
#include "pixmaps/mini_send.xpm"
#include "pixmaps/mini_news.xpm"
//#include "pixmaps/mini_ftp.xpm"
#include "pixmaps/mini_web.xpm"

  GtkWidget *toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);

  gtk_container_add (GTK_CONTAINER (vbox), toolbar);
  gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar), GTK_RELIEF_NONE);
  gtk_widget_show (toolbar);
/*
   gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), "", " New FTP session ", "", new_pixmap (window, mini_ftp_xpm),
   GTK_SIGNAL_FUNC (spawn_session_from_widget), NULL);
 */
  gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), "", " Launch Browser ", "", new_pixmap (window, mini_web_xpm),
			   GTK_SIGNAL_FUNC (open_URL_from_widget), NULL);

  gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), "", " Launch Mail Reader ", "", new_pixmap (window, mini_mail_xpm),
			   GTK_SIGNAL_FUNC (open_mail_client), NULL);

  gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), "", " Launch Mail Composer ", "", new_pixmap (window, mini_send_xpm),
			   GTK_SIGNAL_FUNC (open_new_message), NULL);

  gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), "", " Launch News Reader ", "", new_pixmap (window, mini_news_xpm),
			   GTK_SIGNAL_FUNC (open_news_client), NULL);

  return toolbar;
}


/* EOF */
