/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */


#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

#include "protos.h"
#include "statusbar.h"




/* MESSAGE Functions */

/* PUBLIC :
 * status_message
 * status_message_with_arg
 * default_status_message
 * idle_message
 */

void
status_message (char *this_message)
{
  gtk_label_set (GTK_LABEL (label_file), this_message);
}

void
status_message_with_arg (char *this_message, char *this_arg)
{
  char msg_buf[1024];
  sprintf (msg_buf, "%s %s ...", this_message, this_arg);
  gtk_label_set (GTK_LABEL (label_file), msg_buf);
  PROCESS_EVENTS;
}

void
default_status_message ()
{
  char buf[256];

  if (this_connexion.is_connected)
    sprintf (buf, "Connected to %s on port %hi.", this_connexion.hostname, this_connexion.port);
  else
    strcpy (buf, "Not connected");

  gtk_label_set (GTK_LABEL (label_file), buf);
}

void
idle_message (char *this_message)
{
  gtk_label_set (GTK_LABEL (label_elapsed), this_message);
}






/* PROGRESS_BAR Functions */

/* PUBLIC :
 * update_file_transfert_status_idle 
 * init_file_transfert_status
 * update_file_transfert_status 
 * clear_file_transfert_status
 */

void
update_file_transfert_status_idle (void)
{
  PROCESS_EVENTS_WHILE_XFER;
}

void
init_file_transfert_status (char *this_filename, long this_filesize, long this_resume_offset, char IS_IT_A_DOWNLOAD)
{
  char msg_buf[256];

  elapsed_time = 0L;
  last_elapsed_time = 0L;
  this_connexion.timer_start = 0L;
  transfert_speed = 0;

  resume_offset = this_resume_offset;
  filesize = this_filesize - this_resume_offset;
  xfer_sec = 0;
  xfer_min = 0;
  xfer_hour = 0;
  BUSY = 0;

  gtk_widget_set_usize (hbox_pixmap_info, 26, 16);

  IS_IT_A_DOWNLOAD ? gtk_widget_show (pixmap_stat_download) : gtk_widget_show (pixmap_stat_upload);

  sprintf (msg_buf, "%s (%ld bytes)", this_filename, this_filesize);
  gtk_label_set (GTK_LABEL (label_file), msg_buf);
  gtk_label_set (GTK_LABEL (label_speed), "0,00 k/s");
  gtk_label_set (GTK_LABEL (label_elapsed), "00:00:00");
  gtk_label_set (GTK_LABEL (label_remain), "00:00:00");

  gtk_progress_configure (GTK_PROGRESS (progressbar), (long) resume_offset, 0, (long) this_filesize);
  gtk_progress_set_value (GTK_PROGRESS (progressbar), (long) resume_offset);
  gtk_progress_set_show_text (GTK_PROGRESS (progressbar), TRUE);

  gtk_widget_show (pixmap_remain);
  gtk_widget_show (pixmap_elapsed);
}



gint
update_file_transfert_status (gpointer data)
{
  char buf[40];

  if (BUSY)
    return TRUE;
  BUSY = TRUE;

  if (!this_connexion.xfered_bytes)
    return !(BUSY = FALSE);

  gtk_progress_set_value (GTK_PROGRESS (progressbar), ((long) this_connexion.xfered_bytes + (long) resume_offset));

  if ((elapsed_time = time (NULL) - this_connexion.timer_start) != last_elapsed_time)
    {
      short int time_h;
      short int time_m;
      short int time_s;
      time_t remaining_time = 0;

      last_elapsed_time = elapsed_time;

      time_h = (short int) (elapsed_time / 3600);
      time_m = (short int) ((elapsed_time / 60) - (time_h * 60));
      time_s = (short int) ((elapsed_time - (time_m * 60)) - (time_h * 3600));
      sprintf (buf, "%02i:%02i:%02i", time_h, time_m, time_s);
      gtk_label_set (GTK_LABEL (label_elapsed), buf);

      transfert_speed = (float) this_connexion.xfered_bytes / (float) elapsed_time;
      if ((filesize - this_connexion.xfered_bytes) < transfert_speed)
	remaining_time = 0L;
      else
	remaining_time = ((float) (filesize - this_connexion.xfered_bytes) / (float) transfert_speed);
      transfert_speed = transfert_speed / 1024.000;

      time_h = (short int) (remaining_time / 3600);
      time_m = (short int) ((remaining_time / 60) - (time_h * 60));
      time_s = (short int) ((remaining_time - (time_m * 60)) - (time_h * 3600));
      sprintf (buf, "%02i:%02i:%02i", time_h, time_m, time_s);
      gtk_label_set (GTK_LABEL (label_remain), buf);

      sprintf (buf, "%3.2f k/s", transfert_speed);
      gtk_label_set (GTK_LABEL (label_speed), buf);
    }

  return !(BUSY = FALSE);
}



void
clear_file_transfert_status (void)
{
  PROCESS_EVENTS;
  //sleep (1);
  gtk_widget_hide (pixmap_stat_download);
  gtk_widget_hide (pixmap_stat_upload);
  gtk_widget_set_usize (hbox_pixmap_info, 0, 0);
  gtk_label_set (GTK_LABEL (label_file), " ");
  gtk_label_set (GTK_LABEL (label_speed), " ");
  gtk_label_set (GTK_LABEL (label_elapsed), " ");
  gtk_label_set (GTK_LABEL (label_remain), " ");
  gtk_progress_set_show_text (GTK_PROGRESS (progressbar), FALSE);
  gtk_progress_bar_update (GTK_PROGRESS_BAR (progressbar), 0.00);
  gtk_widget_hide (pixmap_remain);
  gtk_widget_hide (pixmap_elapsed);
}








/* STATUS_BAR */

/* PUBLIC :
 * create_status_bar
 */

GtkWidget *
create_status_bar ()
{
#include "pixmaps/remain.xpm"
#include "pixmaps/elapsed.xpm"
#include "pixmaps/file_download.xpm"
#include "pixmaps/file_upload.xpm"
  GtkWidget *hbox;
  GtkWidget *frame;
  GtkWidget *hbox1;
  GtkStyle *style;

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_widget_set_usize (hbox, -1, 24);
  gtk_container_border_width (GTK_CONTAINER (hbox), 1);


  frame = create_frame (hbox, NULL, TRUE, TRUE, GTK_SHADOW_IN);
  hbox1 = h_box (frame, FALSE, 0, 0);

  hbox_pixmap_info = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox_pixmap_info);
  gtk_box_pack_start (GTK_BOX (hbox1), hbox_pixmap_info, FALSE, TRUE, 0);
  gtk_widget_set_usize (hbox_pixmap_info, 0, 0);

  pixmap_stat_download = new_pixmap (window, file_download_xpm);
  pixmap_stat_upload = new_pixmap (window, file_upload_xpm);
  gtk_box_pack_start (GTK_BOX (hbox_pixmap_info), pixmap_stat_download, FALSE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox_pixmap_info), pixmap_stat_upload, FALSE, TRUE, 0);

  label_file = gtk_label_new (" ");
  gtk_widget_show (label_file);
  gtk_box_pack_start (GTK_BOX (hbox1), label_file, FALSE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label_file), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label_file), 3, 0);


  progressbar = gtk_progress_bar_new_with_adjustment ((GtkAdjustment *) gtk_adjustment_new (0, 0, 0, 0, 0, 0));
  gtk_progress_set_format_string (GTK_PROGRESS (progressbar), "%v  (%p%%)");
  gtk_progress_set_show_text (GTK_PROGRESS (progressbar), FALSE);
  gtk_progress_set_value (GTK_PROGRESS (progressbar), 0);
  gtk_progress_set_text_alignment (GTK_PROGRESS (progressbar), 0.5, 1);
  gtk_widget_set_usize (progressbar, 125, -1);
  gtk_box_pack_start (GTK_BOX (hbox), progressbar, FALSE, TRUE, 0);
  gtk_widget_show (progressbar);


  frame = create_frame (hbox, NULL, FALSE, TRUE, GTK_SHADOW_IN);
  gtk_widget_set_usize (frame, 75, -1);
  hbox1 = h_box (frame, FALSE, 0, 0);

  label_speed = gtk_label_new (" ");
  gtk_widget_show (label_speed);
  gtk_box_pack_start (GTK_BOX (hbox1), label_speed, TRUE, TRUE, 0);


  frame = create_frame (hbox, NULL, FALSE, TRUE, GTK_SHADOW_IN);
  gtk_widget_set_usize (frame, 80, -1);
  hbox1 = h_box (frame, FALSE, 0, 0);

  pixmap_elapsed = new_pixmap (window, elapsed_xpm);
  gtk_box_pack_start (GTK_BOX (hbox1), pixmap_elapsed, FALSE, TRUE, 0);
  gtk_widget_show (pixmap_elapsed);
  gtk_widget_hide (pixmap_elapsed);

  label_elapsed = gtk_label_new (" ");
  gtk_widget_show (label_elapsed);
  gtk_box_pack_start (GTK_BOX (hbox1), label_elapsed, TRUE, TRUE, 0);

  style = gtk_style_new ();
  style->fg[GTK_STATE_NORMAL] = GREEN;
  gtk_widget_set_style (label_elapsed, style);


  frame = create_frame (hbox, NULL, FALSE, TRUE, GTK_SHADOW_IN);
  gtk_widget_set_usize (frame, 80, -1);
  hbox1 = h_box (frame, FALSE, 0, 0);

  pixmap_remain = new_pixmap (window, remain_xpm);
  gtk_box_pack_start (GTK_BOX (hbox1), pixmap_remain, FALSE, TRUE, 0);
  gtk_widget_show (pixmap_remain);
  gtk_widget_hide (pixmap_remain);

  label_remain = gtk_label_new (" ");
  gtk_widget_show (label_remain);
  gtk_box_pack_start (GTK_BOX (hbox1), label_remain, FALSE, TRUE, 0);

  style = gtk_style_new ();
  style->fg[GTK_STATE_NORMAL] = RED;
  gtk_widget_set_style (label_remain, style);


  frame = create_frame (hbox, NULL, FALSE, FALSE, GTK_SHADOW_ETCHED_IN);

  hbox1 = gtk_handle_box_new ();
  gtk_container_add (GTK_CONTAINER (frame), hbox1);
  create_mini_toolbar (window, hbox1);
  gtk_widget_show (hbox1);

  return hbox;
}



/* EOF */
