/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

static FILE *Qxfer_log = NULL;


#define QUEUE_XFER_log_new_line();  fprintf (Qxfer_log, "\n");fflush (Qxfer_log);
static void QUEUE_XFER_close_log (void);
static void QUEUE_XFER_init_log (void);
static void QUEUE_XFER_log (char *this_message, char *this_arg);
static void QUEUE_XFER_log_Qentry (QUEUEfile * Qfile);
static void QUEUE_XFER_log_error (char *this_message, char *this_arg, char this_status);

static void QUEUE_xfer_erase_log (void);


/* QUEUE XFER LOG functions */

/* STATIC:
 * QUEUE_XFER_close_log
 * QUEUE_XFER_init_log
 * QUEUE_XFER_log
 * QUEUE_XFER_log_Qentry
 * QUEUE_XFER_log_error 
 */

static void
QUEUE_XFER_close_log (void)
{
  if (Qxfer_log != NULL)
    {
      fprintf (Qxfer_log, "\n---\nLOG CLOSED.\n");
      fflush (Qxfer_log);
      fclose (Qxfer_log);
      Qxfer_log = NULL;
    }
}


static void
QUEUE_XFER_init_log (void)
{
  char this_buf[250];
  char this_path[MPLEN];
  QUEUE_XFER_close_log ();
  queue_log_path (this_path, queue_current_name);
  Qxfer_log = fopen (this_path, "w");
  fprintf (Qxfer_log, "%s\n", a_little_version_infos (this_buf));
  fprintf (Qxfer_log, "%s\n", a_little_more_infos (this_buf));
  fprintf (Qxfer_log, "%s\n---\nQUEUE XFER LOG OPENED\n---\n\n", yet_a_little_more_infos (this_buf));
}


static void
QUEUE_XFER_log (char *this_message, char *this_arg)
{
  if (Qxfer_log == NULL)
    QUEUE_XFER_init_log ();
  fprintf (Qxfer_log, "%s %s\n", this_message, this_arg == NULL ? "" : this_arg);
  fflush (Qxfer_log);
}


static void
QUEUE_XFER_log_Qentry (QUEUEfile * Qfile)
{
  char remote_buf[MPLEN];

  sprintf (remote_buf, "//%s/%s/%s", Qfile->session.hostname, Qfile->session.cwd_dir, Qfile->filename);
  I_want_only_one_slash_here ((char *) (remote_buf + 1));

  fprintf (Qxfer_log, "XFER: %s/%s %s %s\n", Qfile->session.local_dir, Qfile->filename,
	   (Qfile->xfer_type == QUEUE_DOWNLOAD) ? "<-" : "->", remote_buf);
  fflush (Qxfer_log);
}


static void
QUEUE_XFER_log_error (char *this_message, char *this_arg, char this_status)
{
  static char *status_msg[] =
  {"*UNKNOWN*", "DELAYED", "CANCELLED"};
  char *ptr = status_msg[0];

  switch (this_status)
    {
    case QSTATUS_DELAYED:
      ptr = status_msg[1];
      break;
    case QSTATUS_CANCELLED:
      ptr = status_msg[2];
      break;
    }

  fprintf (Qxfer_log, "[ERROR] %s %s \t [STATUS] %s\n", this_message, this_arg == NULL ? "" : this_arg, ptr);
  fflush (Qxfer_log);
}






/* QUEUE LOG Manangement functions */

/*PUBLIC:
   * QUEUE_xfer_has_log
   * QUEUE_xfer_show_log
   * STATIC:
   * QUEUE_xfer_erase_log
 */

char
QUEUE_xfer_has_log (void)
{
  char this_log[MPLEN];
  queue_log_path (this_log, queue_current_name);
  return (!access (this_log, R_OK));
}

void
QUEUE_xfer_show_log (GtkWidget * widget, gpointer data)
{
  char this_log[MPLEN];
  queue_log_path (this_log, queue_current_name);
  if (!access (this_log, R_OK))
    TXT_edit (this_log);
}

static void
QUEUE_xfer_erase_log (void)
{
  char this_log[MPLEN];
  queue_log_path (this_log, queue_current_name);
  if (!access (this_log, F_OK))
    unlink (this_log);
}


/* EOF */
