/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */


#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include "protos.h"



GtkWidget *
new_pixmap (GtkWidget * widget, char **data)
{
  GdkPixmap *gdkpixmap;
  GdkBitmap *mask;
  GtkWidget *pixmap;

  gdkpixmap = gdk_pixmap_create_from_xpm_d (widget->window, &mask, &widget->style->bg[GTK_STATE_NORMAL], data);
  pixmap = gtk_pixmap_new (gdkpixmap, mask);

  gdk_pixmap_unref (gdkpixmap);
  gdk_pixmap_unref (mask);
  return pixmap;
}


void
set_window_icon (GtkWidget * this_window)
{
#include "pixmaps/icon.xpm"
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  pixmap = gdk_pixmap_create_from_xpm_d (this_window->window, &mask, &this_window->style->bg[GTK_STATE_NORMAL], icon_xpm);
  gdk_window_set_icon (this_window->window, NULL, pixmap, mask);
}


GtkWidget *
make_program_icon (void)
{
#ifndef ALT_ICONS
#include "pixmaps/connect.xpm"
#else
#include "pixmaps/alt/connectNB.xpm"
#endif
  return new_pixmap (window, connect_xpm);
}


void
program_icon (GtkWidget * this_box)
{
  GtkWidget *pixmap = make_program_icon ();
  gtk_box_pack_start (GTK_BOX (this_box), pixmap, FALSE, FALSE, 0);
  gtk_widget_show (pixmap);
}


void
exclam_icon (GtkWidget * this_box)
{
#include "pixmaps/exclam.xpm"
  GtkWidget *pixmap = new_pixmap (window, exclam_xpm);
  gtk_box_pack_start (GTK_BOX (this_box), pixmap, FALSE, FALSE, 0);
  gtk_widget_show (pixmap);
}


void
inter_icon (GtkWidget * this_box)
{
#include "pixmaps/inter.xpm"
  GtkWidget *pixmap = new_pixmap (window, inter_xpm);
  gtk_box_pack_start (GTK_BOX (this_box), pixmap, FALSE, FALSE, 0);
  gtk_widget_show (pixmap);
}

void
give_a_nice_icon_to_this_file (char *this_filename, GtkWidget * this_list, int row)
{
#include "pixmaps/rpm.xpm"
#include "pixmaps/dpkg.xpm"
#include "pixmaps/tgz.xpm"
#include "pixmaps/html.xpm"
#include "pixmaps/graph.xpm"
#include "pixmaps/core.xpm"

  GdkPixmap *pixmap = NULL;
  GdkBitmap *mask;
  char *filename = g_strdup (this_filename);
  char *ext = strrchr (filename, '.');
  char this_ext[128];
  strupr (filename);

  if (ext != NULL)
    {
      sprintf (this_ext, "%s.", ext);
      if (strstr (".TGZ.GZ.ZIP.", this_ext) != NULL)
	pixmap = gdk_pixmap_create_from_xpm_d (window->window, &mask, &window->style->bg[GTK_STATE_NORMAL], tgz_xpm);
      else if (!strcmp (ext, ".RPM"))
	pixmap = gdk_pixmap_create_from_xpm_d (window->window, &mask, &window->style->bg[GTK_STATE_NORMAL], rpm_xpm);
      else if (!strcmp (ext, ".DEB"))
	pixmap = gdk_pixmap_create_from_xpm_d (window->window, &mask, &window->style->bg[GTK_STATE_NORMAL], dpkg_xpm);
      else if (strstr (".HTM.HTML.", this_ext) != NULL)
	pixmap = gdk_pixmap_create_from_xpm_d (window->window, &mask, &window->style->bg[GTK_STATE_NORMAL], html_xpm);
      else if (strstr (".GIF.JPG.XPM.BMP.PNG.", this_ext) != NULL)
	pixmap = gdk_pixmap_create_from_xpm_d (window->window, &mask, &window->style->bg[GTK_STATE_NORMAL], graph_xpm);
      else if (strstr (".DOC.MSG.TXT.LSM.DIZ.", this_ext) != NULL)
	pixmap = text_file_pixmap (&mask);
    }

  if (pixmap == NULL)
    {
      if (strstr (filename, "MESSAGE") != NULL
	  || strstr (filename, "README") != NULL)
	pixmap = text_file_pixmap (&mask);
      else if (!strcmp ("CORE", filename))
	pixmap = gdk_pixmap_create_from_xpm_d (window->window, &mask, &window->style->bg[GTK_STATE_NORMAL], core_xpm);
      else
	pixmap = default_file_pixmap (&mask);
    }


  gtk_clist_set_pixmap (GTK_CLIST (this_list), row, 0, pixmap, mask);
  gdk_pixmap_unref (pixmap);
  gdk_pixmap_unref (mask);
  g_free (filename);
}








GtkWidget *
preferences_pixmap (GtkWidget * widget)
{
#ifndef ALT_ICONS
#include "pixmaps/preferences.xpm"
#else
#include "pixmaps/alt/preferences.xpm"
#endif
  return new_pixmap (widget, preferences_xpm);
}



GtkWidget *
smanager_pixmap (GtkWidget * widget)
{
#include "pixmaps/smanager.xpm"
  return new_pixmap (widget, smanager_xpm);
}



GdkPixmap *
computer_pixmap (GdkBitmap ** mask)
{
#include "pixmaps/computer.xpm"
  return gdk_pixmap_create_from_xpm_d (window->window, mask, &window->style->bg[GTK_STATE_NORMAL], computer_xpm);
}


GdkPixmap *
arrow_down_pixmap (GdkBitmap ** mask)
{
#include "pixmaps/arrow_down.xpm"
  return gdk_pixmap_create_from_xpm_d (window->window, mask, &window->style->bg[GTK_STATE_NORMAL], arrow_down_xpm);
}


GdkPixmap *
default_file_pixmap (GdkBitmap ** mask)
{
#include "pixmaps/file.xpm"
  return gdk_pixmap_create_from_xpm_d (window->window, mask, &window->style->bg[GTK_STATE_NORMAL], file_xpm);
}


GdkPixmap *
text_file_pixmap (GdkBitmap ** mask)
{
#include "pixmaps/txt.xpm"
  return gdk_pixmap_create_from_xpm_d (window->window, mask, &window->style->bg[GTK_STATE_NORMAL], txt_xpm);
}

GdkPixmap *
folder_pixmap (GdkBitmap ** mask)
{
#include "pixmaps/folder.xpm"
  return gdk_pixmap_create_from_xpm_d (window->window, mask, &window->style->bg[GTK_STATE_NORMAL], folder_xpm);
}



GdkPixmap *
folder_open_pixmap (GdkBitmap ** mask)
{
#include "pixmaps/folder_open.xpm"
  return gdk_pixmap_create_from_xpm_d (window->window, mask, &window->style->bg[GTK_STATE_NORMAL], folder_open_xpm);
}


GdkPixmap *
folder_l_pixmap (GdkBitmap ** mask)
{
#include "pixmaps/folder_l.xpm"
  return gdk_pixmap_create_from_xpm_d (window->window, mask, &window->style->bg[GTK_STATE_NORMAL], folder_l_xpm);
}


GdkPixmap *
folder_open_l_pixmap (GdkBitmap ** mask)
{
#include "pixmaps/folder_open_l.xpm"
  return gdk_pixmap_create_from_xpm_d (window->window, mask, &window->style->bg[GTK_STATE_NORMAL], folder_open_l_xpm);
}



GdkPixmap *
parent_pixmap (GdkBitmap ** mask)
{
#include "pixmaps/parent.xpm"
  return gdk_pixmap_create_from_xpm_d (window->window, mask, &window->style->bg[GTK_STATE_NORMAL], parent_xpm);
}



GdkPixmap *
dlink_pixmap (GdkBitmap ** mask)
{
#include "pixmaps/dlink.xpm"
  return gdk_pixmap_create_from_xpm_d (window->window, mask, &window->style->bg[GTK_STATE_NORMAL], dlink_xpm);
}



GdkPixmap *
flink_pixmap (GdkBitmap ** mask)
{
#include "pixmaps/flink.xpm"
  return gdk_pixmap_create_from_xpm_d (window->window, mask, &window->style->bg[GTK_STATE_NORMAL], flink_xpm);
}



GdkPixmap *
man_grp_pixmap (GdkBitmap ** mask)
{
#include "pixmaps/man_grp.xpm"
  return gdk_pixmap_create_from_xpm_d (window->window, mask, &window->style->bg[GTK_STATE_NORMAL], man_grp_xpm);
}



GdkPixmap *
man_grp_open_pixmap (GdkBitmap ** mask)
{
#include "pixmaps/man_grp_open.xpm"
  return gdk_pixmap_create_from_xpm_d (window->window, mask, &window->style->bg[GTK_STATE_NORMAL], man_grp_open_xpm);
}



GdkPixmap *
man_site_pixmap (GdkBitmap ** mask)
{
#include "pixmaps/man_site.xpm"
  return gdk_pixmap_create_from_xpm_d (window->window, mask, &window->style->bg[GTK_STATE_NORMAL], man_site_xpm);
}


GdkPixmap *
preferences_node (GdkBitmap ** mask)
{
#include "pixmaps/preferences_node.xpm"
  return gdk_pixmap_create_from_xpm_d (window->window, mask, &window->style->bg[GTK_STATE_NORMAL], preferences_node_xpm);
}


GdkPixmap *
arrow_right_pixmap (GdkBitmap ** mask)
{
#include "pixmaps/arrow_right.xpm"
  return gdk_pixmap_create_from_xpm_d (window->window, mask, &window->style->bg[GTK_STATE_NORMAL], arrow_right_xpm);
}

GdkPixmap *
arrow_left_pixmap (GdkBitmap ** mask)
{
#include "pixmaps/arrow_left.xpm"
  return gdk_pixmap_create_from_xpm_d (window->window, mask, &window->style->bg[GTK_STATE_NORMAL], arrow_left_xpm);
}

/* EOF */
