/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include <unistd.h>

#include "protos.h"
#include "menu.h"







/* LOCAL Popup Menu */

/* PUBLIC :
 * update_local_popup_menu
 * update_local_popup_menu_execute
 * local_popup_menu_set_sensitive
 * STATIC :
 * create_local_popup_menu
 */

static GtkWidget *
create_local_popup_menu (void)
{
  GtkWidget *menu = gtk_menu_new ();
  GtkWidget *menu_in_menu;
  GtkWidget *menu_item;

  menu_tearoff (menu);

  local_popup.queue = create_menu_item (menu, " Queue ", FALSE, GTK_SIGNAL_FUNC (queue_selection_for_upload), NULL);
  local_popup.xfer = create_menu_item (menu, " Upload ", FALSE, GTK_SIGNAL_FUNC (upload_selection), NULL);

  menu_separator (menu);

  menu_in_menu = create_menu_in_menu (menu, " Select ...");
  local_popup.select = create_menu_item (menu_in_menu, " Select All ", TRUE, GTK_SIGNAL_FUNC (local_select_all), NULL);
  local_popup.selectf = create_menu_item (menu_in_menu, " Select All Files ", TRUE, GTK_SIGNAL_FUNC (local_select_all_files), NULL);
  local_popup.unselect = create_menu_item (menu_in_menu, " Unselect All ", FALSE, GTK_SIGNAL_FUNC (local_unselect_all), NULL);
  local_popup.undoselect = create_menu_item (menu_in_menu, " Undo Last Selection   ", FALSE, GTK_SIGNAL_FUNC (local_undo_last_selection), NULL);
  menu_separator (menu_in_menu);
  menu_separator (menu_in_menu);


  menu_separator (menu);

  menu_in_menu = create_menu_in_menu (menu, " Sort ...");
  local_popup.menu_radio_sort_by_name = menu_item = create_menu_radio_item (menu_in_menu, NULL, "By Name", local_sort_from_menu,
  GINT_TO_POINTER (DIR_COL_SORT_BY_NAME), local_clist_sort == SORT_BY_NAME);
  local_popup.menu_radio_sort_by_size = menu_item = create_menu_radio_item (menu_in_menu, menu_item, "By Size", local_sort_from_menu,
  GINT_TO_POINTER (DIR_COL_SORT_BY_SIZE), local_clist_sort == SORT_BY_SIZE);
  local_popup.menu_radio_sort_by_date = menu_item = create_menu_radio_item (menu_in_menu, menu_item, "By Date", local_sort_from_menu,
  GINT_TO_POINTER (DIR_COL_SORT_BY_DATE), local_clist_sort == SORT_BY_DATE);
  local_popup.menu_radio_sort_by_perm = menu_item = create_menu_radio_item (menu_in_menu, menu_item, "By Permission  ", local_sort_from_menu,
  GINT_TO_POINTER (DIR_COL_SORT_BY_PERM), local_clist_sort == SORT_BY_PERM);
  local_popup.menu_radio_sort_by_uid = menu_item = create_menu_radio_item (menu_in_menu, menu_item, "By Owner", local_sort_from_menu,
    GINT_TO_POINTER (DIR_COL_SORT_BY_UID), local_clist_sort == SORT_BY_UID);
  local_popup.menu_radio_sort_by_gid = menu_item = create_menu_radio_item (menu_in_menu, menu_item, "By Group", local_sort_from_menu,
    GINT_TO_POINTER (DIR_COL_SORT_BY_GID), local_clist_sort == SORT_BY_GID);
  menu_separator (menu_in_menu);

  local_popup.menu_radio_sort_down = menu_item = create_menu_radio_item (menu_in_menu, NULL, "Ascending", local_sort_type_from_menu,
	   GINT_TO_POINTER (SORT_DOWN), local_clist_sort_type == SORT_DOWN);
  local_popup.menu_radio_sort_up = menu_item = create_menu_radio_item (menu_in_menu, menu_item, "Descending", local_sort_type_from_menu,
	       GINT_TO_POINTER (SORT_UP), local_clist_sort_type == SORT_UP);

  menu_separator (menu_in_menu);
  menu_separator (menu_in_menu);

  menu_separator (menu);

  local_popup.view = create_menu_item (menu, " View ", FALSE, GTK_SIGNAL_FUNC (local_file_view), NULL);
  local_popup.edit = create_menu_item (menu, " Edit ", FALSE, GTK_SIGNAL_FUNC (local_file_edit), NULL);
  local_popup.exec = create_menu_item (menu, " Execute ", FALSE, GTK_SIGNAL_FUNC (local_exec), NULL);

  menu_separator (menu);

  local_popup.chmod = create_menu_item (menu, " Chmod ", FALSE, GTK_SIGNAL_FUNC (local_chmod_dialog), NULL);
  local_popup.ren = create_menu_item (menu, " Rename ", FALSE, GTK_SIGNAL_FUNC (local_rename_dialog), NULL);
  local_popup.move = create_menu_item (menu, " Move ", FALSE, GTK_SIGNAL_FUNC (local_move_dialog), NULL);
  local_popup.del = create_menu_item (menu, " Delete", FALSE, GTK_SIGNAL_FUNC (local_delete_dialog), NULL);



  menu_separator (menu);

  local_popup.chdir = create_menu_item (menu, " Create Directory ", TRUE, GTK_SIGNAL_FUNC (local_create_directory_dialog), NULL);
  local_popup.mkdir = create_menu_item (menu, " Change Directory  ", TRUE, GTK_SIGNAL_FUNC (local_change_directory_dialog), NULL);

  menu_separator (menu);
  create_menu_item (menu, " Refresh  ", TRUE, GTK_SIGNAL_FUNC (refresh_dirlist), NULL);

  menu_separator (menu);
  menu_separator (menu);
  return menu;
}

void
update_local_popup_menu (gint selected_items)
{
  gtk_widget_set_sensitive (local_popup.queue, (selected_items && this_connexion.is_connected));
  gtk_widget_set_sensitive (local_popup.xfer, (selected_items && this_connexion.is_connected));
  gtk_widget_set_sensitive (local_popup.unselect, selected_items);
  gtk_widget_set_sensitive (local_popup.undoselect, selected_items);
  gtk_widget_set_sensitive (local_popup.view, (selected_items == 1));
  gtk_widget_set_sensitive (local_popup.edit, (selected_items == 1));
  gtk_widget_set_sensitive (local_popup.exec, (selected_items == 1));
  gtk_widget_set_sensitive (local_popup.chmod, selected_items);
  gtk_widget_set_sensitive (local_popup.ren, (selected_items == 1));
  gtk_widget_set_sensitive (local_popup.move, selected_items);
  gtk_widget_set_sensitive (local_popup.del, selected_items);
  gtk_widget_set_sensitive (local_popup.chdir, TRUE);
  gtk_widget_set_sensitive (local_popup.mkdir, TRUE);
  gtk_widget_set_sensitive (local_popup.select, TRUE);
  gtk_widget_set_sensitive (local_popup.selectf, TRUE);
  /* COMMANDS menu */
  update_commands_menu (selected_items);
}


void
update_local_popup_menu_execute (char FLAG)
{
  gtk_widget_set_sensitive (local_popup.exec, FLAG);
}

void
local_popup_menu_set_sensitive (char FLAG)
{
  gtk_widget_set_sensitive (local_popup.queue, FLAG);
  gtk_widget_set_sensitive (local_popup.xfer, FLAG);
  gtk_widget_set_sensitive (local_popup.unselect, FLAG);
  gtk_widget_set_sensitive (local_popup.undoselect, FLAG);
  gtk_widget_set_sensitive (local_popup.view, FLAG);
  gtk_widget_set_sensitive (local_popup.edit, FLAG);
  gtk_widget_set_sensitive (local_popup.exec, FLAG);
  gtk_widget_set_sensitive (local_popup.chmod, FLAG);
  gtk_widget_set_sensitive (local_popup.ren, FLAG);
  gtk_widget_set_sensitive (local_popup.move, FLAG);
  gtk_widget_set_sensitive (local_popup.del, FLAG);
  gtk_widget_set_sensitive (local_popup.chdir, FLAG);
  gtk_widget_set_sensitive (local_popup.mkdir, FLAG);
  gtk_widget_set_sensitive (local_popup.select, FLAG);
  gtk_widget_set_sensitive (local_popup.selectf, FLAG);
}


void
update_local_popup_menu_sort (void)
{
  //  printf("%s\n", "update_local_popup_menu_sort");
  switch (local_clist_sort)
    {
    default:
    case SORT_BY_NAME:
      gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (local_popup.menu_radio_sort_by_name), TRUE);
      break;
    case SORT_BY_SIZE:
      gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (local_popup.menu_radio_sort_by_size), TRUE);
      break;
    case SORT_BY_DATE:
      gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (local_popup.menu_radio_sort_by_date), TRUE);
      break;
    case SORT_BY_PERM:
      gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (local_popup.menu_radio_sort_by_perm), TRUE);
      break;
    case SORT_BY_UID:
      gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (local_popup.menu_radio_sort_by_uid), TRUE);
      break;
    case SORT_BY_GID:
      gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (local_popup.menu_radio_sort_by_gid), TRUE);
      break;
    }
}

void
update_local_popup_menu_sort_type (void)
{
  //  printf("%s\n"," update_local_popup_menu_sort_type" );
  if (local_clist_sort_type == SORT_UP)
    gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (local_popup.menu_radio_sort_up), TRUE);
  else
    gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (local_popup.menu_radio_sort_down), TRUE);
}



/* REMOTE Popup Menu */

/* PUBLIC :
 * update_remote_popup_menu
 * remote_popup_menu_set_sensitive
 * update_remote_popup_menu_sort
 * update_remote_popup_menu_sort_type
 * STATIC :
 * create_remote_popup_menu
 */

static GtkWidget *
create_remote_popup_menu (void)
{
  GtkWidget *menu = gtk_menu_new ();
  GtkWidget *menu_in_menu;
  GtkWidget *menu_item;

  menu_tearoff (menu);

  remote_popup.queue = create_menu_item (menu, " Queue ", FALSE, GTK_SIGNAL_FUNC (queue_selection_for_download), NULL);
  remote_popup.xfer = create_menu_item (menu, " Download ", FALSE, GTK_SIGNAL_FUNC (download_selection), NULL);

  menu_separator (menu);

  remote_select_menu = menu_in_menu = create_menu_in_menu (menu, " Select ...");

  remote_popup.select = create_menu_item (menu_in_menu, " Select All ", FALSE, GTK_SIGNAL_FUNC (remote_select_all), NULL);
  remote_popup.selectf = create_menu_item (menu_in_menu, " Select All Files ", FALSE, GTK_SIGNAL_FUNC (remote_select_all_files), NULL);
  remote_popup.unselect = create_menu_item (menu_in_menu, " Unselect All ", FALSE, GTK_SIGNAL_FUNC (remote_unselect_all), NULL);
  remote_popup.undoselect = create_menu_item (menu_in_menu, " Undo Last Selection   ", FALSE, GTK_SIGNAL_FUNC (remote_undo_last_selection), NULL);
  menu_separator (menu_in_menu);
  menu_separator (menu_in_menu);

  menu_separator (menu);

  remote_sort_menu = menu_in_menu = create_menu_in_menu (menu, " Sort ...");
  remote_popup.menu_radio_sort_by_name = menu_item = create_menu_radio_item (menu_in_menu, NULL, "By Name", remote_sort_from_menu,
  GINT_TO_POINTER (FTP_COL_SORT_BY_NAME), remote_clist_sort == SORT_BY_NAME);
  remote_popup.menu_radio_sort_by_size = menu_item = create_menu_radio_item (menu_in_menu, menu_item, "By Size", remote_sort_from_menu,
  GINT_TO_POINTER (FTP_COL_SORT_BY_SIZE), remote_clist_sort == SORT_BY_SIZE);
  remote_popup.menu_radio_sort_by_date = menu_item = create_menu_radio_item (menu_in_menu, menu_item, "By Date", remote_sort_from_menu,
  GINT_TO_POINTER (FTP_COL_SORT_BY_DATE), remote_clist_sort == SORT_BY_DATE);
  remote_popup.menu_radio_sort_by_perm = menu_item = create_menu_radio_item (menu_in_menu, menu_item, "By Permission  ", remote_sort_from_menu,
  GINT_TO_POINTER (FTP_COL_SORT_BY_PERM), remote_clist_sort == SORT_BY_PERM);
  remote_popup.menu_radio_sort_by_uid = menu_item = create_menu_radio_item (menu_in_menu, menu_item, "By Owner", remote_sort_from_menu,
   GINT_TO_POINTER (FTP_COL_SORT_BY_UID), remote_clist_sort == SORT_BY_UID);
  remote_popup.menu_radio_sort_by_gid = menu_item = create_menu_radio_item (menu_in_menu, menu_item, "By Group", remote_sort_from_menu,
   GINT_TO_POINTER (FTP_COL_SORT_BY_GID), remote_clist_sort == SORT_BY_GID);
  menu_separator (menu_in_menu);

  remote_popup.menu_radio_sort_down = menu_item = create_menu_radio_item (menu_in_menu, NULL, "Ascending", remote_sort_type_from_menu,
	  GINT_TO_POINTER (SORT_DOWN), remote_clist_sort_type == SORT_DOWN);
  remote_popup.menu_radio_sort_up = menu_item = create_menu_radio_item (menu_in_menu, menu_item, "Descending", remote_sort_type_from_menu,
	      GINT_TO_POINTER (SORT_UP), remote_clist_sort_type == SORT_UP);

  menu_separator (menu_in_menu);
  menu_separator (menu_in_menu);

  menu_separator (menu);

  remote_popup.view = create_menu_item (menu, " View ", FALSE, GTK_SIGNAL_FUNC (remote_file_view), NULL);
  remote_popup.edit = create_menu_item (menu, " Edit ", FALSE, GTK_SIGNAL_FUNC (remote_file_edit), NULL);
  remote_popup.exec = create_menu_item (menu, " Execute ", FALSE, GTK_SIGNAL_FUNC (nop), NULL);

  menu_separator (menu);

  remote_popup.chmod = create_menu_item (menu, " Chmod ", FALSE, GTK_SIGNAL_FUNC (remote_chmod_dialog), NULL);
  remote_popup.ren = create_menu_item (menu, " Rename ", FALSE, GTK_SIGNAL_FUNC (remote_rename_dialog), NULL);
  remote_popup.move = create_menu_item (menu, " Move ", FALSE, GTK_SIGNAL_FUNC (remote_move_dialog), NULL);
  remote_popup.del = create_menu_item (menu, " Delete", FALSE, GTK_SIGNAL_FUNC (remote_delete_dialog), NULL);

  menu_separator (menu);

  remote_popup.mkdir = create_menu_item (menu, " Create Directory ", FALSE, GTK_SIGNAL_FUNC (remote_create_directory_dialog), NULL);
  remote_popup.chdir = create_menu_item (menu, " Change Directory  ", FALSE, GTK_SIGNAL_FUNC (remote_change_directory_dialog), NULL);

  menu_separator (menu);

  remote_popup_refresh = create_menu_item (menu, " Refresh ", FALSE, GTK_SIGNAL_FUNC (refresh_ftplist), NULL);

  menu_separator (menu);
  menu_separator (menu);

  return menu;
}

void
update_remote_popup_menu (gint selected_items)
{
  gtk_widget_set_sensitive (remote_popup.queue, (selected_items && this_connexion.is_connected));
  gtk_widget_set_sensitive (remote_popup.xfer, (selected_items && this_connexion.is_connected));
  gtk_widget_set_sensitive (remote_popup.unselect, (selected_items && this_connexion.is_connected));
  gtk_widget_set_sensitive (remote_popup.undoselect, (selected_items && this_connexion.is_connected));
  gtk_widget_set_sensitive (remote_popup.view, (selected_items == 1 && this_connexion.is_connected));
  gtk_widget_set_sensitive (remote_popup.edit, (selected_items == 1 && this_connexion.is_connected));
  gtk_widget_set_sensitive (remote_popup.exec, (selected_items == 1 && this_connexion.is_connected));
  gtk_widget_set_sensitive (remote_popup.chmod, (selected_items && this_connexion.is_connected));
  gtk_widget_set_sensitive (remote_popup.ren, (selected_items == 1 && this_connexion.is_connected));
  gtk_widget_set_sensitive (remote_popup.move, (selected_items && this_connexion.is_connected));
  gtk_widget_set_sensitive (remote_popup.del, (selected_items && this_connexion.is_connected));
  gtk_widget_set_sensitive (remote_popup.chdir, (this_connexion.is_connected));
  gtk_widget_set_sensitive (remote_popup.mkdir, (this_connexion.is_connected));
  gtk_widget_set_sensitive (remote_popup.select, (this_connexion.is_connected));
  gtk_widget_set_sensitive (remote_popup.selectf, (this_connexion.is_connected));
  gtk_widget_set_sensitive (remote_popup_refresh, (this_connexion.is_connected));
  gtk_widget_set_sensitive (remote_select_menu, (this_connexion.is_connected));
  gtk_widget_set_sensitive (remote_sort_menu, (this_connexion.is_connected));
  /* in MAIN menu */
  gtk_widget_set_sensitive (menu_item_compare_dir, (this_connexion.is_connected));
  /* COMMANDS menu */
  update_commands_menu (selected_items);
}


void
remote_popup_menu_set_sensitive (char FLAG)
{
  gtk_widget_set_sensitive (remote_popup.queue, FLAG);
  gtk_widget_set_sensitive (remote_popup.xfer, FLAG);
  gtk_widget_set_sensitive (remote_popup.unselect, FLAG);
  gtk_widget_set_sensitive (remote_popup.undoselect, FLAG);
  gtk_widget_set_sensitive (remote_popup.view, FLAG);
  gtk_widget_set_sensitive (remote_popup.edit, FLAG);
  gtk_widget_set_sensitive (remote_popup.exec, FLAG);
  gtk_widget_set_sensitive (remote_popup.chmod, FLAG);
  gtk_widget_set_sensitive (remote_popup.ren, FLAG);
  gtk_widget_set_sensitive (remote_popup.move, FLAG);
  gtk_widget_set_sensitive (remote_popup.del, FLAG);
  gtk_widget_set_sensitive (remote_popup.chdir, FLAG);
  gtk_widget_set_sensitive (remote_popup.mkdir, FLAG);
  gtk_widget_set_sensitive (remote_popup.select, FLAG);
  gtk_widget_set_sensitive (remote_popup.selectf, FLAG);
  gtk_widget_set_sensitive (remote_select_menu, FLAG);
  gtk_widget_set_sensitive (remote_sort_menu, FLAG);
}


void
update_remote_popup_menu_sort (void)
{
  switch (remote_clist_sort)
    {
    default:
    case SORT_BY_NAME:
      gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (remote_popup.menu_radio_sort_by_name), TRUE);
      break;
    case SORT_BY_SIZE:
      gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (remote_popup.menu_radio_sort_by_size), TRUE);
      break;
    case SORT_BY_DATE:
      gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (remote_popup.menu_radio_sort_by_date), TRUE);
      break;
    case SORT_BY_PERM:
      gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (remote_popup.menu_radio_sort_by_perm), TRUE);
      break;
    case SORT_BY_UID:
      gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (remote_popup.menu_radio_sort_by_uid), TRUE);
      break;
    case SORT_BY_GID:
      gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (remote_popup.menu_radio_sort_by_gid), TRUE);
      break;
    }
}

void
update_remote_popup_menu_sort_type (void)
{
  if (remote_clist_sort_type == SORT_UP)
    gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (remote_popup.menu_radio_sort_up), TRUE);
  else
    gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (remote_popup.menu_radio_sort_down), TRUE);
}






/* SITE MANAGER Popup Menu */

/* PUBLIC :
 * create_sman_popup_menu
 * sman_popup_menu_set_sensitive
 */

GtkWidget *
create_sman_popup_menu (void)
{
  GtkWidget *menu = gtk_menu_new ();

  menu_tearoff (menu);

  menu_item_site_add = create_menu_item (menu, " Add Site ", FALSE, GTK_SIGNAL_FUNC (SMAN_site_add), NULL);
  menu_item_site_edit = create_menu_item (menu, " Edit Site ", FALSE, GTK_SIGNAL_FUNC (SMAN_site_edit), NULL);
  menu_item_site_copy = create_menu_item (menu, " Duplicate Site ", FALSE, GTK_SIGNAL_FUNC (SMAN_site_duplicate), NULL);
  menu_item_site_delete = create_menu_item (menu, " Delete Site ", FALSE, GTK_SIGNAL_FUNC (SMAN_site_delete_dialog), NULL);

  menu_separator (menu);

  menu_item_grp_add = create_menu_item (menu, " Add Group ", FALSE, GTK_SIGNAL_FUNC (SMAN_group_add_dialog), NULL);
  menu_item_grp_edit = create_menu_item (menu, " Edit Group ", FALSE, GTK_SIGNAL_FUNC (SMAN_group_edit_dialog), NULL);
  menu_item_grp_delete = create_menu_item (menu, " Delete Group ", FALSE, GTK_SIGNAL_FUNC (SMAN_group_delete_dialog), NULL);

  menu_separator (menu);
  menu_separator (menu);
  return menu;
}

void
sman_popup_menu_set_sensitive (char IS_ROOT, char IS_GROUP, char IS_SITE)
{
  gtk_widget_set_sensitive (menu_item_grp_edit, IS_GROUP);
  gtk_widget_set_sensitive (menu_item_grp_delete, IS_GROUP);
  gtk_widget_set_sensitive (menu_item_grp_add, (IS_GROUP || IS_ROOT || IS_SITE));
  gtk_widget_set_sensitive (menu_item_site_add, (IS_GROUP || IS_ROOT || IS_SITE));
  gtk_widget_set_sensitive (menu_item_site_edit, IS_SITE);
  gtk_widget_set_sensitive (menu_item_site_copy, IS_SITE);
  gtk_widget_set_sensitive (menu_item_site_delete, IS_SITE);
}






/* CONSOLE Popup Menu */

/* PUBLIC :
 * create_console_popup_menu
 * console_popup_menu_set_sensitive
 */

GtkWidget *
create_console_popup_menu (void)
{
  GtkWidget *menu = gtk_menu_new ();

  menu_tearoff (menu);

  menu_console_welcome_msg =
    create_menu_item (menu, " View Welcome message ", FALSE,
		      GTK_SIGNAL_FUNC (show_popup_window_message_from_widget), GINT_TO_POINTER (TRUE));
  menu_console_dir_msg =
    create_menu_item (menu, " View Directory message ", FALSE,
		      GTK_SIGNAL_FUNC (show_popup_window_message_from_widget), GINT_TO_POINTER (FALSE));

  menu_separator (menu);

  menu_console_connexion_log =
    create_menu_item (menu, " View Connexion Log ", FALSE, GTK_SIGNAL_FUNC (show_last_connexion_log), NULL);

  menu_separator (menu);
  menu_separator (menu);
  return menu;
}

void
console_popup_menu_set_sensitive (void)
{
  char WELCOME_MSG_FLAG = FALSE;
  char DIRECTORY_MSG_FLAG = FALSE;
  char buf[1024];
  if (this_connexion.is_connected)
    {
      WELCOME_MSG_FLAG = !access (RDC_welcome_message_path (buf), F_OK);
      DIRECTORY_MSG_FLAG = !access (RDC_directory_message_path (buf), F_OK);
    }
  gtk_widget_set_sensitive (menu_console_welcome_msg, WELCOME_MSG_FLAG);
  gtk_widget_set_sensitive (menu_console_dir_msg, DIRECTORY_MSG_FLAG);
  gtk_widget_set_sensitive (menu_console_connexion_log, !access (user_rc.lastlog_path, R_OK));
}






/* QUEUE Popup Menu */

/* PUBLIC :
 * create_queue_popup_menu
 * queue_popup_menu_set_sensitive
 */

GtkWidget *
create_queue_popup_menu (void)
{
  GtkWidget *menu = gtk_menu_new ();

  menu_tearoff (menu);

  menu_queue_add = create_menu_item (menu, " Add to Queue ", FALSE, GTK_SIGNAL_FUNC (QUEUE_add_selection), NULL);
  menu_queue_remove = create_menu_item (menu, " Remove from Queue ", FALSE, GTK_SIGNAL_FUNC (QUEUE_remove_selected), NULL);
  menu_queue_to_top = create_menu_item (menu, " Move to Top of Queue ", FALSE, GTK_SIGNAL_FUNC (QUEUE_move_to_top), NULL);
  menu_queue_to_bottom = create_menu_item (menu, " Move to Bottom of Queue ", FALSE, GTK_SIGNAL_FUNC (QUEUE_move_to_bottom), NULL);

  menu_separator (menu);
  create_menu_item (menu, " Load Queue ", TRUE, GTK_SIGNAL_FUNC (QUEUE_load_dialog), NULL);
  menu_queue_save = create_menu_item (menu, " Save Queue ", FALSE, GTK_SIGNAL_FUNC (QUEUE_save_as_dialog), NULL);

  menu_separator (menu);
  menu_queue_clear = create_menu_item (menu, " Clear Queue ", TRUE, GTK_SIGNAL_FUNC (QUEUE_clear), NULL);

  menu_separator (menu);
  menu_queue_info = create_menu_item (menu, " Queue Info ", TRUE, GTK_SIGNAL_FUNC (QUEUE_show_info), NULL);
  menu_queue_xfer_log = create_menu_item (menu, " View Transfer Log ", FALSE, GTK_SIGNAL_FUNC (QUEUE_xfer_show_log), NULL);

  menu_separator (menu);
  menu_queue_xfer = create_menu_item (menu, " Transfer Queue ", FALSE, GTK_SIGNAL_FUNC (QUEUE_xfer), NULL);

  menu_separator (menu);
  menu_separator (menu);
  return menu;
}


void
queue_popup_menu_set_sensitive (void)
{
  gint local_selected_items = local_selection_info ();
  gint remote_selected_items = remote_selection_info ();
  gint queue_selected_items = queue_selection_info ();
  gint Qentries = are_there_entries_in_queue ();

  gtk_widget_set_sensitive (menu_queue_add, (remote_selected_items || local_selected_items) && this_connexion.is_connected);
  gtk_widget_set_sensitive (menu_queue_to_top, queue_selected_items);
  gtk_widget_set_sensitive (menu_queue_to_bottom, queue_selected_items);
  gtk_widget_set_sensitive (menu_queue_remove, queue_selected_items);
  gtk_widget_set_sensitive (menu_queue_save, Qentries);
  gtk_widget_set_sensitive (menu_queue_clear, Qentries);
  gtk_widget_set_sensitive (menu_queue_info, Qentries);
  gtk_widget_set_sensitive (menu_queue_xfer, Qentries);
  gtk_widget_set_sensitive (menu_queue_xfer_log, QUEUE_xfer_has_log ());

  toolbar_queue_buttons_set_sensitive (Qentries);
}





/* MAIN Menu */

/* PUBLIC :
 * menu_set_check_idle 
 * menu_set_connect
 * menu_set_smanager
 * menu_set_toolbar_style
 * create_main_menu 
 * update_view_local_remote_menu
 * bookmark_menu_set_sensitive
 * STATIC:
 * update_commands_menu
 */

void
menu_set_check_idle (char this_state)
{
  gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (check_idle), this_state);
}

void
menu_set_connect (void)
{
  gtk_widget_set_sensitive (menu_item_connect, !this_connexion.is_connected);
  gtk_widget_set_sensitive (menu_item_reconnect, this_connexion.is_connected || USER_WAS_CONNECTED);
  gtk_widget_set_sensitive (menu_item_disconnect, this_connexion.is_connected);
  gtk_widget_set_sensitive (menu_item_spawn_session, this_connexion.is_connected);
}

void
menu_set_smanager (char FLAG)
{
  gtk_widget_set_sensitive (menu_item_smanager, FLAG);
}


void
menu_set_toolbar_style (char FLAG)
{
  gtk_widget_set_sensitive (menu_radio_toolbar_both, FLAG);
  gtk_widget_set_sensitive (menu_radio_toolbar_icons, FLAG);
  gtk_widget_set_sensitive (menu_radio_toolbar_text, FLAG);
}



void
create_main_menu (GtkWidget * vbox)
{
  GtkWidget *menu;
  GtkWidget *menu_in_menu;
  GtkWidget *handle_box;
  GtkWidget *menu_bar;
  GtkWidget *sub_menu;
  GtkWidget *menu_item;
  GtkAccelGroup *accel_ = gtk_accel_group_get_default ();

#define MAIN_ACCEL(x,y,z)  gtk_widget_add_accelerator (x, "activate", accel_, y, z, GTK_ACCEL_VISIBLE );

  this_handle_box = handle_box = gtk_handle_box_new ();
  gtk_box_pack_start (GTK_BOX (vbox), handle_box, FALSE, FALSE, 0);
  gtk_widget_show (handle_box);

  menu_bar = gtk_menu_bar_new ();
  gtk_container_add (GTK_CONTAINER (handle_box), menu_bar);
  gtk_widget_show (menu_bar);


  /* FTP menu */
  menu = create_sub_menu (menu_bar, "FTP ", FALSE);


  menu_tearoff (menu);
  menu_item_connect = create_menu_item (menu, " Connect ", TRUE, GTK_SIGNAL_FUNC (IGLOO_login), NULL);
  MAIN_ACCEL (menu_item_connect, 'C', GDK_CONTROL_MASK);
  menu_separator (menu);
  menu_item_disconnect = create_menu_item (menu, " Disconnect ", FALSE, GTK_SIGNAL_FUNC (IGLOO_logoff), NULL);
  MAIN_ACCEL (menu_item_disconnect, 'X', GDK_CONTROL_MASK);
  menu_item_reconnect = create_menu_item (menu, " Reconnect ", FALSE, GTK_SIGNAL_FUNC (IGLOO_connect_or_reconnect), NULL);
  MAIN_ACCEL (menu_item_reconnect, 'R', GDK_CONTROL_MASK);
  menu_separator (menu);
  create_menu_item (menu, " New Session ", TRUE, GTK_SIGNAL_FUNC (new_session_from_widget), NULL);
  menu_item_spawn_session = create_menu_item (menu, " Spawn Session ", TRUE, GTK_SIGNAL_FUNC (spawn_session_from_widget), NULL);
  menu_separator (menu);
  menu_in_menu = create_menu_in_menu (menu, " Settings");
  create_menu_item (menu_in_menu, "Preferences ...  ", TRUE, GTK_SIGNAL_FUNC (custom_notebook), NULL);
  create_menu_item (menu_in_menu, "Text-files Extension ...  ", TRUE, GTK_SIGNAL_FUNC (text_ext_dialog), NULL);
  menu_separator (menu_in_menu);
  menu_separator (menu_in_menu);

  menu_separator (menu);
  menu_item = create_menu_item (menu, " Exit ", TRUE, GTK_SIGNAL_FUNC (main_quit), NULL);
  MAIN_ACCEL (menu_item, 'Q', GDK_CONTROL_MASK);
  menu_separator (menu);
  menu_separator (menu);


  /* BOOKMARKS menu */
  menu = create_sub_menu (menu_bar, "Bookmarks ", FALSE);

  menu_tearoff (menu);
  menu_item_smanager = create_menu_item (menu, " Site Manager ", TRUE,
			     GTK_SIGNAL_FUNC (switch_smanager_panel), NULL);
  MAIN_ACCEL (menu_item_smanager, GDK_F4, 0);
  menu_separator (menu);
  menu_item_bookmark_add = create_menu_item (menu, " Add Site    ", FALSE,
			 GTK_SIGNAL_FUNC (SMAN_bookmark_site_dialog), NULL);
  menu_item_bookmark_edit = create_menu_item (menu, " Edit Site    ", FALSE,
			   GTK_SIGNAL_FUNC (SMAN_bookmark_site_edit), NULL);
  menu_separator (menu);

  menu_item_bookmark_save_local_path = create_menu_item (menu, " Save Local Path    ", FALSE,
		      GTK_SIGNAL_FUNC (SMAN_bookmark_save_local_dir), NULL);
  menu_item_bookmark_save_remote_path = create_menu_item (menu, " Save Remote Path    ", FALSE,
		     GTK_SIGNAL_FUNC (SMAN_bookmark_save_remote_dir), NULL);
  menu_separator (menu);
  menu_separator (menu);



  /* LOCAL Menu */
  local_popup_menu = create_local_popup_menu ();
  /* REMOTE Menu */
  remote_popup_menu = create_remote_popup_menu ();


  /* COMMANDS Menu */
  menu = create_sub_menu (menu_bar, "Commands  ", FALSE);

  menu_tearoff (menu);
  menu_commands_download = create_menu_item (menu, " Download", FALSE, GTK_SIGNAL_FUNC (download_selection), NULL);
  MAIN_ACCEL (menu_commands_download, GDK_Page_Down, GDK_CONTROL_MASK);
  menu_commands_upload = create_menu_item (menu, " Upload", FALSE, GTK_SIGNAL_FUNC (upload_selection), NULL);
  MAIN_ACCEL (menu_commands_upload, GDK_Page_Up, GDK_CONTROL_MASK);
  menu_commands_view = create_menu_item (menu, " View", FALSE, GTK_SIGNAL_FUNC (FOCUS_LIST_view_file), NULL);
  MAIN_ACCEL (menu_commands_view, 'V', GDK_CONTROL_MASK);
  menu_commands_edit = create_menu_item (menu, " Edit", FALSE, GTK_SIGNAL_FUNC (FOCUS_LIST_edit_file), NULL);
  menu_commands_execute = create_menu_item (menu, " Execute", FALSE, GTK_SIGNAL_FUNC (FOCUS_LIST_exec), NULL);
  MAIN_ACCEL (menu_commands_execute, 'E', GDK_CONTROL_MASK);
  menu_separator (menu);
  menu_commands_get_link = create_menu_item (menu, " Download link as file", FALSE, GTK_SIGNAL_FUNC (nop), NULL);
  menu_commands_manual_get = create_menu_item (menu, " Manual Download", FALSE, GTK_SIGNAL_FUNC (nop), NULL);
  menu_separator (menu);
  menu_commands_delete = create_menu_item (menu, " Delete", FALSE, GTK_SIGNAL_FUNC (FOCUS_LIST_delete), NULL);
  MAIN_ACCEL (menu_commands_delete, GDK_Delete, GDK_CONTROL_MASK);
  menu_commands_rename = create_menu_item (menu, " Rename", FALSE, GTK_SIGNAL_FUNC (FOCUS_LIST_rename), NULL);
  MAIN_ACCEL (menu_commands_rename, 'N', GDK_CONTROL_MASK);
  menu_commands_move = create_menu_item (menu, " Move", FALSE, GTK_SIGNAL_FUNC (FOCUS_LIST_move), NULL);
  menu_commands_cd = create_menu_item (menu, " Change directory", FALSE, GTK_SIGNAL_FUNC (FOCUS_LIST_chdir), NULL);
  MAIN_ACCEL (menu_commands_cd, 'D', GDK_CONTROL_MASK);
  menu_commands_mkdir = create_menu_item (menu, " Make new directory     ", FALSE, GTK_SIGNAL_FUNC (FOCUS_LIST_mkdir), NULL);
  MAIN_ACCEL (menu_commands_mkdir, 'M', GDK_CONTROL_MASK);
  menu_separator (menu);
  menu_item = create_menu_item (menu, " Stop/Abort", TRUE, GTK_SIGNAL_FUNC (IGLOO_abort), NULL);
  MAIN_ACCEL (menu_item, GDK_F9, 0);
  menu_separator (menu);
  menu_separator (menu);


  /* QUEUE Menu */
  sub_menu = gtk_menu_item_new_with_label ("Queue  ");
  gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), sub_menu);
  gtk_widget_show (sub_menu);
  queue_popup_menu = create_queue_popup_menu ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (sub_menu), queue_popup_menu);


  /* TOOLS Menu */
  //#define TOOL_MASK GDK_MOD1_MASK
#define TOOL_MASK GDK_SHIFT_MASK
  menu = create_sub_menu (menu_bar, "Tools ", FALSE);

  menu_tearoff (menu);
  menu_item = create_menu_item (menu, " Web Browser     ", TRUE, GTK_SIGNAL_FUNC (open_URL_from_widget), NULL);
  MAIN_ACCEL (menu_item, 'W', TOOL_MASK);
  menu_item = create_menu_item (menu, " Email Client ", TRUE, GTK_SIGNAL_FUNC (open_mail_client), NULL);
  MAIN_ACCEL (menu_item, 'M', TOOL_MASK);
  menu_item = create_menu_item (menu, " Email Editor ", TRUE, GTK_SIGNAL_FUNC (open_new_message), NULL);
  MAIN_ACCEL (menu_item, 'S', TOOL_MASK);
  menu_item = create_menu_item (menu, " News Client ", TRUE, GTK_SIGNAL_FUNC (open_news_client), NULL);
  MAIN_ACCEL (menu_item, 'N', TOOL_MASK);
  menu_separator (menu);
  menu_item = create_menu_item (menu, " Text Editor ", TRUE, GTK_SIGNAL_FUNC (text_edit_from_widget), NULL);
  MAIN_ACCEL (menu_item, 'E', TOOL_MASK);
  menu_separator (menu);
  menu_item = create_menu_item (menu, " XTerm ", TRUE, GTK_SIGNAL_FUNC (Xterm), NULL);
  MAIN_ACCEL (menu_item, 'X', TOOL_MASK);
  menu_separator (menu);
  menu_item = create_menu_item (menu, " Execute ... ", TRUE, GTK_SIGNAL_FUNC (execute_usr_command_dialog), NULL);
  MAIN_ACCEL (menu_item, 'R', TOOL_MASK);
  menu_separator (menu);
  menu_separator (menu);

  /* VIEW  Menu */
  menu = create_sub_menu (menu_bar, "View ", FALSE);

  menu_tearoff (menu);

  menu_in_menu = create_menu_in_menu (menu, "Window size/position ...");
  check_layout_autosave = create_check_menu_item (menu_in_menu, "Auto-Save     ", layout_autosave, layout_set_autosave);
  menu_separator (menu_in_menu);
  create_menu_item (menu_in_menu, "Save  ", TRUE, GTK_SIGNAL_FUNC (layout_save_from_widget), NULL);
  create_menu_item (menu_in_menu, "Load saved", TRUE, GTK_SIGNAL_FUNC (layout_reload), NULL);
  create_menu_item (menu_in_menu, "Reset default", TRUE, GTK_SIGNAL_FUNC (layout_reset), NULL);
  menu_separator (menu_in_menu);
  menu_separator (menu_in_menu);

  menu_separator (menu);

  menu_in_menu = create_menu_in_menu (menu, "Toolbar ...");
  create_check_menu_item (menu_in_menu, "View      ", user_rc.view_toolbar, show_or_hide_toolbar);
  menu_separator (menu_in_menu);
  menu_radio_toolbar_both = create_menu_radio_item (menu_in_menu, NULL, "Icons AND  Text", toolbar_set_style,
						    GINT_TO_POINTER (GTK_TOOLBAR_BOTH), user_rc.toolbar_style == GTK_TOOLBAR_BOTH);
  menu_radio_toolbar_icons = create_menu_radio_item (menu_in_menu, menu_radio_toolbar_both, "Icons only", toolbar_set_style,
						     GINT_TO_POINTER (GTK_TOOLBAR_ICONS), user_rc.toolbar_style == GTK_TOOLBAR_ICONS);
  menu_radio_toolbar_text = create_menu_radio_item (menu_in_menu, menu_radio_toolbar_icons, "Text only", toolbar_set_style,
						    GINT_TO_POINTER (GTK_TOOLBAR_TEXT), user_rc.toolbar_style == GTK_TOOLBAR_TEXT);
  menu_separator (menu_in_menu);
  menu_separator (menu_in_menu);

  menu_separator (menu);
  create_check_menu_item (menu, "View QuickConnect", user_rc.view_connectbar, show_or_hide_connectbar);
  check_menu_view_local = create_check_menu_item (menu, "View Local Panel", TRUE, show_or_hide_dir_panel);
  MAIN_ACCEL (check_menu_view_local, GDK_F6, 0);
  check_menu_view_remote = create_check_menu_item (menu, "View Remote Panel", TRUE, show_or_hide_ftp_panel);
  MAIN_ACCEL (check_menu_view_remote, GDK_F7, 0);
  menu_item = create_check_menu_item (menu, "View Queue", user_rc.view_queue, show_or_hide_queue);
  MAIN_ACCEL (menu_item, GDK_F10, 0);
  menu_item = create_check_menu_item (menu, "View Log Window", user_rc.view_console, show_or_hide_console);
  MAIN_ACCEL (menu_item, GDK_F12, 0);
  create_check_menu_item (menu, "View Shell Prompt", user_rc.view_shell_prompt, show_or_hide_shell_prompt);
  create_check_menu_item (menu, "View Host Prompt", user_rc.view_ftp_prompt, show_or_hide_ftp_prompt);

  menu_separator (menu);
  create_check_menu_item (menu, "Show Hidden Local Files  ", !dirlist_hide_hidden, toggle_local_hidden);
  create_check_menu_item (menu, "Show Hidden Remote Files  ", !ftplist_hide_hidden, toggle_remote_hidden);
  menu_separator (menu);
  menu_commands_refresh = create_menu_item (menu, " Refresh", FALSE, GTK_SIGNAL_FUNC (FOCUS_LIST_refresh), NULL);
  MAIN_ACCEL (menu_commands_refresh, GDK_F5, 0);
  menu_separator (menu);
  menu_separator (menu);



  /* DIRECTORY Menu */
  menu = create_sub_menu (menu_bar, "Directory ", FALSE);

  menu_tearoff (menu);
  menu_item = create_menu_item (menu, " Find    ", TRUE, GTK_SIGNAL_FUNC (FOCUS_LIST_find), NULL);
  MAIN_ACCEL (menu_item, 'F', GDK_CONTROL_MASK);
  menu_item = create_menu_item (menu, " Find next ", TRUE, GTK_SIGNAL_FUNC (FOCUS_LIST_find_next), NULL);
  MAIN_ACCEL (menu_item, 'G', GDK_CONTROL_MASK);
  menu_separator (menu);
  menu_item = create_menu_item (menu, " Filter", TRUE, GTK_SIGNAL_FUNC (FOCUS_LIST_filter), NULL);
  MAIN_ACCEL (menu_item, 'L', GDK_CONTROL_MASK);
  menu_separator (menu);
  menu_item = create_menu_item (menu, " Group select ", TRUE, GTK_SIGNAL_FUNC (FOCUS_LIST_group_select), NULL);;
  menu_item = create_menu_item (menu, " Group deselect ", TRUE, GTK_SIGNAL_FUNC (FOCUS_LIST_group_deselect), NULL);
  menu_item = create_menu_item (menu, " Invert selection ", TRUE, GTK_SIGNAL_FUNC (FOCUS_LIST_invert_selection), NULL);
  menu_separator (menu);
  menu_item = create_menu_item (menu, " Directory Info ", TRUE, GTK_SIGNAL_FUNC (FOCUS_LIST_dir_info), NULL);
  MAIN_ACCEL (menu_item, GDK_F8, 0);
  menu_item_compare_dir = create_menu_item (menu, " Compare Directories ", FALSE, GTK_SIGNAL_FUNC (FOCUS_LIST_compare_windows), NULL);
  MAIN_ACCEL (menu_item_compare_dir, GDK_F11, 0);
  menu_separator (menu);
  menu_separator (menu);


  /* OPTIONS Menu */
  menu = create_sub_menu (menu_bar, "Options ", FALSE);

  menu_tearoff (menu);
  create_check_menu_item (menu, "Enable RDC  ", this_session.use_RDC, toggle_RDC);
  create_check_menu_item (menu, "Resolve links  ", this_session.resolve_link, toggle_resolve_links);
  check_idle = create_check_menu_item (menu, "Anti-Idle", anti_idle, toggle_anti_idle);
  menu_separator (menu);
  menu_item = create_menu_item (menu, "Preferences ...  ", TRUE, GTK_SIGNAL_FUNC (custom_notebook), NULL);
  menu_separator (menu);
  menu_separator (menu);


  /* ALPHA Menu */
  menu_item = gtk_menu_item_new_with_label ("*** ALPHA version ***");
  gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), menu_item);
  gtk_widget_show (menu_item);
  gtk_widget_set_sensitive (menu_item, FALSE);


  /* HELP Menu */
  menu = create_sub_menu (menu_bar, "Help ", TRUE);

  menu_tearoff (menu);
  create_menu_item (menu, " About  ", TRUE, GTK_SIGNAL_FUNC (create_about_window), NULL);
  menu_separator (menu);
  create_menu_item (menu, " What's New?  ", TRUE, GTK_SIGNAL_FUNC (doc_show_text_file_from_widget), GINT_TO_POINTER (DOC_CHANGES));
  menu_separator (menu);
  create_menu_item (menu, " Readme  ", TRUE, GTK_SIGNAL_FUNC (doc_show_text_file_from_widget), GINT_TO_POINTER (DOC_README));
  create_menu_item (menu, " Support  ", TRUE, GTK_SIGNAL_FUNC (open_URL_from_widget), strdup (SUPPORT_URL));
  create_menu_item (menu, " Get Last Version  ", TRUE, GTK_SIGNAL_FUNC (open_URL_from_widget), strdup (VERSION_URL));
  menu_separator (menu);
  create_menu_item (menu, " License  ", TRUE, GTK_SIGNAL_FUNC (doc_show_text_file_from_widget), GINT_TO_POINTER (DOC_COPYING));
  menu_separator (menu);
  menu_separator (menu);
}


void
bookmark_menu_set_sensitive (void)
{
  gtk_widget_set_sensitive (menu_item_bookmark_add, (this_connexion.is_connected && !USER_CONNECT_VIA_SITE_MANAGER));
  gtk_widget_set_sensitive (menu_item_bookmark_edit, (this_connexion.is_connected && USER_CONNECT_VIA_SITE_MANAGER));
  gtk_widget_set_sensitive (menu_item_bookmark_save_local_path, (this_connexion.is_connected && USER_CONNECT_VIA_SITE_MANAGER));
  gtk_widget_set_sensitive (menu_item_bookmark_save_remote_path, (this_connexion.is_connected && USER_CONNECT_VIA_SITE_MANAGER));

}


static void
update_commands_menu (gint selected_items)
{
#define IS_REMOTE_FOCUS (PANEL_FOCUS == REMOTE_FOCUS)
  char must_be_connected = IS_REMOTE_FOCUS ? this_connexion.is_connected : TRUE;

  gtk_widget_set_sensitive (menu_commands_download, IS_REMOTE_FOCUS && (selected_items && this_connexion.is_connected));
  gtk_widget_set_sensitive (menu_commands_upload, !IS_REMOTE_FOCUS && (selected_items && this_connexion.is_connected));

  gtk_widget_set_sensitive (menu_commands_view, (selected_items == 1 && must_be_connected));
  gtk_widget_set_sensitive (menu_commands_edit, (selected_items == 1 && must_be_connected));
  gtk_widget_set_sensitive (menu_commands_execute, (selected_items == 1 && must_be_connected));

  gtk_widget_set_sensitive (menu_commands_get_link, IS_REMOTE_FOCUS && (selected_items == 1 && this_connexion.is_connected));
  gtk_widget_set_sensitive (menu_commands_manual_get, (this_connexion.is_connected));

  gtk_widget_set_sensitive (menu_commands_delete, (selected_items && must_be_connected));
  gtk_widget_set_sensitive (menu_commands_rename, (selected_items == 1 && must_be_connected));
  gtk_widget_set_sensitive (menu_commands_move, (selected_items && must_be_connected));
  gtk_widget_set_sensitive (menu_commands_cd, (must_be_connected));
  gtk_widget_set_sensitive (menu_commands_mkdir, (must_be_connected));

  gtk_widget_set_sensitive (menu_commands_refresh, (must_be_connected));
}

void
update_view_local_remote_menu (void)
{
  gtk_widget_set_sensitive (check_menu_view_local, GTK_CHECK_MENU_ITEM (check_menu_view_remote)->active);
  gtk_widget_set_sensitive (check_menu_view_remote, GTK_CHECK_MENU_ITEM (check_menu_view_local)->active);
}





/* MENU COMMON functions
 * PUBLIC :
 * menu_separator
 * menu_tearoff
 * create_sub_menu
 * create_menu_item
 * STATIC :
 * create_check_menu_item
 */

void
menu_separator (GtkWidget * menu)
{
  GtkWidget *menu_item = gtk_menu_item_new ();
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_widget_set_sensitive (menu_item, FALSE);
  gtk_widget_show (menu_item);
}

void
menu_tearoff (GtkWidget * menu)
{
  GtkWidget *menu_item = gtk_tearoff_menu_item_new ();
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_widget_set_sensitive (menu_item, FALSE);
  gtk_widget_show (menu_item);
}

GtkWidget *
create_sub_menu (GtkWidget * menu_bar, char *label, char RIGTH_JUSTIFY)
{
  GtkWidget *sub_menu = gtk_menu_item_new_with_label (label);
  GtkWidget *menu = gtk_menu_new ();
  gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), sub_menu);
  gtk_widget_show (sub_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (sub_menu), menu);
  if (RIGTH_JUSTIFY)
    gtk_menu_item_right_justify (GTK_MENU_ITEM (sub_menu));
  return menu;
}

GtkWidget *
create_menu_item (GtkWidget * menu, gchar * label, gint sensitive_flag,
		  GtkSignalFunc this_func, gpointer this_func_data)
{
  GtkWidget *menu_item = gtk_menu_item_new_with_label (label);
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_widget_set_sensitive (menu_item, sensitive_flag);
  gtk_widget_show (menu_item);
  gtk_signal_connect (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (this_func), this_func_data);
  return menu_item;
}


static GtkWidget *
create_check_menu_item (GtkWidget * menu, gchar * label, gint state_flag,
			GtkSignalFunc this_func)
{
  GtkWidget *menu_item = gtk_check_menu_item_new_with_label (label);
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (menu_item), state_flag);
  gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (menu_item), TRUE);
  gtk_widget_show (menu_item);
  gtk_signal_connect_object (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (this_func), GTK_OBJECT (menu_item));
  return menu_item;
}


static GtkWidget *
create_menu_radio_item (GtkWidget * menu, GtkWidget * last_radio, gchar * label,
	  GtkSignalFunc this_func, gpointer this_func_data, gint state_flag)
{
  GtkWidget *menu_item;
  if (last_radio == NULL)
    menu_item = gtk_radio_menu_item_new_with_label (NULL, label);
  else
    menu_item = gtk_radio_menu_item_new_with_label (LAST_MENU_RADIO (last_radio), label);
  gtk_menu_append (GTK_MENU (menu), menu_item);
  //gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (menu_item), TRUE);
  gtk_widget_show (menu_item);
  gtk_signal_connect (GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (this_func), this_func_data);
  if (state_flag)
    gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (menu_item), state_flag);

  return menu_item;
}


static GtkWidget *
create_menu_in_menu (GtkWidget * menu, gchar * label)
{
  GtkWidget *menu_item = gtk_menu_item_new_with_label (label);
  GtkWidget *menu_in_menu = gtk_menu_new ();
  gtk_menu_append (GTK_MENU (menu), menu_item);
  gtk_widget_show (menu_item);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_item), menu_in_menu);
  return menu_in_menu;
}



/* EOF */
