/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "protos.h"






void
main_quit (GtkWidget * widget, int *data)
{
  if (this_connexion.is_connected)
    IGLOO_logoff (TRUE);

#ifdef DEBUG_LOG
  close_user_debuglog ();
#endif

  clean_user_folders ();

  SMAN_save_bookmarks_file ();
  QUEUE_save_current ();
  save_combo_host_history ();

  if (layout_autosave)
    layout_save (FALSE);

  gtk_main_quit ();
}



void
set_main_title (void)
{
  char title_buf[512];
  if (this_connexion.is_connected)
    sprintf (title_buf, "IglooFTP - %s [%s]", this_connexion.hostname, USE_FIREWALL ? "Firewall" : this_connexion.connect_address);
  else
    strcpy (title_buf, "IglooFTP");
  gtk_window_set_title (GTK_WINDOW (window), title_buf);
}



void
startup_message (char *this_message)
{
  if (startup_window == NULL)
    return;
  gtk_label_set (GTK_LABEL (startup_label), this_message);
  gdk_window_raise (startup_window->window);
  PROCESS_EVENTS;

  DEBUG (this_message);
}



static gint
destroy_startup_window (gpointer data)
{
  gtk_widget_destroy (startup_window);
  startup_window = NULL;
  return FALSE;
}








int
main (int argc, char *argv[])
{
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *vbox1;
  char IS_SPAWNED = FALSE;
  register int f;

  gtk_set_locale ();
  gtk_init (&argc, &argv);


  for (f = 1; f < argc; f++)
    {
      if (strstr (argv[f], SPAWN_ARG))
	IS_SPAWNED = TRUE;
    }




  create_startup_window ();

  strcpy (prg_path, argv[0]);
  getcwd (prg_start_dir, sizeof (prg_start_dir));

  {
    char buf[MPLEN];
    char *ptr;
    startup_message ("Finding home directory ...");
    if ((ptr = getenv ("HOME")) == NULL)
      {
	printf ("Can't get Environment Variable HOME... Abording.\n");
	exit (1);
      }
    else
      strcpy (home_path, ptr);


    DEBUG ("IGLOOftp : HOME IS");
    DEBUG (home_path);

    startup_message ("Parsing gtkrc file ...");
    sprintf (buf, "%s%s", SHARE_PATH, "/gtkrc");
    if (access (buf, R_OK))
      sprintf (buf, "%s%s", home_path, "/.gtkrc");
    gtk_rc_parse (buf);
  }



  init_user_folders ();
  init_user_configuration_files ();

  startup_message ("Loading user preferences ...");
  init_rc ();

  startup_message ("Loading bookmarks file ...");
  SMAN_parse_bookmarks_file ();

  startup_message ("Loading layout ini file ...");
  window = NULL;
  layout_load ();

  startup_message ("Loading text-files extensions ini file ...");
  text_ext_read ();

  startup_message ("Initialization ...");
  dirlist_hide_hidden = user_rc.dirlist_hide_hidden;
  ftplist_hide_hidden = user_rc.ftplist_hide_hidden;
  local_clist_sort = SORT_BY_NAME;
  local_clist_sort_type = SORT_DOWN;
  remote_clist_sort = SORT_BY_NAME;
  remote_clist_sort_type = SORT_DOWN;
  anti_idle = user_rc.idle;
  recv_buf_len = user_rc.recv_buffer;
  send_buf_len = user_rc.send_buffer;
  want_abort = FALSE;
  USER_WAS_CONNECTED = FALSE;
  USER_CONNECT_VIA_SITE_MANAGER = FALSE;
  USER_CONNECT_VIA_URL = FALSE;
  MUST_SHOW_FTP_DIRECTORY_MESSAGE = FALSE;
  is_smanager_visible = FALSE;
  PANEL_FOCUS = LOCAL_FOCUS;
  REXEC = NULL;
  IGLOO_default_session ();



  startup_message ("Creating Main Window ...");
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "IglooFTP");
  gtk_container_border_width (GTK_CONTAINER (window), 0);
  gtk_window_set_policy (GTK_WINDOW (window), TRUE, TRUE, FALSE);
  gtk_widget_realize (window);


  gtk_signal_connect (GTK_OBJECT (window), "delete_event", (GtkSignalFunc) main_quit, NULL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy", (GtkSignalFunc) main_quit, NULL);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox);
  gtk_widget_show (vbox);


  startup_message ("Creating Main Menu ...");
  create_main_menu (vbox);

  startup_message ("Creating Toolbar ...");
  create_toolbar (window, vbox);

  startup_message ("Creating FastConnect bar ...");
  create_connect_bar (vbox);



  top_panel = gtk_vpaned_new ();
  gtk_widget_show (top_panel);


  startup_message ("Creating Console Window ...");
  gtk_paned_add1 (GTK_PANED (top_panel), create_consolelist ());


  clist_panel = gtk_hpaned_new ();
  gtk_widget_show (clist_panel);

  startup_message ("Creating Local Panel ...");
  gtk_paned_add1 (GTK_PANED (clist_panel), create_dirlist ());

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);

  startup_message ("Creating Remote Panel ...");
  gtk_box_pack_start (GTK_BOX (vbox1), create_ftplist (), TRUE, TRUE, 0);

  startup_message ("Creating Site Manager ...");
  gtk_box_pack_start (GTK_BOX (vbox1), create_smanager (), TRUE, TRUE, 0);

  gtk_paned_add2 (GTK_PANED (clist_panel), vbox1);

  gtk_paned_add2 (GTK_PANED (top_panel), clist_panel);

  main_panel = gtk_vpaned_new ();
  gtk_widget_show (main_panel);

  gtk_paned_add1 (GTK_PANED (main_panel), top_panel);

  startup_message ("Creating Queue Window ...");
  gtk_paned_add2 (GTK_PANED (main_panel), create_queuelist ());




  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);
  gtk_box_pack_start (GTK_BOX (hbox), main_panel, TRUE, TRUE, 2);

  gtk_box_pack_start (GTK_BOX (vbox), create_status_bar (), FALSE, TRUE, 2);



  set_window_icon (window);

  startup_message ("Showing Main Window ...");
  layout_realize ();
  gtk_widget_show (window);
  PROCESS_EVENTS;

  gdk_window_raise (startup_window->window);
  gtk_window_set_transient_for (GTK_WINDOW (startup_window), GTK_WINDOW (window));
  PROCESS_EVENTS;

  startup_message ("Showing Site Manager  ...");
  switch_smanager_panel ();
  toolbar_buttons_set_sensitive ();
  default_status_message ();
  set_default_drag_icon ();

  QUEUE_load_current ();

  startup_message ("Showing Copyright Message  ...");
  ftp_copyright ();

  startup_message ("Checking IglooFTP version  ...");
  check_new_prog_version ();

  startup_message ("All done.");
  gtk_timeout_add (1000, destroy_startup_window, NULL);


  if (IS_SPAWNED)
    IGLOO_load_session_and_connect ();


  gtk_main ();

  return 0;
}


/* EOF */
