/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "protos.h"
#include "log.h"







/*
 * LASTLOG functions
 * PUBLIC :
 * close_user_lastlog
 * lastlog
 * STATIC :
 * init_user_lastlog
 */

void
close_user_lastlog (void)
{
  if (user_lastlog != NULL)
    {
      fprintf (user_lastlog, "\n---\nLOG CLOSED.\n");
      fflush (user_lastlog);
      fclose (user_lastlog);
      user_lastlog = NULL;
    }
}


static void
init_user_lastlog (void)
{
  char this_buf[250];
  close_user_lastlog ();
  user_lastlog = fopen (user_rc.lastlog_path, "w");
  fprintf (user_lastlog, "%s\n", a_little_version_infos (this_buf));
  fprintf (user_lastlog, "%s\n", a_little_more_infos (this_buf));
  fprintf (user_lastlog, "%s\n---\n\n", yet_a_little_more_infos (this_buf));
}


void
lastlog (char *from_who, char *this_message)
{
  if (!strlen (this_message))
    return;

  if (user_lastlog == NULL)
    init_user_lastlog ();

  if (strrchr (this_message, '\n') != NULL)
    *(strrchr (this_message, '\n')) = 0;
  fprintf (user_lastlog, "%s : %s\n", from_who, this_message);
  fflush (user_lastlog);
}










/*
 * DEBUG_LOG functions
 * PUBLIC :
 * close_user_debuglog 
 * STATIC :
 * init_user_debuglog
 * debuglog
 */

#ifdef DEBUG_LOG

void
close_user_debuglog (void)
{
  if (user_debuglog != NULL)
    {
      fprintf (user_debuglog, "\n---\nDEBUG LOG CLOSED.\n");
      fflush (user_debuglog);
      fclose (user_debuglog);
      user_debuglog = NULL;
    }
}


static void
init_user_debuglog (void)
{
  char this_buf[250];
  time_t timep;
  struct tm *timeptr;

  close_user_debuglog ();
  user_debuglog = fopen (user_rc.debuglog_path, "w");
  if (user_debuglog == NULL)
    {
      char debuglog_path[1024];
      sprintf (debuglog_path, "%s/%s/%s", home_path, PREFERENCES_PATH, USER_DEBUGLOG);
      user_debuglog = fopen (debuglog_path, "w");
    }

  if (user_debuglog == NULL)
    return;
  fprintf (user_debuglog, "%s\n", a_little_version_infos (this_buf));
  fprintf (user_debuglog, "%s\n", a_little_more_infos (this_buf));
  fprintf (user_debuglog, "%s\n---\n", yet_a_little_more_infos (this_buf));

  timep = time (NULL);
  timeptr = localtime (&timep);
  strftime (this_buf, sizeof (this_buf), "%a %d %b %Y - %X", timeptr);

  fprintf (user_debuglog, "DEBUG LOG OPENED ON %s\n\n\n", this_buf);
}


void
debuglog (char *this_message)
{
  time_t timep;
  struct tm *timeptr;
  char time_buf[64];

  if (!strlen (this_message))
    return;

  if (user_debuglog == NULL)
    init_user_debuglog ();
  if (user_debuglog == NULL)
    return;

  if (this_message[strlen (this_message) - 1] == '\n')
    this_message[strlen (this_message) - 1] = 0;

  timep = time (NULL);
  timeptr = localtime (&timep);
  strftime (time_buf, sizeof (time_buf), "%X", timeptr);

  fprintf (user_debuglog, "[%s] %s\n", time_buf, this_message);

  fflush (user_debuglog);
}

#endif



/* EOF */
