/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */


#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>

#include "protos.h"


#define ON_PANEL_FOCUS  PANEL_FOCUS == LOCAL_FOCUS

/* COMMANDS Menu */

void
FOCUS_LIST_view_file (GtkWidget * widget, gpointer data)
{
  ON_PANEL_FOCUS ? local_file_view () : remote_file_view ();
}

void
FOCUS_LIST_edit_file (GtkWidget * widget, gpointer data)
{
  ON_PANEL_FOCUS ? local_file_edit () : remote_file_edit ();
}

void
FOCUS_LIST_exec (GtkWidget * widget, gpointer data)
{
  ON_PANEL_FOCUS ? local_exec () : nop ();
}

void
FOCUS_LIST_rename (GtkWidget * widget, gpointer data)
{
  ON_PANEL_FOCUS ? local_rename_dialog (NULL, NULL) : remote_rename_dialog (NULL, NULL);
}

void
FOCUS_LIST_delete (GtkWidget * widget, gpointer data)
{
  ON_PANEL_FOCUS ? local_delete_dialog (NULL, NULL) : remote_delete_dialog (NULL, NULL);
}

void
FOCUS_LIST_move (GtkWidget * widget, gpointer data)
{
  ON_PANEL_FOCUS ? local_move_dialog (NULL, NULL) : remote_move_dialog (NULL, NULL);
}

void
FOCUS_LIST_chdir (GtkWidget * widget, gpointer data)
{
  ON_PANEL_FOCUS ? local_change_directory_dialog (NULL, NULL) : remote_change_directory_dialog (NULL, NULL);
}

void
FOCUS_LIST_mkdir (GtkWidget * widget, gpointer data)
{
  ON_PANEL_FOCUS ? local_create_directory_dialog (NULL, NULL) : remote_create_directory_dialog (NULL, NULL);
}


/* DIRECTORY Menu */

void
FOCUS_LIST_invert_selection (GtkWidget * widget, gpointer data)
{
  ON_PANEL_FOCUS ? local_invert_selection (NULL, NULL) : remote_invert_selection (NULL, NULL);
}

void
FOCUS_LIST_find (GtkWidget * widget, gpointer data)
{
  ON_PANEL_FOCUS ? local_find_dialog (NULL, NULL) : remote_find_dialog (NULL, NULL);
}

void
FOCUS_LIST_find_next (GtkWidget * widget, gpointer data)
{
  ON_PANEL_FOCUS ? local_find_next_dialog (NULL, NULL) : remote_find_next_dialog (NULL, NULL);
}

void
FOCUS_LIST_group_select (GtkWidget * widget, gpointer data)
{
  ON_PANEL_FOCUS ? local_group_select_dialog (NULL, NULL) : remote_group_select_dialog (NULL, NULL);
}

void
FOCUS_LIST_group_deselect (GtkWidget * widget, gpointer data)
{
  ON_PANEL_FOCUS ? local_group_deselect_dialog (NULL, NULL) : remote_group_deselect_dialog (NULL, NULL);
}

void
FOCUS_LIST_filter (GtkWidget * widget, gpointer data)
{
  ON_PANEL_FOCUS ? local_filter_dialog (NULL, NULL) : remote_filter_dialog (NULL, NULL);
}

void
FOCUS_LIST_dir_info (GtkWidget * widget, gpointer data)
{
  ON_PANEL_FOCUS ? local_dir_info (NULL, NULL) : remote_dir_info (NULL, NULL);
}

void
FOCUS_LIST_compare_windows (GtkWidget * widget, gpointer data)
{
  ON_PANEL_FOCUS ? local_compare_directories (NULL, NULL) : remote_compare_directories (NULL, NULL);
}


/* VIEW MENU */
void
FOCUS_LIST_refresh (GtkWidget * widget, gpointer data)
{
  ON_PANEL_FOCUS ? refresh_dirlist () : refresh_ftplist ();
}







/* DIRLIST/FTPLIST SHARE  FUNCTIONS */



void
list_share_group_select_deselect (GtkWidget * widget, GRPSELECTwidgets * grp_widgets,
      GtkWidget * this_clist, int this_last_dir_row, int this_last_file_row)
{
  char REMOVE_SEL = GTK_TOGGLE_BUTTON (grp_widgets->check_remove)->active;
  char GROUP_SELECT = grp_widgets->select;
  char MASK_DIR = GTK_TOGGLE_BUTTON (grp_widgets->check_mask)->active;
  char search_buf[256];
  char search_type = 0;
  char *search_ptr = NULL;
  register int this_row;
  gchar *filename;


  strcpy (search_buf, gtk_entry_get_text (GTK_ENTRY (grp_widgets->entry)));
  gtk_widget_destroy (gtk_widget_get_toplevel (widget));

  search_type = FILTER_determine_search_type (search_buf, &search_ptr);

  gtk_clist_freeze (GTK_CLIST (this_clist));

  if (REMOVE_SEL && GROUP_SELECT)
    gtk_clist_unselect_all (GTK_CLIST (this_clist));

  for (this_row = MASK_DIR ? this_last_dir_row : 0; this_row < this_last_file_row; this_row++)
    {
      gtk_clist_get_text (GTK_CLIST (this_clist), this_row, 1, &filename);
      if (FILTER_is_string_match (search_type, filename, search_ptr))
	GROUP_SELECT ? gtk_clist_select_row (GTK_CLIST (this_clist), this_row, 0) : gtk_clist_unselect_row (GTK_CLIST (this_clist), this_row, 0);
    }

  gtk_clist_thaw (GTK_CLIST (this_clist));
  g_free (grp_widgets);
}



/* EOF */
