/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */


#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "protos.h"
#include "execute.h"





void
execute_program (char *program, char *arg)
{
  pid_t pid;

  pid = fork ();
  if (pid == 0)
    {
      pid = fork ();
      if (pid == 0)
	{
	  execlp (program, program, arg, NULL);
	  _exit (0);
	}
      else
	{
	  _exit (0);
	}
    }

}


static void
execute_command (char *command)
{
  pid_t pid;

  pid = fork ();
  if (pid == 0)
    {
      pid = fork ();
      if (pid == 0)
	{
	  system (command);
	  _exit (0);
	}
      else
	{
	  _exit (0);
	}
    }

}




void
REXEC_end (void)
{
  if (REXEC)
    {
      fprintf (REXEC, "end\n");
      fflush (REXEC);
    }
  IS_REXEC = FALSE;
}

static void
REXEC_execute_program (char *program, char *arg, char *filename)
{
  pid_t pid;
  char command_line[1024];
  sprintf (command_line, "%s %s", program, arg);

  pid = fork ();
  if (pid == 0)
    {
      system (command_line);
      REXEC_end ();
      _exit (0);
    }
}








/* ASSOCIATED APP  functions */

static char
find_associates_by_extension (char *file_extension, char *editor, char *viewer)
{
  FILE *assoc_file;
  char this_path[1024];
  char this_line[1024];
  char *ptr;
  char GOT_EXTENSION = FALSE;
  char GOT_EDITOR = FALSE;
  char GOT_VIEWER = FALSE;

#define FIELD_STRING strchr(this_line,'=')+1
#define GOT_ALL (GOT_EXTENSION && GOT_EDITOR && GOT_VIEWER)

  files_assoc_path (this_path);
  if ((assoc_file = fopen (this_path, "r")) == NULL)
    {
      alert_ok ("Error", "Can't read files association ini file.", "Ok");
      return TRUE;
    }


  while (fgets (this_line, sizeof (this_line), assoc_file) != NULL && !GOT_ALL)
    {
      if (this_line[strlen (this_line) - 1] == '\n')
	this_line[strlen (this_line) - 1] = 0;

      if (!strlen (this_line))
	continue;

      if (this_line[0] == '#')
	continue;

      if (this_line[0] == '[')
	{
	  if ((ptr = strrchr (this_line, ']')) != NULL)
	    *ptr = 32;

	  if (strstr (this_line, file_extension))
	    GOT_EXTENSION = TRUE;
	}

      if (strstr (this_line, "EDIT=") && GOT_EXTENSION)
	{
	  strcpy (editor, FIELD_STRING);
	  GOT_EDITOR = TRUE;
	  continue;
	}

      if (strstr (this_line, "VIEW=") && GOT_EXTENSION)
	{
	  strcpy (viewer, FIELD_STRING);
	  GOT_VIEWER = TRUE;
	  continue;
	}

    }

  fclose (assoc_file);
  return GOT_ALL;
}




void
execute_view_or_edit_file (char *filename, char WANT_EDIT, char IS_REMOTE)
{
  char editor[256];
  char viewer[256];
  char file_extension[32];
  char current_path[1024];
  char absolute_filename[1024];
  char *ptr;
  char *command_line;

  MEM0 (editor);
  MEM0 (viewer);
  MEM0 (file_extension);
  MEM0 (current_path);
  MEM0 (absolute_filename);

  IS_REXEC = IS_REMOTE;

  getcwd (current_path, sizeof (current_path));


  if ((ptr = strrchr (filename, '.')) != NULL)
    strcpy (file_extension, (char *) (ptr + 1));
  else
    strcpy (file_extension, "none");
  strcat (file_extension, " ");

  if (!find_associates_by_extension (file_extension, editor, viewer))
    find_associates_by_extension ("none ", editor, viewer);


  command_line = WANT_EDIT ? editor : viewer;

  sprintf (absolute_filename, "%s/%s", current_path, filename);

  if ((ptr = strstr (command_line, "{f}")) || (ptr = strstr (command_line, "{F}")))
    {
      char buf[1024];
      *ptr = 0;
      sprintf (buf, "%s%s%s", command_line, *(ptr + 1) == 'F' ? absolute_filename : filename, ptr + 3);
      strcpy (command_line, buf);
      // _HERE (command_line);
    }
  else
    {
      strcat (command_line, " ");
      strcat (command_line, absolute_filename);
    }

  ptr = strchr (command_line, 32);
  *(ptr++) = 0;

  if (strstr (command_line, "{URL}"))
    {
      open_URL (ptr);
    }
  else if (strstr (command_line, "{TXT}"))
    {
      WANT_EDIT ? TXT_edit (ptr) : TXT_show (ptr);
    }
  else
    IS_REMOTE ? REXEC_execute_program (command_line, ptr, absolute_filename) : execute_program (command_line, ptr);

  g_free (filename);
}







/* TOOLS functions */

/* PUBLIC:
 * TXT_show
 * TXT_edit
 */

void
TXT_show (char *filename)
{
#define DOC_LEN (off_t) stat_buf.st_size

  if (USE_INTERNAL_TXT_VIEWER)
    {
      FILE *in;
      struct stat stat_buf;
      gchar *doc_buf;
      if (access (filename, F_OK) || stat (filename, &stat_buf))
	return;

      if ((doc_buf = (char *) g_malloc (DOC_LEN + 1)) == NULL)
	return;

      MEM0 (doc_buf);

      in = fopen (filename, "r");
      fread (doc_buf, DOC_LEN, 1, in);
      fclose (in);
      doc_buf[DOC_LEN] = 0;

      resizable_text_dialog (filename, doc_buf, 600, 350);

      g_free (doc_buf);
      if (IS_REXEC)
	REXEC_end ();
    }
  else
    {
      // Not Yet Implemented
    }
}



void
TXT_edit (char *filename)
{
  if (USE_INTERNAL_TXT_EDITOR)
    {
      IGLOO_EDIT (filename, IS_REXEC);
    }
  else
    {
      IS_REXEC ? REXEC_execute_program (user_rc.text_editor_command, filename, NULL) : execute_program (user_rc.text_editor_command, filename);
    }
}



void
text_edit_from_widget (GtkWidget * widget, gpointer data)
{
  TXT_edit (data);
}


void
Xterm (void)
{
  execute_command (user_rc.xterm_command);
}



static void
execute_usr_command (GtkWidget * widget, GtkWidget * entry)
{
  GtkWidget *alert_window = gtk_widget_get_toplevel (entry);

  char buf[1024];

  strcpy (buf, gtk_entry_get_text (GTK_ENTRY (entry)));
  gtk_widget_destroy (alert_window);

  if (strlen (buf))
    execute_command (buf);
}


void
execute_usr_command_dialog (GtkWidget * widget, gpointer data)
{
  entry_dialog ("Execute", "Command :", "Execute", "", GTK_SIGNAL_FUNC (execute_usr_command));
}




/* BROWSER functions */

/* PUBLIC:
 * open_web_browser
 * open_mail_client
 * open_new_message
 * open_news_client 
 */

void
open_URL (char *this_url)
{
  char remote_url_buf[2048];
  char program_url_buf[2048];

  if (USE_NETSCAPE)
    {
      if (this_url != NULL)
	{
	  sprintf (remote_url_buf, "openURL(%s,new-window)", this_url);
	  sprintf (program_url_buf, "%s", this_url);
	}
      else
	{
	  sprintf (remote_url_buf, "openURL(%s/html/default.html,new-window)", SHARE_PATH);
	  sprintf (program_url_buf, "%s/html/default.html", SHARE_PATH);
	}

      if (!mozilla_remote (remote_url_buf))
	execute_program ("netscape", program_url_buf);

    }
  else
    execute_program (user_rc.navigator_command, this_url);
}


void
open_URL_from_widget (GtkWidget * widget, gpointer data)
{
  open_URL (data);
}



void
open_mail_client (void)
{
  if (USE_NETSCAPE)
    {
      if (!mozilla_remote ("openInbox"))
	execute_program ("netscape", "-mail");
    }
  else
    execute_program (user_rc.email_client_command, "");
}



void
open_new_message (void)
{
  if (USE_NETSCAPE)
    {
      if (!mozilla_remote ("composeMessage"))
	execute_program ("netscape", "mailto:");
    }
  else
    execute_program (user_rc.email_editor_command, "");
}




void
open_news_client (void)
{

  if (USE_NETSCAPE)
    {
      if (!mozilla_remote ("openNewsgroups"))
	execute_program ("netscape", "-news");
    }
  else
    execute_program (user_rc.news_client_command, "");
}



/* EOF */
