/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>


#include "protos.h"



#define HOW_MANY_DOC 4

void
doc_show_text_file (int this_doc)
{
#define DOC_LEN (off_t) stat_buf.st_size
  FILE *in;
  struct stat stat_buf;
  gchar *doc_buf;
  char doc_path[1024];
  gchar *doc_filename[HOW_MANY_DOC] =
  {"LICENSE", "welcome.msg", "README", "ChangeLog"};
  gchar *doc_title[HOW_MANY_DOC] =
  {"License", "Welcome To IglooFTP", "IglooFTP- Readme", "What's new?"};
  int width[HOW_MANY_DOC] =
  {600, 550, 600, 550};
  int height[HOW_MANY_DOC] =
  {350, 350, 350, 350};


  sprintf (doc_path, "%s/docs/%s", SHARE_PATH, doc_filename[this_doc]);

  if (access (doc_path, F_OK) || stat (doc_path, &stat_buf))
    return;


  if ((doc_buf = (char *) g_malloc (DOC_LEN + 1)) == NULL)
    return;

  MEM0 (doc_buf);

  in = fopen (doc_path, "r");
  fread (doc_buf, DOC_LEN, 1, in);
  fclose (in);
  doc_buf[DOC_LEN] = 0;

  resizable_text_dialog (doc_title[this_doc], doc_buf, width[this_doc], height[this_doc]);

  g_free (doc_buf);
}


void
doc_show_text_file_from_widget (GtkWidget * widget, gpointer data)
{
  doc_show_text_file ((int) GPOINTER_TO_INT (data));
}
