/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

static GtkWidget *rc_window = NULL;
static GtkWidget *entry_username;
static GtkWidget *entry_userpass;
static GtkWidget *entry_local_dir;
static GtkWidget *entry_port;
static GtkWidget *entry_remote_dir;
static GtkWidget *prof_username;
static GtkWidget *prof_userpass;
static GtkWidget *prof_local_dir;
static GtkWidget *clist;
static GtkWidget *button_user_edit;
static GtkWidget *button_user_delete;
static GtkWidget *spin_Rcount;
static GtkWidget *spin_Rdelay;
static GtkWidget *spin_timeout;
static GtkWidget *spin_Idelay;
static GtkWidget *spin_Sbuf;
static GtkWidget *spin_Rbuf;
static GtkWidget *check_idle;
static GtkWidget *check_PASV;
static GtkWidget *check_resolve_lnk;

static GtkWidget *check_uploads_preserve_perm;
static GtkWidget *check_uploads_preserve_date;
static GtkWidget *check_downloads_preserve_perm;
static GtkWidget *check_downloads_preserve_date;

static GtkWidget *spin_queue_max_retries;


static GtkWidget *check_view_toolbar;
static GtkWidget *check_view_connectbar;
static GtkWidget *check_view_console;
static GtkWidget *check_view_queue;
static GtkWidget *check_view_local_prompt;
static GtkWidget *check_view_remote_prompt;
static GtkWidget *check_view_3D_borders;

static GtkWidget *check_view_host_welc_msg;
static GtkWidget *check_view_host_dir_msg;

static GtkWidget *check_view_local_file_size;
static GtkWidget *check_view_local_file_date;
static GtkWidget *check_view_local_file_owner;
static GtkWidget *check_view_local_file_group;
static GtkWidget *check_view_local_file_perm;
static GtkWidget *check_view_local_hidden_file;

static GtkWidget *check_view_remote_file_size;
static GtkWidget *check_view_remote_file_date;
static GtkWidget *check_view_remote_file_owner;
static GtkWidget *check_view_remote_file_group;
static GtkWidget *check_view_remote_file_perm;
static GtkWidget *check_view_remote_hidden_file;

static GtkWidget *check_RDC_enabled;
static GtkWidget *spin_RDC_max_days;
static GtkWidget *spin_console_max_lines;

static GtkWidget *check_use_firewall;
static GtkWidget *entry_firewall_hostname;
static GtkWidget *entry_firewall_port;
static GtkWidget *entry_firewall_username;
static GtkWidget *entry_firewall_userpass;

static GtkWidget *browser_entry;
static GtkWidget *email_client_entry;
static GtkWidget *email_editor_entry;
static GtkWidget *news_client_entry;
static GtkWidget *check_use_netscape;
static GtkWidget *text_editor_entry;
static GtkWidget *xterm_entry;

static gchar *tree_col[] =
{"General", "Appearance", "Applications", "Advanced", "Transfer", "Firewall", "Cache", "Associations"};
#define MAX_CUSTOM_TABS 8






static void create_rc (void);
static void save_rc (void);
static void read_rc (void);

static void user_rc_transfert_mode (GtkWidget * widget, gpointer data);
static void user_rc_host_type (GtkWidget * widget, gpointer data);
static void user_rc_firewall_type (GtkWidget * widget, gpointer data);
static void custom_quit (void);
static void custom_cancel (GtkWidget * widget);
static void custom_reset (GtkWidget * widget);
static void custom_ok (GtkWidget * widget);




static void write_prof (int profile_number, USERprof * this_prof);
static void add_prof (void);
static void edit_prof (void);
static void delete_prof (void);
static void add_or_edit_user_prof_from_file (GtkWidget * widget, int data);
static void delete_user_prof_from_file (GtkWidget * widget, gpointer data);
static void dialog_user_prof (USERprof * this_prof, gchar * title);
static void clear_user_prof (GtkWidget * widget, gpointer data);
static void update_proflist (void);
static void update_button_prof (GtkWidget * this_list, gint row, gint column, GdkEventButton * event, gpointer data);

static void custom_pixmap (GtkWidget * this_window, GtkWidget * this_box);
static void CUSTOM_TREE_select_row (GtkCTree * ctree, GtkCTreeNode * node, gint col, /*GdkEventButton *event, */ GtkWidget * notebook);

/* EOF */
