/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "protos.h"
#include "connectbar.h"






/* CONNECT BAR */

/* PUBLIC
 * show_or_hide_connectbar
 * update_connectbar
 * can_connect
 * fill_combo_user
 * create_connect_bar
 * STATIC :
 * get_or_set_connect_info 
 * connect_entry_key_pressed
 * combo_new_selection
 * set_transfert_mode
 * set_entry_port
 */


void
show_or_hide_connectbar (GtkWidget * widget)
{
  show_hide_widget (handle_box, GTK_CHECK_MENU_ITEM (widget)->active);
}


void
update_connectbar (FTPsession * that_session)	//this_session is the current, so use that_session here to avoid confusion
 {
  DONT_UPDATE_ENTRY_PASS = TRUE;
  gtk_entry_set_text (ENTRY_HOST, that_session->hostname);
  gtk_entry_set_text (ENTRY_PASS, that_session->userpass);
  gtk_entry_set_text (ENTRY_USER, that_session->username);

  set_entry_port (that_session->port);
  gtk_option_menu_set_history (GTK_OPTION_MENU (tmode_option_menu), that_session->tmode);
  DONT_UPDATE_ENTRY_PASS = FALSE;
}


char
was_connectbar_modified (void)
{
  char *this_host = gtk_entry_get_text (ENTRY_HOST);
  char *this_user = gtk_entry_get_text (ENTRY_USER);
  char *this_pass = gtk_entry_get_text (ENTRY_PASS);

  if (!strcmp (this_host, this_session.hostname))
    if (!strcmp (this_user, this_session.username))
      if (!strcmp (this_pass, this_session.userpass))
	return FALSE;

  return TRUE;
}


char
can_connect (void)
{
  gchar *ptr = gtk_entry_get_text (ENTRY_HOST);

  if (!strlen (ptr))
    return FALSE;

  strcpy (this_session.hostname, ptr);
  get_or_set_connect_info ();
  return TRUE;
}



static void
get_or_set_connect_info (void)
{
  gchar *ptr;
  unsigned short int port;

  if (!strlen (ptr = gtk_entry_get_text (ENTRY_USER)))
    {
      gtk_entry_set_text (ENTRY_USER, "anonymous");
      ptr = gtk_entry_get_text (ENTRY_USER);
    }
  else
    strcpy (this_session.username, ptr);

  if (!strlen (ptr = gtk_entry_get_text (ENTRY_PASS)))
    {
      combo_user_new_selection (NULL);
      ptr = gtk_entry_get_text (ENTRY_PASS);
    }
  strcpy (this_session.userpass, ptr);

  if (!strlen (this_session.userpass))
    {
      strcpy (this_session.userpass, user_rc.default_session.userpass);
      gtk_entry_set_text (ENTRY_PASS, this_session.userpass);
    }

  if (!(port = atoi (gtk_entry_get_text (ENTRY_PORT))))
    {
      set_entry_port (user_rc.default_session.port);
      port = user_rc.default_session.port;
    }
  this_session.port = port;
}


static void
connect_entry_key_pressed (GtkWidget * entry, GdkEventKey * event, gpointer data)
{
  if (event->keyval == GDK_Return)
    {
      char *this_host = gtk_entry_get_text (ENTRY_HOST);

      event->keyval = GDK_End;

      if (this_connexion.is_connected && GTK_ENTRY (entry) != ENTRY_HOST)
	return;

      if (!strlen (this_host))
	{
	  error_message ("No FTP host specified.");
	  return;
	}

      IGLOO_connect_or_reconnect ();

    }
}



static void
combo_user_new_selection (GtkWidget * entry)
{
  gchar *ptr = gtk_entry_get_text (ENTRY_USER);

  if (!strcmp (ptr, "anonymous"))
    {
      strcpy (this_session.userpass, user_rc.default_session.userpass);
      strcpy (this_session.local_dir, user_rc.default_session.local_dir);
      gtk_entry_set_text (ENTRY_PASS, this_session.userpass);
      return;
    }

  if (!strcmp (ptr, ""))
    {
      strcpy (this_session.userpass, "");
      gtk_entry_set_text (ENTRY_PASS, this_session.userpass);
      return;
    }

  {
    const int index_total = count_total_number_of_profiles ();
    register int index = 0;
    USERprof this_prof;
    while (index < index_total)
      {
	read_prof (index++, &this_prof);
	if (!strcmp (ptr, this_prof.username))
	  {
	    index = index_total;
	    strcpy (this_session.userpass, this_prof.userpass);
	    strcpy (this_session.local_dir, this_prof.local_dir);
	    gtk_entry_set_text (ENTRY_PASS, this_session.userpass);
	  }

      }
  }

}






void
fill_combo_user (void)
{
  GList *combo_user_items = NULL;
  const int index_total = count_total_number_of_profiles ();
  register int index = 0;
  USERprof this_prof;

  combo_user_items = g_list_append (combo_user_items, "");
  combo_user_items = g_list_append (combo_user_items, "anonymous");

  if (index_total)
    for (index = 0; index < index_total; index++)
      {
	read_prof (index, &this_prof);
	combo_user_items = g_list_append (combo_user_items, strdup (this_prof.username));
      }

  gtk_combo_set_popdown_strings (GTK_COMBO (combo_user), combo_user_items);
  g_list_free (combo_user_items);

  gtk_entry_set_text (ENTRY_USER, "");
}




static void
set_transfert_mode (GtkWidget * widget, gpointer data)
{
  this_session.tmode = (int) GPOINTER_TO_INT (data);

  if ((this_connexion.tmode = this_session.tmode) == TYPE_AUTODETECT)
    this_connexion.tmode = TYPE_IMAGE;
}



static void
set_entry_port (unsigned short int this_port)
{
  char port_buf[10];
  sprintf (port_buf, "%hi", this_port);
  gtk_entry_set_text (ENTRY_PORT, port_buf);
}








void
update_combo_host_history (char *this_host)
{
  char *ptr;
  GList *list = combo_host_items;

  while (list)
    {
      ptr = list->data;
      if (!strcmp (ptr, this_host))
	{
	  gtk_entry_set_text (ENTRY_HOST, this_host);
	  return;
	}
      list = list->next;
    }

  if (combo_host_items == NULL)
    combo_host_items = g_list_append (combo_host_items, strdup (this_host));
  else
    combo_host_items = g_list_insert (combo_host_items, strdup (this_host), 0);

  gtk_combo_set_popdown_strings (GTK_COMBO (combo_host), combo_host_items);
}


static void
load_combo_host_history (void)
{
  FILE *history_file;
  char this_path[MPLEN];
  char this_line[256];

  host_history_path (this_path);

  if (access (this_path, F_OK))
    return;
  if ((history_file = fopen (this_path, "r")) == NULL)
    return;

  while (fgets (this_line, sizeof (this_line), history_file) != NULL)
    {
      if (this_line[strlen (this_line) - 1] == '\n')
	this_line[strlen (this_line) - 1] = 0;

      if (strlen (this_line))
	combo_host_items = g_list_append (combo_host_items, strdup (this_line));
    }
  fclose (history_file);

  if (combo_host_items != NULL)
    gtk_combo_set_popdown_strings (GTK_COMBO (combo_host), combo_host_items);
}


void
save_combo_host_history (void)
{
  FILE *history_file;
  GList *list = combo_host_items;
  char this_path[1024];
  char *ptr;
  int compt = MAX_HOST_HISTORY_LINES;

  host_history_path (this_path);

  if ((history_file = fopen (this_path, "w")) == NULL)
    return;

  while (list && compt--)
    {
      ptr = list->data;
      fprintf (history_file, "%s\n", ptr);
      list = list->next;
    }

  fflush (history_file);
  fclose (history_file);
}






/* DRAG & DROP */
static void
host_drag_data_received (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time)
{

  if (info == DND_TARGET_STRING)
    {
      if ((data->length >= 0) && (data->format == 8))
	{
	  printf ("DND [CONNECTBAR] Received \"%s\"\n", (gchar *) data->data);
	  gtk_drag_finish (context, TRUE, FALSE, time);
	  IGLOO_connect_from_URL (g_strdup ((gchar *) data->data));
	}
      else
	gtk_drag_finish (context, FALSE, FALSE, time);
    }
}






GtkWidget *
create_connect_bar (GtkWidget * main_vbox)
{
  GtkWidget *vbox;
  GtkWidget *frame;
  GtkWidget *hbox_left;
  GtkWidget *menu_item;
  GtkWidget *hbox_right;
  GtkWidget *option_menu_submenu;

/* DND */
  static GtkTargetEntry DND_target_table[] =
  {
    {"STRING", 0, DND_TARGET_STRING}

  };
#define  DND_TARGETS  1


  handle_box = gtk_handle_box_new ();
  gtk_box_pack_start (GTK_BOX (main_vbox), handle_box, FALSE, FALSE, 0);
  show_hide_widget (handle_box, user_rc.view_connectbar);


  frame = gtk_frame_new (NULL);
  gtk_container_border_width (GTK_CONTAINER (frame), 0);
  gtk_widget_set_usize (frame, -1, 28);
  gtk_widget_show (frame);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_OUT);
  gtk_container_add (GTK_CONTAINER (handle_box), frame);


  vbox = v_box (frame, FALSE, 0, 0);

  hbox_left = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox_left);
  gtk_box_pack_start (GTK_BOX (vbox), hbox_left, TRUE, TRUE, 0);


  create_label (hbox_left, "FTP Host : ", GTK_JUSTIFY_LEFT, 5, 0);

  combo_host = gtk_combo_new ();
  gtk_widget_show (combo_host);
  gtk_box_pack_start (GTK_BOX (hbox_left), combo_host, TRUE, TRUE, 0);
  load_combo_host_history ();


  gtk_drag_dest_set (GTK_COMBO (combo_host)->entry,
		     GTK_DEST_DEFAULT_ALL,
		     DND_target_table, DND_TARGETS,
		     GDK_ACTION_COPY);

  gtk_signal_connect (GTK_OBJECT (GTK_COMBO (combo_host)->entry), "drag_data_received",
		      GTK_SIGNAL_FUNC (host_drag_data_received), NULL);


  hbox_right = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox_right);
  gtk_box_pack_start (GTK_BOX (hbox_left), hbox_right, FALSE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (hbox_right), 2);

  create_label (hbox_right, "User : ", GTK_JUSTIFY_LEFT, 5, 0);

  combo_user = gtk_combo_new ();
  gtk_widget_set_usize (combo_user, 100, -1);
  gtk_widget_set_usize (GTK_COMBO (combo_user)->entry, 100, -1);
  gtk_widget_show (combo_user);
  gtk_box_pack_start (GTK_BOX (hbox_right), combo_user, TRUE, TRUE, 0);
  fill_combo_user ();


  create_label (hbox_right, "Pass : ", GTK_JUSTIFY_LEFT, 5, 0);

  entry_pass = gtk_entry_new ();
  gtk_widget_show (entry_pass);
  gtk_box_pack_start (GTK_BOX (hbox_right), entry_pass, TRUE, TRUE, 0);
  gtk_widget_set_usize (entry_pass, 80, -1);
  gtk_entry_set_visibility (GTK_ENTRY (entry_pass), FALSE);

  create_label (hbox_right, "Port : ", GTK_JUSTIFY_LEFT, 5, 0);

  entry_port = gtk_entry_new ();
  gtk_widget_show (entry_port);
  gtk_box_pack_start (GTK_BOX (hbox_right), entry_port, TRUE, TRUE, 0);
  gtk_widget_set_usize (entry_port, 40, -1);

  if (this_session.port)
    set_entry_port (this_session.port);


  create_label (hbox_right, "", GTK_JUSTIFY_LEFT, 5, 0);

  tmode_option_menu = gtk_option_menu_new ();

  gtk_widget_show (tmode_option_menu);
  gtk_widget_set_usize (tmode_option_menu, 70, -1);
  gtk_box_pack_start (GTK_BOX (hbox_right), tmode_option_menu, TRUE, TRUE, 0);

  option_menu_submenu = gtk_menu_new ();

  menu_item = append_option_menu_item (option_menu_submenu, "Auto");
  gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
   GTK_SIGNAL_FUNC (set_transfert_mode), GINT_TO_POINTER (TYPE_AUTODETECT));

  menu_item = append_option_menu_item (option_menu_submenu, "ASCII");
  gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
	GTK_SIGNAL_FUNC (set_transfert_mode), GINT_TO_POINTER (TYPE_ASCII));

  menu_item = append_option_menu_item (option_menu_submenu, "Image");
  gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
	GTK_SIGNAL_FUNC (set_transfert_mode), GINT_TO_POINTER (TYPE_IMAGE));

  menu_item = append_option_menu_item (option_menu_submenu, "Local");
  gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
	GTK_SIGNAL_FUNC (set_transfert_mode), GINT_TO_POINTER (TYPE_LOCAL));

  gtk_option_menu_set_menu (GTK_OPTION_MENU (tmode_option_menu), option_menu_submenu);
  gtk_option_menu_set_history (GTK_OPTION_MENU (tmode_option_menu), this_session.tmode);



  gtk_signal_connect (GTK_OBJECT (GTK_COMBO (combo_user)->popwin), "button_press_event",
		      GTK_SIGNAL_FUNC (combo_user_new_selection), NULL);



  gtk_signal_connect (GTK_OBJECT (ENTRY_USER), "key_press_event",
		      GTK_SIGNAL_FUNC (connect_entry_key_pressed), NULL);

  gtk_signal_connect (GTK_OBJECT (ENTRY_HOST), "key_press_event",
		      GTK_SIGNAL_FUNC (connect_entry_key_pressed), NULL);

  gtk_signal_connect (GTK_OBJECT (ENTRY_PASS), "key_press_event",
		      GTK_SIGNAL_FUNC (connect_entry_key_pressed), NULL);

  gtk_signal_connect (GTK_OBJECT (ENTRY_PORT), "key_press_event",
		      GTK_SIGNAL_FUNC (connect_entry_key_pressed), NULL);

  return frame;
}



/* EOF */
