/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

typedef struct
  {
    GtkWidget *edit_window;
    GtkAccelGroup *edit_accel;
    GtkWidget *edit_text;
    GtkWidget *edit_size_label;
    GtkWidget *edit_status_label;
    GtkWidget *edit_pos_label;
    GtkWidget *menu_save;
    GtkWidget *toolbar_save;
    char name[1024];
    char modified;
    char REXEC;
  }
TEXTinfo;



static void IGLOO_EDIT_set_window_title (TEXTinfo * text_info);
static void IGLOO_EDIT_show_size (TEXTinfo * text_info);
static void IGLOO_EDIT_show_pos (TEXTinfo * text_info);

static void IGLOO_EDIT_load_file (TEXTinfo * text_info);
static void IGLOO_EDIT_save_file (TEXTinfo * text_info);

static void IGLOO_EDIT_save (GtkWidget * widget, TEXTinfo * text_info);
static void IGLOO_EDIT_save_on_fileselect_ok (GtkWidget * widget, TEXTinfo * text_info);
static void IGLOO_EDIT_save_as (GtkWidget * widget, TEXTinfo * text_info);
static void IGLOO_EDIT_open_on_fileselect_ok (GtkWidget * widget, TEXTinfo * text_info);
static void IGLOO_EDIT_open (GtkWidget * widget, TEXTinfo * text_info);
static void IGLOO_EDIT_new (GtkWidget * widget, TEXTinfo * text_info);

static char IGLOO_EDIT_ask_to_save_modified_file (TEXTinfo * text_info);
static void IGLOO_EDIT_quit (GtkWidget * widget, TEXTinfo * text_info);
static gint IGLOO_EDIT_delete_event (GtkWidget * widget, GdkEvent * event, TEXTinfo * text_info);
static void IGLOO_EDIT_destroy_window (GtkWidget * widget, TEXTinfo * text_info);

static void IGLOO_EDIT_text_change (GtkWidget * widget, TEXTinfo * text_info);
static void IGLOO_EDIT_key_press (GtkWidget * widget, GdkEventKey * event, TEXTinfo * text_info);
static void IGLOO_EDIT_create_menu (GtkWidget * vbox, TEXTinfo * text_info);
static void IGLOO_EDIT_create_toolbar (GtkWidget * window, GtkWidget * vbox, TEXTinfo * text_info);
static void IGLOO_EDIT_save_set_sensitive (TEXTinfo * text_info, char FLAG);

/* EOF */
