// **********************************************************************************************
// *											    	*
// *	GetFtp Version 1.0, 04/08/1997, By L.ARNAL.						*
// *												*
// *		Get a ftp tree from a host.						    	*
// *												*
// **********************************************************************************************


#include <stdio.h>
#include <stdlib.h>

#include <unistd.h>
#include <fcntl.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>

#include <iostream.h>
#include <fstream.h>
#include <strstream.h>


#define MAXPATH 400			// max path name

extern "C"
{
 #include "ftplib.h"
};

#ifdef sgi
  extern int errno;
#endif

#define default_log  	"anonymous"
#define default_pass 	"joe@nowhere.bogus"
#define maximum_depth	-1

// **********************************************************************************************
// *											    	*
// *	Parse a line from the command ftpDir: 							*
// *												*
// *	assume the format is :									*
// *	       drwxrwxrwx   2 0        0            1024 Jan 10 12:24 name			*
// *												*								*
// *	where name is the name of a directory or file.						*
// *												*
// *												*
// **********************************************************************************************

void Parse(char *buffer,char *name,char *sup,int &directory,int &lien)

{
 char 		dr[100];
 int  		num1;
 char  		owner[100];
 char 		group[100];
 int  		size;
 char 		month[20];
 int  		day;
 char 		date[20];
 char		c;
 int		i;
 int		pos;
 int 		clien;

 // parse the buffer in a strstream.

 strstream st;
 st << buffer;

 st >> dr;					// acces right
 st >> num1;					// ??
 st >> owner;					// owner
 st >> group;					// group
 st >> size;					// size
 st >> month;					// month
 st >> day;					// day
 st >> date;					// date
 st.get(c);
 st.getline(name,MAXPATH,'\n');			// name
	
 // *********** cut last car if it's a newline or carrier return *****************************************
	
 if (name[strlen(name)-1]=='\r') name[strlen(name)-1]=0;
 else if (name[strlen(name)-1]=='\n') name[strlen(name)-1]=0;

 // *********** test first permission car to see if it's a directory or a link ***************************
 
 directory=0;
 lien=0;
 if (dr[0]=='d') directory=1;
 if (dr[0]=='l') lien=1;

 // *********** if it's a link, cut the name ************************************************

 if (lien)
    { 
     i=2;
     clien=0;
     
     while (!clien && i<strlen(name))
           {
            if (name[i]=='>' && name[i-1]=='-') clien=1;
            i++;
           }

     char buf[MAXPATH];

     strcpy(buf,name);
     pos=strlen(buf)-(i+1)+1;

     strncpy(sup,&buf[i+1],pos);
     sup[pos]=0;

     pos=i-3;
     strncpy(name,&buf[0],pos);
     name[pos]=0;
    }

}

// **********************************************************************************************
// *											    	*
// *												*
// **********************************************************************************************

void GetLink(char *linkname,char *path,char *localdir,int depth,int maxdepth,int verbose, netbuf *NetBuf);
void GetDir(char *path,char *localdir,int depth,int maxdepth,int verbose, netbuf *NetBuf);
void MakeInitialDirectory(char *dir,char *localdir,int verbose,int &depth);


// **********************************************************************************************
// *											    	*
// *	Get a link "linkname" relative to path "path" in directory "localdir": 			*
// *		!: this is a recursive function.						*
// *												*
// *	   depth    : the depth of the directory.						*
// *	   maxdepth : maximum depth we want.							*
// *												*
// *												*
// **********************************************************************************************

void GetLink(char *linkname,char *path,char *localdir,int depth,int maxdepth,int verbose, netbuf *NetBuf,int &relative)

{
 int  i;
 int  j;
 int  pos;
 char buffer[MAXPATH];
 char directory_to_get[MAXPATH];
 char locallinkname[MAXPATH];
 char localpath[MAXPATH];

 relative = 0;

 strcpy(locallinkname,linkname);
 strcpy(localpath,path);

 if (verbose) 
    {
     cout << endl;
     cout << "Getting link                      : " << linkname << endl;
    }

 i=0;
 while (locallinkname[i]=='.' && locallinkname[i+1]=='.')
       {
	i+=3;
	chdir("..");

	j=strlen(localpath)-1;
	while (localpath[j]!='/') j--;
	localpath[j]=0;
	depth--;
	relative=1;
       }

 if (i>0)
    {
     strcpy(buffer,locallinkname);
     pos=strlen(buffer)-i+2;
     strncpy(locallinkname,&buffer[i-1],pos); 
    }


 if (relative)
    { 
     strcpy(directory_to_get,localpath);
     strcat(directory_to_get,locallinkname);
    }
    else strcpy(directory_to_get,locallinkname);
 
 MakeInitialDirectory(directory_to_get,localdir,verbose,depth);
 GetDir(directory_to_get,localdir,depth,maxdepth,verbose,NetBuf);
}

// **********************************************************************************************
// *											    	*
// *	Get a directory "path" in "localdir": 							*
// *		!: this is a recursive function.						*
// *												*
// *	   depth    : the depth of the directory.						*
// *	   maxdepth : maximum depth we want.							*
// *												*
// *												*
// **********************************************************************************************


void GetDir(char *path,char *localdir,int depth,int maxdepth,int verbose, netbuf *NetBuf)

{
 char bufferdir[MAXPATH];

 // ************************** changing remote directory ****************************************

 if (verbose)
    {
     cout << endl;
     cout << "Entering ftp directory            : " << path << endl;
    }

 if (!FtpChdir(path,NetBuf))
    {
     if (verbose) cout << "?Error                            : Wrong directory." << endl;
     return;
    }
 
 depth++;

 // ************************** create a local directory for the remote directory ****************


 strcpy(bufferdir,localdir);

 if (strcmp(path,"/")!=0) 
    strcat(bufferdir,path);
         
 if (verbose) cout << "Creating and Entering directory   : " << bufferdir << endl;
  
 if (strcmp(path,"/")!=0) 
    if (mkdir(bufferdir,0755)<0)
       {
        if (verbose) cout << "!Warning                          : directory already exists." << endl;
	return;
       }
       

 if (chdir(bufferdir)<0)
    {
     if (verbose) cout << "?Error                            : Can't change to directory." << endl;
     exit(1);
    }


 // ***************** obtain remote directory listing in file .list of the current directory ****

 FtpDir(".list",path,NetBuf);


 // ***************** parse the listing of the directory **************************************** 

 ifstream 	i(".list");

 char 		bufferl[MAXPATH];
 int 		numlig			=0;
 char		name[MAXPATH];
 char		linkname[MAXPATH];
 int 	 	directory;			 // is it a directory
 int		lien;				 // is it a link
  

 // **************** For each entry in the directory list ***************************************
 
 while (!i.eof())
       {
	// ------- get 1 result from FtpDir -----------------------

        i.getline(bufferl,MAXPATH,'\n');

	// ------- skip the first line : number of file -----------

	if ((numlig>0) && (strcmp(bufferl,"")!=0)) 
           {
	    // -------- Parse the entry    ------------------------
	    
	    Parse(bufferl,name,linkname,directory,lien);

	    // -------- skip special entry ------------------------

	    if ((name[0]!='!') && (strcmp(name,".")!=0) && (strcmp(name,"..")!=0))
	       {
		if (directory) 
                   {
		    if  (depth!=maxdepth)
			{ 
 		         // ------------------------------------- it's a directory ---------------------
		         // ------ get newpath from actual path and directory path, then recurse -------

 		         char newpath[MAXPATH];


		         if (strcmp(path,"/")!=0) strcpy(newpath,path);
					     else strcpy(newpath,"");
	 
		         strcat(newpath,"/");
		         strcat(newpath,name);
	
		         GetDir(newpath,localdir,depth,maxdepth,verbose,NetBuf);		     
		         // -----  Don't forget to get back in directory tree --------------------------

		         chdir("..");
                        }
			else
			    {
		             if (verbose) cout << "!Warning                          : maxdepth is reach." << endl;
			    }
                   }
	        else if (lien)
		   {
		    int relative;
		    GetLink(linkname,path,localdir,depth,maxdepth,verbose,NetBuf,relative);

		    if (chdir(bufferdir)<0) 
		       {
		        if (verbose) cout << "?Error                            : Can't get back to directory." << endl;
     			exit(1);
    		       }
			
		    if (!FtpChdir(path,NetBuf))
    		       {
		        if (verbose) cout << "?Error                            : Can't change back to ftp directory." << endl;
 		        return;
		       }

		    if (verbose) cout << "Linking                           : " << linkname << " to " << name << endl;

		    char newlinkname[MAXPATH];
		    if (!relative) strcpy(newlinkname,localdir);
		    	      else strcpy(newlinkname,"");

		    strcat(newlinkname,linkname);
		    
		    if (symlink(newlinkname,name)!=0)
		       cout << "errno:" << errno << endl;
		   }	
		else
		   {
		    // ------------------------- it's a file -----------------------

		    char outfile[MAXPATH];
		    char infile[MAXPATH];

		    if (strcmp(path,"/")!=0) strcpy(infile,path);
				        else strcpy(infile,"");
		    strcat(infile,"/");
		    strcat(infile,name);
		    strcpy(outfile,localdir);		
		    strcat(outfile,infile);

		    if (verbose) cout << "Getting File                      : " << infile << " to " << outfile << endl;

		    // ------------------------- so get it -------------------------
				    
		    if (!FtpGet(outfile,infile,'I',NetBuf))
		       {
		        if (verbose) cout << "?Error                            : Can't get file." << endl;
	               }   

		   }
	       }
	   }
 
	numlig++;
       }
        
}


// **********************************************************************************************
// *											    	*
// *												*
// **********************************************************************************************


void MakeInitialDirectory(char *dir,char *localdir,int verbose,int &depth)

{
 char temp[MAXPATH];
 char bufferdir[MAXPATH];
 int  i				=1;

 while (i<strlen(dir))
       {
	if (dir[i]=='/')
           {
	    strcpy(bufferdir,localdir);

	    strcpy(temp,dir);
	    temp[i]=0;

	    strcat(bufferdir,temp);

	    if (verbose) cout << "Create Initiale directory         : " << bufferdir << endl;

            if (mkdir(bufferdir,0755)<0)
	       if (verbose) cout << "!Warning                          : directory already exists." << endl;
	  

            if (chdir(bufferdir)<0)
               {
                if (verbose) cout << "?Error                            : Can't change to directory." << endl;
                exit(1);
               } 
	    depth++;
	   }

	i++;
       }
}


// **********************************************************************************************
// *											    	*
// *	GetFtp(char *host,char *directory,char *username,char *pass,int verbose,int maxdepth)	*										    	*
// *											    	*
// *        get "host" ftp "directory" with "username" login and "pass" in current local 	*
// *          directory.									*
// *											    	*
// *		maxdepth is the maximum depth of the directory recursion 			*
// *		verbose is wether message are write or not on stdout				*
// *												*
// *												*
// **********************************************************************************************



void GetFtp(char *host,char *directory,char *username,char *pass,int verbose,int maxdepth)

{
 netbuf *NetBuf;
 
 // --------------------- get actual dir -----------------------------
 char dir[400];
 getcwd(dir,400);


 if (verbose) 
    {
     cout << endl;
     cout << "Getting " << directory << " from " << host << endl;
     cout << "User                              : " << username << endl;
     cout << "pass                              : " << pass << endl;
     cout << "maxdepth                          : " << maxdepth << endl;
     cout << "Current directory                 : " << dir << endl;
     cout << endl;
    }

 // --------------------- Initialisation -----------------------------

 FtpInit();

 // --------------------- Open the host ------------------------------

 if (!FtpConnect(host,&NetBuf))
    {
     if (verbose) cout << "?Error                            : Can't open host." << endl;
     exit(1);
    }

 // --------------------- Login --------------------------------------
 
 if (!FtpLogin(username,pass,NetBuf))
    {
     if (verbose) cout << "?Error                            : Can't login." << endl;
     exit(1);
    }


 // --------------------- Begin by getting the first directory -------

 int depth=0;

 MakeInitialDirectory(directory,dir,verbose,depth);
 GetDir(directory,dir,depth,maxdepth,verbose,NetBuf);

 // --------------------- Quit ---------------------------------------

 FtpQuit(NetBuf);
}

   
// **********************************************************************************************
// *											    	*
// *	 Main function									    	*
// *											    	*
// *											    	*
// *												*
// *												*
// **********************************************************************************************


void main(int argc,char *argv[])

{
 int	parse_error		= 0;
 int 	verbose			= 0;
 int 	maxdepth		= -1;
 int	numpar			= 0;
 
 char 	user[MAXPATH];
 char 	pass[MAXPATH];
 char 	host[MAXPATH];
 char 	directory[MAXPATH];

 strcpy(host,"");
 strcpy(directory,"");
 strcpy(user,default_log);
 strcpy(pass,default_pass);
 

 // ------------------------- parse command line option --------------------------------

 if (argc<3) parse_error=1;
 else
    {
     int p=1;

     while (p<argc && !parse_error) 
	   {
	    if (strcmp(argv[p],"-h")==0) parse_error=1;
	    else if (strcmp(argv[p],"--h")==0) parse_error=1;
	    else if (strcmp(argv[p],"--help")==0) parse_error=1;
	    else if (strcmp(argv[p],"-help")==0) parse_error=1;

	    else if (strcmp(argv[p],"-v")==0) verbose=1;

	    else if ((strlen(argv[p])>2) && (argv[p][0]=='-') && (argv[p][1]=='m')) 
		    {
		     if (strlen(argv[p])<4) parse_error=1;
		     else
			{
			  maxdepth=((int(argv[p][2])-48)*10)+(int(argv[p][3])-48);
			  if (maxdepth<0) parse_error=1;
			}
		    }

	    else if ((strlen(argv[p])>3) && (argv[p][0]=='-') && (argv[p][1]=='u') && (argv[p][2]==':')) 
		    {
		     strncpy(user,&argv[p][3],strlen(argv[p])-3);
		     user[strlen(argv[p])-3]=0; 
		    }
	    else if ((strlen(argv[p])>3) && (argv[p][0]=='-') && (argv[p][1]=='p') && (argv[p][2]==':')) 
		    {
		     strncpy(pass,&argv[p][3],strlen(argv[p])-3);
		     pass[strlen(argv[p])-3]=0;
		    }
	    else if (argv[p][0]=='-') parse_error=1;
	    else
		{
		 if (numpar==0) strcpy(host,argv[p]);
		 else if (numpar==1) strcpy(directory,argv[p]);
		 else parse_error=1;
		
		 numpar++;
		}

	    p++;
	   }
    }


 if (strcmp(host,"")==0) parse_error=1;
 if (strcmp(directory,"")==0) parse_error=1;

 // ------------------------------------------ Banner ---------------------------------------

 cout << endl;
 cout << "---------------------------------------" << endl;
 cout << "-- FtpGet Version 1.0                --" << endl;
 cout << "-- By L.Arnal (arnal@limsi.fr), 1997 --" << endl;
 cout << "---------------------------------------" << endl;
 cout << endl;

 // ------------------------------------- Help screen ----------------------------------------

 if (parse_error)
    {
     cout << "FtpGet option host directory" << endl;
     cout << endl;
     cout << "Where:" << endl;
     cout << endl;
     cout << "   -h      : this screen .              " << endl;
     cout << "   -v      : verbose mode.              " << endl;
     cout << "   -u:user : user name.                 " << endl;
     cout << "   -p:pass : password.                  " << endl;
     cout << "   -mxx    : xx is max directory depth. " << endl;
     cout << endl;
     exit(1);
    }     


 // ---------------------------------------- Go and get it ----------------------------------


 GetFtp(host,directory,user,pass,verbose,maxdepth);
 cout << endl;
}

