/*
 *
 * telprox -- a simple telnet proxy daemon
 *
 * This software is free, go ahead and use it! It is
 * distributed under the GNU General Public License
 *
 * Author: faramir@drunken.scots.net  1997
 *
 * please see the file 'README'
 */

#ifndef TELPROX_H
#define TELPROX_H

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <signal.h>
#include <errno.h>
#include <time.h>
#include <netdb.h>
#include <sys/ioctl.h>
#include <ctype.h>

#include "getparam.h"

#define BUFSIZE 16384
#define GREET_MSG "telprox -- telnet proxying "
#define VERS_MSG "version 0.7"
#define NOTAUTH_MSG "sorry, you are not authorized to use this service"

#ifndef TRUE
#define TRUE 1
#define FALSE !TRUE
#endif

typedef char bool;

int port = 0;

char configname[] = "telprox.conf";

/* default values of the configurable parameters */
int default_port = 1536;
char *proxy_host = "000.000.000.000";   /* where the proxied site is */
static int proxy_port = 23;

int silent = 0;        /* controls output of XXX_MSG messages */

/* the following two are useful only if the proxy server is multihomed */
char *listen_host = "000.000.000.000";  /* what IP to listen for service
					  * requests from */
char *connect_host = "000.000.000.000"; /* what IP to connect to the
					  * proxied site from */

char *logfile = "telprox.log";       /* where to log activity */

void add_allow(char* str);
void add_deny(char* str);

PARAM	Paramtab[] =
{
	{ "host:",      STRING,  (int *)&proxy_host	 },
	{ "listen-on:", STRING,  (int *)&listen_host	 },
	{ "connect-on:", STRING,  (int *)&connect_host	 },
	{ "port:", INTEGER, &proxy_port		         },
	{ "local-port:", INTEGER, &default_port		 },
        { "allow:", PROC,   (int *)add_allow             },
        { "deny:", PROC,    (int *)add_deny              },
	{ "logfile:",   STRING,  (int *)&logfile	 },
        { "silent", BOOLEAN, (int *)&silent              }
};

#define TABSIZE ( sizeof( Paramtab ) / sizeof( PARAM ) )


fd_set fd_start, fd_read;
struct timeval tv;
int timeout = 0, child_pid = 0, socket_plr = 0;
bool proxy_up;

int socket_in, socket_in2, socket_mud;
int sockoptions = 0xffffffff;
struct linger hang_around  = { 1, 5 };  /* 5 secs  */
struct sockaddr_in s, s2, out_s;

typedef struct list
{
        long int addr;       /* Note: NBO !! */
        struct list *next;
} list;

list *allowed;
list *denied;

int add(list** l, long int val);
int found(list* l, long int val);
int allow(long int addr);
void prune_allowed();

bool relay_buffer( int, int );
void clear_fds();
int proxy_init();
int net_main();
int manage_connections();
void printaddr(char* sb);
int notify_failed();

#endif /* TELPROX_H */







